@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.ImageReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The image reference properties.
 * @property exactVersion Specifies in decimal numbers, the exact version of image used to create the virtual machine.
 * @property offer Specifies the offer of the image used to create the virtual machine.
 * @property publisher The image publisher.
 * @property sku The image SKU.
 * @property version Specifies the version of the image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available.
 */
public data class ImageReferenceArgs(
    public val exactVersion: Output<String>? = null,
    public val offer: Output<String>? = null,
    public val publisher: Output<String>? = null,
    public val sku: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.ImageReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.ImageReferenceArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.ImageReferenceArgs.builder()
            .exactVersion(exactVersion?.applyValue({ args0 -> args0 }))
            .offer(offer?.applyValue({ args0 -> args0 }))
            .publisher(publisher?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageReferenceArgs].
 */
@PulumiTagMarker
public class ImageReferenceArgsBuilder internal constructor() {
    private var exactVersion: Output<String>? = null

    private var offer: Output<String>? = null

    private var publisher: Output<String>? = null

    private var sku: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Specifies in decimal numbers, the exact version of image used to create the virtual machine.
     */
    @JvmName("ammwueuskxlufqyj")
    public suspend fun exactVersion(`value`: Output<String>) {
        this.exactVersion = value
    }

    /**
     * @param value Specifies the offer of the image used to create the virtual machine.
     */
    @JvmName("brhukpygieiprmgs")
    public suspend fun offer(`value`: Output<String>) {
        this.offer = value
    }

    /**
     * @param value The image publisher.
     */
    @JvmName("lirobwbqielwpsrb")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value The image SKU.
     */
    @JvmName("poiqnycnsaoekrmx")
    public suspend fun sku(`value`: Output<String>) {
        this.sku = value
    }

    /**
     * @param value Specifies the version of the image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available.
     */
    @JvmName("iymrvehgbjidqprq")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Specifies in decimal numbers, the exact version of image used to create the virtual machine.
     */
    @JvmName("qjqeovsrhxmtjdix")
    public suspend fun exactVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exactVersion = mapped
    }

    /**
     * @param value Specifies the offer of the image used to create the virtual machine.
     */
    @JvmName("wrloycwpeoakerwq")
    public suspend fun offer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offer = mapped
    }

    /**
     * @param value The image publisher.
     */
    @JvmName("kicdaxvibjntelda")
    public suspend fun publisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    /**
     * @param value The image SKU.
     */
    @JvmName("voqgbtoynfepgoud")
    public suspend fun sku(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param value Specifies the version of the image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available.
     */
    @JvmName("nbukmwsqovexerlb")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ImageReferenceArgs = ImageReferenceArgs(
        exactVersion = exactVersion,
        offer = offer,
        publisher = publisher,
        sku = sku,
        version = version,
    )
}
