@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.NSDArtifactProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Artifact profile properties.
 * @property artifactName Artifact name.
 * @property artifactStoreReference The artifact store resource id
 * @property artifactVersion Artifact version.
 */
public data class NSDArtifactProfileArgs(
    public val artifactName: Output<String>? = null,
    public val artifactStoreReference: Output<ReferencedResourceArgs>? = null,
    public val artifactVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.NSDArtifactProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.NSDArtifactProfileArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.NSDArtifactProfileArgs.builder()
            .artifactName(artifactName?.applyValue({ args0 -> args0 }))
            .artifactStoreReference(
                artifactStoreReference?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .artifactVersion(artifactVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NSDArtifactProfileArgs].
 */
@PulumiTagMarker
public class NSDArtifactProfileArgsBuilder internal constructor() {
    private var artifactName: Output<String>? = null

    private var artifactStoreReference: Output<ReferencedResourceArgs>? = null

    private var artifactVersion: Output<String>? = null

    /**
     * @param value Artifact name.
     */
    @JvmName("qgqtvcqvfuvuhtcn")
    public suspend fun artifactName(`value`: Output<String>) {
        this.artifactName = value
    }

    /**
     * @param value The artifact store resource id
     */
    @JvmName("gcugqugfxqpabxux")
    public suspend fun artifactStoreReference(`value`: Output<ReferencedResourceArgs>) {
        this.artifactStoreReference = value
    }

    /**
     * @param value Artifact version.
     */
    @JvmName("ctypquoxlbegrydf")
    public suspend fun artifactVersion(`value`: Output<String>) {
        this.artifactVersion = value
    }

    /**
     * @param value Artifact name.
     */
    @JvmName("iwnbjnvbxhisahax")
    public suspend fun artifactName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactName = mapped
    }

    /**
     * @param value The artifact store resource id
     */
    @JvmName("mxqnedlqranrtgbp")
    public suspend fun artifactStoreReference(`value`: ReferencedResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactStoreReference = mapped
    }

    /**
     * @param argument The artifact store resource id
     */
    @JvmName("dyffmsudtmusuntn")
    public suspend
    fun artifactStoreReference(argument: suspend ReferencedResourceArgsBuilder.() -> Unit) {
        val toBeMapped = ReferencedResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.artifactStoreReference = mapped
    }

    /**
     * @param value Artifact version.
     */
    @JvmName("ofifoqivxfmbopgx")
    public suspend fun artifactVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactVersion = mapped
    }

    internal fun build(): NSDArtifactProfileArgs = NSDArtifactProfileArgs(
        artifactName = artifactName,
        artifactStoreReference = artifactStoreReference,
        artifactVersion = artifactVersion,
    )
}
