@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.NetworkFunctionTemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The network function template.
 * @property networkFunctionRoleConfigurations An array of network function role definitions.
 */
public data class NetworkFunctionTemplateArgs(
    public val networkFunctionRoleConfigurations: Output<List<NetworkFunctionRoleConfigurationArgs>>? =
        null,
) : ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.NetworkFunctionTemplateArgs> {
    override fun toJava(): com.pulumi.azurenative.hybridnetwork.inputs.NetworkFunctionTemplateArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.NetworkFunctionTemplateArgs.builder()
            .networkFunctionRoleConfigurations(
                networkFunctionRoleConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [NetworkFunctionTemplateArgs].
 */
@PulumiTagMarker
public class NetworkFunctionTemplateArgsBuilder internal constructor() {
    private var networkFunctionRoleConfigurations: Output<List<NetworkFunctionRoleConfigurationArgs>>? =
        null

    /**
     * @param value An array of network function role definitions.
     */
    @JvmName("fmhxrvguqobughwq")
    public suspend
    fun networkFunctionRoleConfigurations(`value`: Output<List<NetworkFunctionRoleConfigurationArgs>>) {
        this.networkFunctionRoleConfigurations = value
    }

    @JvmName("aabisotrfwajiykm")
    public suspend fun networkFunctionRoleConfigurations(
        vararg
        values: Output<NetworkFunctionRoleConfigurationArgs>,
    ) {
        this.networkFunctionRoleConfigurations = Output.all(values.asList())
    }

    /**
     * @param values An array of network function role definitions.
     */
    @JvmName("ltaqgnmquerfxpes")
    public suspend
    fun networkFunctionRoleConfigurations(values: List<Output<NetworkFunctionRoleConfigurationArgs>>) {
        this.networkFunctionRoleConfigurations = Output.all(values)
    }

    /**
     * @param value An array of network function role definitions.
     */
    @JvmName("ifqqlyvuymmkuwko")
    public suspend
    fun networkFunctionRoleConfigurations(`value`: List<NetworkFunctionRoleConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFunctionRoleConfigurations = mapped
    }

    /**
     * @param argument An array of network function role definitions.
     */
    @JvmName("xyxjawwfdlvvbolp")
    public suspend
    fun networkFunctionRoleConfigurations(argument: List<suspend NetworkFunctionRoleConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkFunctionRoleConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkFunctionRoleConfigurations = mapped
    }

    /**
     * @param argument An array of network function role definitions.
     */
    @JvmName("qsnwpigkmhxrngth")
    public suspend fun networkFunctionRoleConfigurations(
        vararg
        argument: suspend NetworkFunctionRoleConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NetworkFunctionRoleConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkFunctionRoleConfigurations = mapped
    }

    /**
     * @param argument An array of network function role definitions.
     */
    @JvmName("lvdjavhystlulntg")
    public suspend
    fun networkFunctionRoleConfigurations(argument: suspend NetworkFunctionRoleConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            NetworkFunctionRoleConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.networkFunctionRoleConfigurations = mapped
    }

    /**
     * @param values An array of network function role definitions.
     */
    @JvmName("iatiybgagrehvdti")
    public suspend fun networkFunctionRoleConfigurations(
        vararg
        values: NetworkFunctionRoleConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkFunctionRoleConfigurations = mapped
    }

    internal fun build(): NetworkFunctionTemplateArgs = NetworkFunctionTemplateArgs(
        networkFunctionRoleConfigurations = networkFunctionRoleConfigurations,
    )
}
