@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.inputs

import com.pulumi.azurenative.hybridnetwork.inputs.OpenDeploymentResourceReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Non secret deployment resource id reference.
 * @property id Resource ID.
 * @property idType The resource reference arm id type.
 * Expected value is 'Open'.
 */
public data class OpenDeploymentResourceReferenceArgs(
    public val id: Output<String>? = null,
    public val idType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.hybridnetwork.inputs.OpenDeploymentResourceReferenceArgs> {
    override fun toJava():
        com.pulumi.azurenative.hybridnetwork.inputs.OpenDeploymentResourceReferenceArgs =
        com.pulumi.azurenative.hybridnetwork.inputs.OpenDeploymentResourceReferenceArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .idType(idType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OpenDeploymentResourceReferenceArgs].
 */
@PulumiTagMarker
public class OpenDeploymentResourceReferenceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var idType: Output<String>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("rwealbkekjauvbsq")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The resource reference arm id type.
     * Expected value is 'Open'.
     */
    @JvmName("tdfkcknyifttmopn")
    public suspend fun idType(`value`: Output<String>) {
        this.idType = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("yvjxkjvjwwtwgsfb")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The resource reference arm id type.
     * Expected value is 'Open'.
     */
    @JvmName("tewjqwwswgdoslnc")
    public suspend fun idType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.idType = mapped
    }

    internal fun build(): OpenDeploymentResourceReferenceArgs = OpenDeploymentResourceReferenceArgs(
        id = id,
        idType = idType ?: throw PulumiNullFieldException("idType"),
    )
}
