@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The AzureArcK8sCluster NFVI detail.
 * @property customLocationReference The reference to the custom location.
 * @property name Name of the nfvi.
 * @property nfviType The NFVI type.
 * Expected value is 'AzureArcKubernetes'.
 */
public data class AzureArcK8sClusterNFVIDetailsResponse(
    public val customLocationReference: ReferencedResourceResponse? = null,
    public val name: String? = null,
    public val nfviType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.AzureArcK8sClusterNFVIDetailsResponse):
            AzureArcK8sClusterNFVIDetailsResponse = AzureArcK8sClusterNFVIDetailsResponse(
            customLocationReference = javaType.customLocationReference().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ReferencedResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            nfviType = javaType.nfviType(),
        )
    }
}
