@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.Suppress

/**
 * Azure Operator Distributed Services image artifact profile properties.
 * @property artifactStore The reference to artifact store.
 * @property imageArtifactProfile Image artifact profile.
 */
public data class AzureOperatorNexusImageArtifactProfileResponse(
    public val artifactStore: ReferencedResourceResponse? = null,
    public val imageArtifactProfile: ImageArtifactProfileResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.AzureOperatorNexusImageArtifactProfileResponse):
            AzureOperatorNexusImageArtifactProfileResponse =
            AzureOperatorNexusImageArtifactProfileResponse(
                artifactStore = javaType.artifactStore().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ReferencedResourceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                imageArtifactProfile = javaType.imageArtifactProfile().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ImageArtifactProfileResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
