@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Azure Operator Distributed Services image deploy mapping rule profile.
 * @property applicationEnablement The application enablement.
 * @property imageMappingRuleProfile The vhd mapping rule profile.
 */
public data class AzureOperatorNexusImageDeployMappingRuleProfileResponse(
    public val applicationEnablement: String? = null,
    public val imageMappingRuleProfile: ImageMappingRuleProfileResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.AzureOperatorNexusImageDeployMappingRuleProfileResponse):
            AzureOperatorNexusImageDeployMappingRuleProfileResponse =
            AzureOperatorNexusImageDeployMappingRuleProfileResponse(
                applicationEnablement = javaType.applicationEnablement().map({ args0 -> args0 }).orElse(null),
                imageMappingRuleProfile = javaType.imageMappingRuleProfile().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ImageMappingRuleProfileResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
