@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The Sku credential definition.
 * @property acrServerUrl The Acr server url
 * @property acrToken The credential value.
 * @property expiry The UTC time when credential will expire.
 * @property repositories The repositories that could be accessed using the current credential.
 * @property username The username of the sku credential.
 */
public data class ListVendorSkusCredentialResult(
    public val acrServerUrl: String? = null,
    public val acrToken: String? = null,
    public val expiry: String? = null,
    public val repositories: List<String>? = null,
    public val username: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.ListVendorSkusCredentialResult):
            ListVendorSkusCredentialResult = ListVendorSkusCredentialResult(
            acrServerUrl = javaType.acrServerUrl().map({ args0 -> args0 }).orElse(null),
            acrToken = javaType.acrToken().map({ args0 -> args0 }).orElse(null),
            expiry = javaType.expiry().map({ args0 -> args0 }).orElse(null),
            repositories = javaType.repositories().map({ args0 -> args0 }),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
        )
    }
}
