@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hybridnetwork.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Site properties.
 * @property nfvis List of NFVIs
 * @property provisioningState The provisioning state of the site resource. **TODO**: Confirm if this is needed.
 * @property siteNetworkServiceReferences The list of site network services on the site.
 */
public data class SitePropertiesFormatResponse(
    public val nfvis: List<Any>? = null,
    public val provisioningState: String,
    public val siteNetworkServiceReferences: List<ReferencedResourceResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hybridnetwork.outputs.SitePropertiesFormatResponse):
            SitePropertiesFormatResponse = SitePropertiesFormatResponse(
            nfvis = javaType.nfvis().map({ args0 -> args0 }),
            provisioningState = javaType.provisioningState(),
            siteNetworkServiceReferences = javaType.siteNetworkServiceReferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hybridnetwork.kotlin.outputs.ReferencedResourceResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
