@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.importexport.kotlin.inputs

import com.pulumi.azurenative.importexport.inputs.JobDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Specifies the job properties
 * @property backupDriveManifest Default value is false. Indicates whether the manifest files on the drives should be copied to block blobs.
 * @property cancelRequested Indicates whether a request has been submitted to cancel the job.
 * @property deliveryPackage Contains information about the package being shipped by the customer to the Microsoft data center.
 * @property diagnosticsPath The virtual blob directory to which the copy logs and backups of drive manifest files (if enabled) will be stored.
 * @property driveList List of up to ten drives that comprise the job. The drive list is a required element for an import job; it is not specified for export jobs.
 * @property encryptionKey Contains information about the encryption key.
 * @property export A property containing information about the blobs to be exported for an export job. This property is included for export jobs only.
 * @property incompleteBlobListUri A blob path that points to a block blob containing a list of blob names that were not exported due to insufficient drive space. If all blobs were exported successfully, then this element is not included in the response.
 * @property jobType The type of job
 * @property logLevel Default value is Error. Indicates whether error logging or verbose logging will be enabled.
 * @property percentComplete Overall percentage completed for the job.
 * @property provisioningState Specifies the provisioning state of the job.
 * @property returnAddress Specifies the return address information for the job.
 * @property returnPackage Contains information about the package being shipped from the Microsoft data center to the customer to return the drives. The format is the same as the deliveryPackage property above. This property is not included if the drives have not yet been returned.
 * @property returnShipping Specifies the return carrier and customer's account with the carrier.
 * @property shippingInformation Contains information about the Microsoft datacenter to which the drives should be shipped.
 * @property state Current state of the job.
 * @property storageAccountId The resource identifier of the storage account where data will be imported to or exported from.
 */
public data class JobDetailsArgs(
    public val backupDriveManifest: Output<Boolean>? = null,
    public val cancelRequested: Output<Boolean>? = null,
    public val deliveryPackage: Output<DeliveryPackageInformationArgs>? = null,
    public val diagnosticsPath: Output<String>? = null,
    public val driveList: Output<List<DriveStatusArgs>>? = null,
    public val encryptionKey: Output<EncryptionKeyDetailsArgs>? = null,
    public val export: Output<ExportArgs>? = null,
    public val incompleteBlobListUri: Output<String>? = null,
    public val jobType: Output<String>? = null,
    public val logLevel: Output<String>? = null,
    public val percentComplete: Output<Double>? = null,
    public val provisioningState: Output<String>? = null,
    public val returnAddress: Output<ReturnAddressArgs>? = null,
    public val returnPackage: Output<PackageInformationArgs>? = null,
    public val returnShipping: Output<ReturnShippingArgs>? = null,
    public val shippingInformation: Output<ShippingInformationArgs>? = null,
    public val state: Output<String>? = null,
    public val storageAccountId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.importexport.inputs.JobDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.importexport.inputs.JobDetailsArgs =
        com.pulumi.azurenative.importexport.inputs.JobDetailsArgs.builder()
            .backupDriveManifest(backupDriveManifest?.applyValue({ args0 -> args0 }))
            .cancelRequested(cancelRequested?.applyValue({ args0 -> args0 }))
            .deliveryPackage(deliveryPackage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .diagnosticsPath(diagnosticsPath?.applyValue({ args0 -> args0 }))
            .driveList(
                driveList?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .encryptionKey(encryptionKey?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .export(export?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .incompleteBlobListUri(incompleteBlobListUri?.applyValue({ args0 -> args0 }))
            .jobType(jobType?.applyValue({ args0 -> args0 }))
            .logLevel(logLevel?.applyValue({ args0 -> args0 }))
            .percentComplete(percentComplete?.applyValue({ args0 -> args0 }))
            .provisioningState(provisioningState?.applyValue({ args0 -> args0 }))
            .returnAddress(returnAddress?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .returnPackage(returnPackage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .returnShipping(returnShipping?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .shippingInformation(
                shippingInformation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .state(state?.applyValue({ args0 -> args0 }))
            .storageAccountId(storageAccountId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobDetailsArgs].
 */
@PulumiTagMarker
public class JobDetailsArgsBuilder internal constructor() {
    private var backupDriveManifest: Output<Boolean>? = null

    private var cancelRequested: Output<Boolean>? = null

    private var deliveryPackage: Output<DeliveryPackageInformationArgs>? = null

    private var diagnosticsPath: Output<String>? = null

    private var driveList: Output<List<DriveStatusArgs>>? = null

    private var encryptionKey: Output<EncryptionKeyDetailsArgs>? = null

    private var export: Output<ExportArgs>? = null

    private var incompleteBlobListUri: Output<String>? = null

    private var jobType: Output<String>? = null

    private var logLevel: Output<String>? = null

    private var percentComplete: Output<Double>? = null

    private var provisioningState: Output<String>? = null

    private var returnAddress: Output<ReturnAddressArgs>? = null

    private var returnPackage: Output<PackageInformationArgs>? = null

    private var returnShipping: Output<ReturnShippingArgs>? = null

    private var shippingInformation: Output<ShippingInformationArgs>? = null

    private var state: Output<String>? = null

    private var storageAccountId: Output<String>? = null

    /**
     * @param value Default value is false. Indicates whether the manifest files on the drives should be copied to block blobs.
     */
    @JvmName("suwignshkaagtwht")
    public suspend fun backupDriveManifest(`value`: Output<Boolean>) {
        this.backupDriveManifest = value
    }

    /**
     * @param value Indicates whether a request has been submitted to cancel the job.
     */
    @JvmName("neirbcyhjlybvfic")
    public suspend fun cancelRequested(`value`: Output<Boolean>) {
        this.cancelRequested = value
    }

    /**
     * @param value Contains information about the package being shipped by the customer to the Microsoft data center.
     */
    @JvmName("csenibvhexsvimnj")
    public suspend fun deliveryPackage(`value`: Output<DeliveryPackageInformationArgs>) {
        this.deliveryPackage = value
    }

    /**
     * @param value The virtual blob directory to which the copy logs and backups of drive manifest files (if enabled) will be stored.
     */
    @JvmName("jretbjhvnnhlqahn")
    public suspend fun diagnosticsPath(`value`: Output<String>) {
        this.diagnosticsPath = value
    }

    /**
     * @param value List of up to ten drives that comprise the job. The drive list is a required element for an import job; it is not specified for export jobs.
     */
    @JvmName("fohacwtcwriovide")
    public suspend fun driveList(`value`: Output<List<DriveStatusArgs>>) {
        this.driveList = value
    }

    @JvmName("enwpbakweqhhntce")
    public suspend fun driveList(vararg values: Output<DriveStatusArgs>) {
        this.driveList = Output.all(values.asList())
    }

    /**
     * @param values List of up to ten drives that comprise the job. The drive list is a required element for an import job; it is not specified for export jobs.
     */
    @JvmName("qqhusnnsxxtefbmy")
    public suspend fun driveList(values: List<Output<DriveStatusArgs>>) {
        this.driveList = Output.all(values)
    }

    /**
     * @param value Contains information about the encryption key.
     */
    @JvmName("gwtumeapkmqadumb")
    public suspend fun encryptionKey(`value`: Output<EncryptionKeyDetailsArgs>) {
        this.encryptionKey = value
    }

    /**
     * @param value A property containing information about the blobs to be exported for an export job. This property is included for export jobs only.
     */
    @JvmName("immussllbeytadtb")
    public suspend fun export(`value`: Output<ExportArgs>) {
        this.export = value
    }

    /**
     * @param value A blob path that points to a block blob containing a list of blob names that were not exported due to insufficient drive space. If all blobs were exported successfully, then this element is not included in the response.
     */
    @JvmName("igppfsigmrwhcvtp")
    public suspend fun incompleteBlobListUri(`value`: Output<String>) {
        this.incompleteBlobListUri = value
    }

    /**
     * @param value The type of job
     */
    @JvmName("paosfjjjgbqyobsa")
    public suspend fun jobType(`value`: Output<String>) {
        this.jobType = value
    }

    /**
     * @param value Default value is Error. Indicates whether error logging or verbose logging will be enabled.
     */
    @JvmName("blofdlipbdyraupa")
    public suspend fun logLevel(`value`: Output<String>) {
        this.logLevel = value
    }

    /**
     * @param value Overall percentage completed for the job.
     */
    @JvmName("pekhrvwbqmhytnop")
    public suspend fun percentComplete(`value`: Output<Double>) {
        this.percentComplete = value
    }

    /**
     * @param value Specifies the provisioning state of the job.
     */
    @JvmName("auxgvtcqeawgmdsn")
    public suspend fun provisioningState(`value`: Output<String>) {
        this.provisioningState = value
    }

    /**
     * @param value Specifies the return address information for the job.
     */
    @JvmName("ptykftswgafahaxk")
    public suspend fun returnAddress(`value`: Output<ReturnAddressArgs>) {
        this.returnAddress = value
    }

    /**
     * @param value Contains information about the package being shipped from the Microsoft data center to the customer to return the drives. The format is the same as the deliveryPackage property above. This property is not included if the drives have not yet been returned.
     */
    @JvmName("jouvmohvwiexoeoe")
    public suspend fun returnPackage(`value`: Output<PackageInformationArgs>) {
        this.returnPackage = value
    }

    /**
     * @param value Specifies the return carrier and customer's account with the carrier.
     */
    @JvmName("jmmjdxvlkiqceejv")
    public suspend fun returnShipping(`value`: Output<ReturnShippingArgs>) {
        this.returnShipping = value
    }

    /**
     * @param value Contains information about the Microsoft datacenter to which the drives should be shipped.
     */
    @JvmName("dcfgdpqhlctgwwov")
    public suspend fun shippingInformation(`value`: Output<ShippingInformationArgs>) {
        this.shippingInformation = value
    }

    /**
     * @param value Current state of the job.
     */
    @JvmName("rewnvigkfvttopgl")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value The resource identifier of the storage account where data will be imported to or exported from.
     */
    @JvmName("ssyrkchnaslpcveh")
    public suspend fun storageAccountId(`value`: Output<String>) {
        this.storageAccountId = value
    }

    /**
     * @param value Default value is false. Indicates whether the manifest files on the drives should be copied to block blobs.
     */
    @JvmName("bawwgpyuuqepguob")
    public suspend fun backupDriveManifest(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupDriveManifest = mapped
    }

    /**
     * @param value Indicates whether a request has been submitted to cancel the job.
     */
    @JvmName("cquydhibrmokuqfk")
    public suspend fun cancelRequested(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cancelRequested = mapped
    }

    /**
     * @param value Contains information about the package being shipped by the customer to the Microsoft data center.
     */
    @JvmName("bmyvbnavdkykigig")
    public suspend fun deliveryPackage(`value`: DeliveryPackageInformationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryPackage = mapped
    }

    /**
     * @param argument Contains information about the package being shipped by the customer to the Microsoft data center.
     */
    @JvmName("nvhgkmhrtdtvidik")
    public suspend
    fun deliveryPackage(argument: suspend DeliveryPackageInformationArgsBuilder.() -> Unit) {
        val toBeMapped = DeliveryPackageInformationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deliveryPackage = mapped
    }

    /**
     * @param value The virtual blob directory to which the copy logs and backups of drive manifest files (if enabled) will be stored.
     */
    @JvmName("oiefjpakgmawycwh")
    public suspend fun diagnosticsPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diagnosticsPath = mapped
    }

    /**
     * @param value List of up to ten drives that comprise the job. The drive list is a required element for an import job; it is not specified for export jobs.
     */
    @JvmName("lawpmmskbxfkerba")
    public suspend fun driveList(`value`: List<DriveStatusArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.driveList = mapped
    }

    /**
     * @param argument List of up to ten drives that comprise the job. The drive list is a required element for an import job; it is not specified for export jobs.
     */
    @JvmName("dqyuvbumabevfwhs")
    public suspend fun driveList(argument: List<suspend DriveStatusArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { DriveStatusArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.driveList = mapped
    }

    /**
     * @param argument List of up to ten drives that comprise the job. The drive list is a required element for an import job; it is not specified for export jobs.
     */
    @JvmName("xcqdonltxdprvmvx")
    public suspend fun driveList(vararg argument: suspend DriveStatusArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { DriveStatusArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.driveList = mapped
    }

    /**
     * @param argument List of up to ten drives that comprise the job. The drive list is a required element for an import job; it is not specified for export jobs.
     */
    @JvmName("hfvrxerukonycljh")
    public suspend fun driveList(argument: suspend DriveStatusArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DriveStatusArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.driveList = mapped
    }

    /**
     * @param values List of up to ten drives that comprise the job. The drive list is a required element for an import job; it is not specified for export jobs.
     */
    @JvmName("frqvetstkoshpobg")
    public suspend fun driveList(vararg values: DriveStatusArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.driveList = mapped
    }

    /**
     * @param value Contains information about the encryption key.
     */
    @JvmName("advxcacobrabadaa")
    public suspend fun encryptionKey(`value`: EncryptionKeyDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionKey = mapped
    }

    /**
     * @param argument Contains information about the encryption key.
     */
    @JvmName("lxvgyrvnjqweqkkf")
    public suspend fun encryptionKey(argument: suspend EncryptionKeyDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionKeyDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryptionKey = mapped
    }

    /**
     * @param value A property containing information about the blobs to be exported for an export job. This property is included for export jobs only.
     */
    @JvmName("afoytbepftpqmgbx")
    public suspend fun export(`value`: ExportArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.export = mapped
    }

    /**
     * @param argument A property containing information about the blobs to be exported for an export job. This property is included for export jobs only.
     */
    @JvmName("kjwbcparwctdrfom")
    public suspend fun export(argument: suspend ExportArgsBuilder.() -> Unit) {
        val toBeMapped = ExportArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.export = mapped
    }

    /**
     * @param value A blob path that points to a block blob containing a list of blob names that were not exported due to insufficient drive space. If all blobs were exported successfully, then this element is not included in the response.
     */
    @JvmName("nofpomtllweyxvcc")
    public suspend fun incompleteBlobListUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.incompleteBlobListUri = mapped
    }

    /**
     * @param value The type of job
     */
    @JvmName("ypbdvhctsleghprk")
    public suspend fun jobType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobType = mapped
    }

    /**
     * @param value Default value is Error. Indicates whether error logging or verbose logging will be enabled.
     */
    @JvmName("ssuptrisystaauth")
    public suspend fun logLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logLevel = mapped
    }

    /**
     * @param value Overall percentage completed for the job.
     */
    @JvmName("piobfkrqfnnwwrfm")
    public suspend fun percentComplete(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.percentComplete = mapped
    }

    /**
     * @param value Specifies the provisioning state of the job.
     */
    @JvmName("lnixrjueapecwdbc")
    public suspend fun provisioningState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Specifies the return address information for the job.
     */
    @JvmName("ebldtltsegkdtbvc")
    public suspend fun returnAddress(`value`: ReturnAddressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.returnAddress = mapped
    }

    /**
     * @param argument Specifies the return address information for the job.
     */
    @JvmName("isdonnyaseisahxj")
    public suspend fun returnAddress(argument: suspend ReturnAddressArgsBuilder.() -> Unit) {
        val toBeMapped = ReturnAddressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.returnAddress = mapped
    }

    /**
     * @param value Contains information about the package being shipped from the Microsoft data center to the customer to return the drives. The format is the same as the deliveryPackage property above. This property is not included if the drives have not yet been returned.
     */
    @JvmName("jmjxuofndcnmiugp")
    public suspend fun returnPackage(`value`: PackageInformationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.returnPackage = mapped
    }

    /**
     * @param argument Contains information about the package being shipped from the Microsoft data center to the customer to return the drives. The format is the same as the deliveryPackage property above. This property is not included if the drives have not yet been returned.
     */
    @JvmName("scjvonynxtyfgpyr")
    public suspend fun returnPackage(argument: suspend PackageInformationArgsBuilder.() -> Unit) {
        val toBeMapped = PackageInformationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.returnPackage = mapped
    }

    /**
     * @param value Specifies the return carrier and customer's account with the carrier.
     */
    @JvmName("bgxfquoxmqpdmicv")
    public suspend fun returnShipping(`value`: ReturnShippingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.returnShipping = mapped
    }

    /**
     * @param argument Specifies the return carrier and customer's account with the carrier.
     */
    @JvmName("ormcmpassoysktfy")
    public suspend fun returnShipping(argument: suspend ReturnShippingArgsBuilder.() -> Unit) {
        val toBeMapped = ReturnShippingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.returnShipping = mapped
    }

    /**
     * @param value Contains information about the Microsoft datacenter to which the drives should be shipped.
     */
    @JvmName("sciugodexcgyvfgl")
    public suspend fun shippingInformation(`value`: ShippingInformationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shippingInformation = mapped
    }

    /**
     * @param argument Contains information about the Microsoft datacenter to which the drives should be shipped.
     */
    @JvmName("uqhioxbuvdnjnvyg")
    public suspend
    fun shippingInformation(argument: suspend ShippingInformationArgsBuilder.() -> Unit) {
        val toBeMapped = ShippingInformationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.shippingInformation = mapped
    }

    /**
     * @param value Current state of the job.
     */
    @JvmName("gmioykegtpcdhnmb")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The resource identifier of the storage account where data will be imported to or exported from.
     */
    @JvmName("ltdkmdqlvhgckwde")
    public suspend fun storageAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountId = mapped
    }

    internal fun build(): JobDetailsArgs = JobDetailsArgs(
        backupDriveManifest = backupDriveManifest,
        cancelRequested = cancelRequested,
        deliveryPackage = deliveryPackage,
        diagnosticsPath = diagnosticsPath,
        driveList = driveList,
        encryptionKey = encryptionKey,
        export = export,
        incompleteBlobListUri = incompleteBlobListUri,
        jobType = jobType,
        logLevel = logLevel,
        percentComplete = percentComplete,
        provisioningState = provisioningState,
        returnAddress = returnAddress,
        returnPackage = returnPackage,
        returnShipping = returnShipping,
        shippingInformation = shippingInformation,
        state = state,
        storageAccountId = storageAccountId,
    )
}
