@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.importexport.kotlin.inputs

import com.pulumi.azurenative.importexport.inputs.ListBitLockerKeyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property jobName The name of the import/export job.
 * @property resourceGroupName The resource group name uniquely identifies the resource group within the user subscription.
 */
public data class ListBitLockerKeyPlainArgs(
    public val jobName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.importexport.inputs.ListBitLockerKeyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.importexport.inputs.ListBitLockerKeyPlainArgs =
        com.pulumi.azurenative.importexport.inputs.ListBitLockerKeyPlainArgs.builder()
            .jobName(jobName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListBitLockerKeyPlainArgs].
 */
@PulumiTagMarker
public class ListBitLockerKeyPlainArgsBuilder internal constructor() {
    private var jobName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the import/export job.
     */
    @JvmName("viytbutvruktibyi")
    public suspend fun jobName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.jobName = mapped
    }

    /**
     * @param value The resource group name uniquely identifies the resource group within the user subscription.
     */
    @JvmName("sseekwbulnxsdwwi")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListBitLockerKeyPlainArgs = ListBitLockerKeyPlainArgs(
        jobName = jobName ?: throw PulumiNullFieldException("jobName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
