@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.importexport.kotlin.inputs

import com.pulumi.azurenative.importexport.inputs.ReturnShippingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the return carrier and customer's account with the carrier.
 * @property carrierAccountNumber The customer's account number with the carrier.
 * @property carrierName The carrier's name.
 */
public data class ReturnShippingArgs(
    public val carrierAccountNumber: Output<String>,
    public val carrierName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.importexport.inputs.ReturnShippingArgs> {
    override fun toJava(): com.pulumi.azurenative.importexport.inputs.ReturnShippingArgs =
        com.pulumi.azurenative.importexport.inputs.ReturnShippingArgs.builder()
            .carrierAccountNumber(carrierAccountNumber.applyValue({ args0 -> args0 }))
            .carrierName(carrierName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReturnShippingArgs].
 */
@PulumiTagMarker
public class ReturnShippingArgsBuilder internal constructor() {
    private var carrierAccountNumber: Output<String>? = null

    private var carrierName: Output<String>? = null

    /**
     * @param value The customer's account number with the carrier.
     */
    @JvmName("tgmsdcauyatxqyvi")
    public suspend fun carrierAccountNumber(`value`: Output<String>) {
        this.carrierAccountNumber = value
    }

    /**
     * @param value The carrier's name.
     */
    @JvmName("irquthdqehnyymas")
    public suspend fun carrierName(`value`: Output<String>) {
        this.carrierName = value
    }

    /**
     * @param value The customer's account number with the carrier.
     */
    @JvmName("qxbxsmxwqiyedudi")
    public suspend fun carrierAccountNumber(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.carrierAccountNumber = mapped
    }

    /**
     * @param value The carrier's name.
     */
    @JvmName("lxwtpjbmtqkiolse")
    public suspend fun carrierName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.carrierName = mapped
    }

    internal fun build(): ReturnShippingArgs = ReturnShippingArgs(
        carrierAccountNumber = carrierAccountNumber ?: throw
            PulumiNullFieldException("carrierAccountNumber"),
        carrierName = carrierName ?: throw PulumiNullFieldException("carrierName"),
    )
}
