@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.importexport.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Specifies the job properties
 * @property backupDriveManifest Default value is false. Indicates whether the manifest files on the drives should be copied to block blobs.
 * @property cancelRequested Indicates whether a request has been submitted to cancel the job.
 * @property deliveryPackage Contains information about the package being shipped by the customer to the Microsoft data center.
 * @property diagnosticsPath The virtual blob directory to which the copy logs and backups of drive manifest files (if enabled) will be stored.
 * @property driveList List of up to ten drives that comprise the job. The drive list is a required element for an import job; it is not specified for export jobs.
 * @property encryptionKey Contains information about the encryption key.
 * @property export A property containing information about the blobs to be exported for an export job. This property is included for export jobs only.
 * @property incompleteBlobListUri A blob path that points to a block blob containing a list of blob names that were not exported due to insufficient drive space. If all blobs were exported successfully, then this element is not included in the response.
 * @property jobType The type of job
 * @property logLevel Default value is Error. Indicates whether error logging or verbose logging will be enabled.
 * @property percentComplete Overall percentage completed for the job.
 * @property provisioningState Specifies the provisioning state of the job.
 * @property returnAddress Specifies the return address information for the job.
 * @property returnPackage Contains information about the package being shipped from the Microsoft data center to the customer to return the drives. The format is the same as the deliveryPackage property above. This property is not included if the drives have not yet been returned.
 * @property returnShipping Specifies the return carrier and customer's account with the carrier.
 * @property shippingInformation Contains information about the Microsoft datacenter to which the drives should be shipped.
 * @property state Current state of the job.
 * @property storageAccountId The resource identifier of the storage account where data will be imported to or exported from.
 */
public data class JobDetailsResponse(
    public val backupDriveManifest: Boolean? = null,
    public val cancelRequested: Boolean? = null,
    public val deliveryPackage: DeliveryPackageInformationResponse? = null,
    public val diagnosticsPath: String? = null,
    public val driveList: List<DriveStatusResponse>? = null,
    public val encryptionKey: EncryptionKeyDetailsResponse? = null,
    public val export: ExportResponse? = null,
    public val incompleteBlobListUri: String? = null,
    public val jobType: String? = null,
    public val logLevel: String? = null,
    public val percentComplete: Double? = null,
    public val provisioningState: String? = null,
    public val returnAddress: ReturnAddressResponse? = null,
    public val returnPackage: PackageInformationResponse? = null,
    public val returnShipping: ReturnShippingResponse? = null,
    public val shippingInformation: ShippingInformationResponse? = null,
    public val state: String? = null,
    public val storageAccountId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.importexport.outputs.JobDetailsResponse):
            JobDetailsResponse = JobDetailsResponse(
            backupDriveManifest = javaType.backupDriveManifest().map({ args0 -> args0 }).orElse(null),
            cancelRequested = javaType.cancelRequested().map({ args0 -> args0 }).orElse(null),
            deliveryPackage = javaType.deliveryPackage().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.importexport.kotlin.outputs.DeliveryPackageInformationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            diagnosticsPath = javaType.diagnosticsPath().map({ args0 -> args0 }).orElse(null),
            driveList = javaType.driveList().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.importexport.kotlin.outputs.DriveStatusResponse.Companion.toKotlin(args0)
                })
            }),
            encryptionKey = javaType.encryptionKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.importexport.kotlin.outputs.EncryptionKeyDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            export = javaType.export().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.importexport.kotlin.outputs.ExportResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            incompleteBlobListUri = javaType.incompleteBlobListUri().map({ args0 -> args0 }).orElse(null),
            jobType = javaType.jobType().map({ args0 -> args0 }).orElse(null),
            logLevel = javaType.logLevel().map({ args0 -> args0 }).orElse(null),
            percentComplete = javaType.percentComplete().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            returnAddress = javaType.returnAddress().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.importexport.kotlin.outputs.ReturnAddressResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            returnPackage = javaType.returnPackage().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.importexport.kotlin.outputs.PackageInformationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            returnShipping = javaType.returnShipping().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.importexport.kotlin.outputs.ReturnShippingResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            shippingInformation = javaType.shippingInformation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.importexport.kotlin.outputs.ShippingInformationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            storageAccountId = javaType.storageAccountId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
