@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.kotlin.outputs.PrivateLinkScopedResourceResponse
import com.pulumi.azurenative.insights.kotlin.outputs.PrivateLinkScopedResourceResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Component].
 */
@PulumiTagMarker
public class ComponentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ComponentArgs = ComponentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ComponentArgsBuilder.() -> Unit) {
        val builder = ComponentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Component {
        val builtJavaResource = com.pulumi.azurenative.insights.Component(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Component(builtJavaResource)
    }
}

/**
 * An Application Insights component definition.
 * Azure REST API version: 2020-02-02. Prior API version in Azure Native 1.x: 2015-05-01.
 * Other available API versions: 2020-02-02-preview.
 * ## Example Usage
 * ### ComponentCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var component = new AzureNative.Insights.Component("component", new()
 *     {
 *         ApplicationType = AzureNative.Insights.ApplicationType.Web,
 *         FlowType = AzureNative.Insights.FlowType.Bluefield,
 *         Kind = "web",
 *         Location = "South Central US",
 *         RequestSource = AzureNative.Insights.RequestSource.Rest,
 *         ResourceGroupName = "my-resource-group",
 *         ResourceName = "my-component",
 *         WorkspaceResourceId = "/subscriptions/subid/resourcegroups/my-resource-group/providers/microsoft.operationalinsights/workspaces/my-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewComponent(ctx, "component", &insights.ComponentArgs{
 * 			ApplicationType:     pulumi.String(insights.ApplicationTypeWeb),
 * 			FlowType:            pulumi.String(insights.FlowTypeBluefield),
 * 			Kind:                pulumi.String("web"),
 * 			Location:            pulumi.String("South Central US"),
 * 			RequestSource:       pulumi.String(insights.RequestSourceRest),
 * 			ResourceGroupName:   pulumi.String("my-resource-group"),
 * 			ResourceName:        pulumi.String("my-component"),
 * 			WorkspaceResourceId: pulumi.String("/subscriptions/subid/resourcegroups/my-resource-group/providers/microsoft.operationalinsights/workspaces/my-workspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.Component;
 * import com.pulumi.azurenative.insights.ComponentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var component = new Component("component", ComponentArgs.builder()
 *             .applicationType("web")
 *             .flowType("Bluefield")
 *             .kind("web")
 *             .location("South Central US")
 *             .requestSource("rest")
 *             .resourceGroupName("my-resource-group")
 *             .resourceName("my-component")
 *             .workspaceResourceId("/subscriptions/subid/resourcegroups/my-resource-group/providers/microsoft.operationalinsights/workspaces/my-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ### ComponentUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var component = new AzureNative.Insights.Component("component", new()
 *     {
 *         Kind = "web",
 *         Location = "South Central US",
 *         ResourceGroupName = "my-resource-group",
 *         ResourceName = "my-component",
 *         Tags =
 *         {
 *             { "ApplicationGatewayType", "Internal-Only" },
 *             { "BillingEntity", "Self" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewComponent(ctx, "component", &insights.ComponentArgs{
 * 			Kind:              pulumi.String("web"),
 * 			Location:          pulumi.String("South Central US"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			ResourceName:      pulumi.String("my-component"),
 * 			Tags: pulumi.StringMap{
 * 				"ApplicationGatewayType": pulumi.String("Internal-Only"),
 * 				"BillingEntity":          pulumi.String("Self"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.Component;
 * import com.pulumi.azurenative.insights.ComponentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var component = new Component("component", ComponentArgs.builder()
 *             .kind("web")
 *             .location("South Central US")
 *             .resourceGroupName("my-resource-group")
 *             .resourceName("my-component")
 *             .tags(Map.ofEntries(
 *                 Map.entry("ApplicationGatewayType", "Internal-Only"),
 *                 Map.entry("BillingEntity", "Self")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:Component my-component /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}
 * ```
 */
public class Component internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.Component,
) : KotlinCustomResource(javaResource, ComponentMapper) {
    /**
     * Application Insights Unique ID for your Application.
     */
    public val appId: Output<String>
        get() = javaResource.appId().applyValue({ args0 -> args0 })

    /**
     * The unique ID of your application. This field mirrors the 'Name' field and cannot be changed.
     */
    public val applicationId: Output<String>
        get() = javaResource.applicationId().applyValue({ args0 -> args0 })

    /**
     * Type of application being monitored.
     */
    public val applicationType: Output<String>
        get() = javaResource.applicationType().applyValue({ args0 -> args0 })

    /**
     * Application Insights component connection string.
     */
    public val connectionString: Output<String>
        get() = javaResource.connectionString().applyValue({ args0 -> args0 })

    /**
     * Creation Date for the Application Insights component, in ISO 8601 format.
     */
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * Disable IP masking.
     */
    public val disableIpMasking: Output<Boolean>?
        get() = javaResource.disableIpMasking().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Disable Non-AAD based Auth.
     */
    public val disableLocalAuth: Output<Boolean>?
        get() = javaResource.disableLocalAuth().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource etag
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Used by the Application Insights system to determine what kind of flow this component was created by. This is to be set to 'Bluefield' when creating/updating a component via the REST API.
     */
    public val flowType: Output<String>?
        get() = javaResource.flowType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Force users to create their own storage account for profiler and debugger.
     */
    public val forceCustomerStorageForProfiler: Output<Boolean>?
        get() = javaResource.forceCustomerStorageForProfiler().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The unique application ID created when a new application is added to HockeyApp, used for communications with HockeyApp.
     */
    public val hockeyAppId: Output<String>?
        get() = javaResource.hockeyAppId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Token used to authenticate communications with between Application Insights and HockeyApp.
     */
    public val hockeyAppToken: Output<String>
        get() = javaResource.hockeyAppToken().applyValue({ args0 -> args0 })

    /**
     * Purge data immediately after 30 days.
     */
    public val immediatePurgeDataOn30Days: Output<Boolean>?
        get() = javaResource.immediatePurgeDataOn30Days().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates the flow of the ingestion.
     */
    public val ingestionMode: Output<String>?
        get() = javaResource.ingestionMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Application Insights Instrumentation key. A read-only value that applications can use to identify the destination for all telemetry sent to Azure Application Insights. This value will be supplied upon construction of each new Application Insights component.
     */
    public val instrumentationKey: Output<String>
        get() = javaResource.instrumentationKey().applyValue({ args0 -> args0 })

    /**
     * The kind of application that this component refers to, used to customize UI. This value is a freeform string, values should typically be one of the following: web, ios, other, store, java, phone.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The date which the component got migrated to LA, in ISO 8601 format.
     */
    public val laMigrationDate: Output<String>
        get() = javaResource.laMigrationDate().applyValue({ args0 -> args0 })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Azure resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of linked private link scope resources.
     */
    public val privateLinkScopedResources: Output<List<PrivateLinkScopedResourceResponse>>
        get() = javaResource.privateLinkScopedResources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * Current state of this component: whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Succeeded, Deploying, Canceled, and Failed.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The network access type for accessing Application Insights ingestion.
     */
    public val publicNetworkAccessForIngestion: Output<String>?
        get() = javaResource.publicNetworkAccessForIngestion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The network access type for accessing Application Insights query.
     */
    public val publicNetworkAccessForQuery: Output<String>?
        get() = javaResource.publicNetworkAccessForQuery().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Describes what tool created this Application Insights component. Customers using this API should set this to the default 'rest'.
     */
    public val requestSource: Output<String>?
        get() = javaResource.requestSource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Retention period in days.
     */
    public val retentionInDays: Output<Int>?
        get() = javaResource.retentionInDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Percentage of the data produced by the application being monitored that is being sampled for Application Insights telemetry.
     */
    public val samplingPercentage: Output<Double>?
        get() = javaResource.samplingPercentage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Azure Tenant Id.
     */
    public val tenantId: Output<String>
        get() = javaResource.tenantId().applyValue({ args0 -> args0 })

    /**
     * Azure resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Resource Id of the log analytics workspace which the data will be ingested to. This property is required to create an application with this API version. Applications from older versions will not have this property.
     */
    public val workspaceResourceId: Output<String>?
        get() = javaResource.workspaceResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ComponentMapper : ResourceMapper<Component> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.Component::class == javaResource::class

    override fun map(javaResource: Resource): Component = Component(
        javaResource as
            com.pulumi.azurenative.insights.Component,
    )
}

/**
 * @see [Component].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Component].
 */
public suspend fun component(name: String, block: suspend ComponentResourceBuilder.() -> Unit):
    Component {
    val builder = ComponentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Component].
 * @param name The _unique_ name of the resulting resource.
 */
public fun component(name: String): Component {
    val builder = ComponentResourceBuilder()
    builder.name(name)
    return builder.build()
}
