@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.DataCollectionEndpointArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.KnownDataCollectionEndpointResourceKind
import com.pulumi.azurenative.insights.kotlin.inputs.DataCollectionEndpointNetworkAclsArgs
import com.pulumi.azurenative.insights.kotlin.inputs.DataCollectionEndpointNetworkAclsArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.DataCollectionEndpointResourceIdentityArgs
import com.pulumi.azurenative.insights.kotlin.inputs.DataCollectionEndpointResourceIdentityArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Definition of ARM tracked top level resource.
 * Azure REST API version: 2022-06-01. Prior API version in Azure Native 1.x: 2021-09-01-preview.
 * Other available API versions: 2023-03-11.
 * ## Example Usage
 * ### Create or update data collection endpoint
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataCollectionEndpoint = new AzureNative.Insights.DataCollectionEndpoint("dataCollectionEndpoint", new()
 *     {
 *         DataCollectionEndpointName = "myCollectionEndpoint",
 *         Location = "eastus",
 *         NetworkAcls = new AzureNative.Insights.Inputs.DataCollectionEndpointNetworkAclsArgs
 *         {
 *             PublicNetworkAccess = AzureNative.Insights.KnownPublicNetworkAccessOptions.Enabled,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewDataCollectionEndpoint(ctx, "dataCollectionEndpoint", &insights.DataCollectionEndpointArgs{
 * 			DataCollectionEndpointName: pulumi.String("myCollectionEndpoint"),
 * 			Location:                   pulumi.String("eastus"),
 * 			NetworkAcls: &insights.DataCollectionEndpointNetworkAclsArgs{
 * 				PublicNetworkAccess: pulumi.String(insights.KnownPublicNetworkAccessOptionsEnabled),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.DataCollectionEndpoint;
 * import com.pulumi.azurenative.insights.DataCollectionEndpointArgs;
 * import com.pulumi.azurenative.insights.inputs.DataCollectionEndpointNetworkAclsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataCollectionEndpoint = new DataCollectionEndpoint("dataCollectionEndpoint", DataCollectionEndpointArgs.builder()
 *             .dataCollectionEndpointName("myCollectionEndpoint")
 *             .location("eastus")
 *             .networkAcls(DataCollectionEndpointNetworkAclsArgs.builder()
 *                 .publicNetworkAccess("Enabled")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:DataCollectionEndpoint myCollectionEndpoint /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionEndpoints/{dataCollectionEndpointName}
 * ```
 * @property dataCollectionEndpointName The name of the data collection endpoint. The name is case insensitive.
 * @property description Description of the data collection endpoint.
 * @property identity Managed service identity of the resource.
 * @property immutableId The immutable ID of this data collection endpoint resource. This property is READ-ONLY.
 * @property kind The kind of the resource.
 * @property location The geo-location where the resource lives.
 * @property networkAcls Network access control rules for the endpoints.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class DataCollectionEndpointArgs(
    public val dataCollectionEndpointName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val identity: Output<DataCollectionEndpointResourceIdentityArgs>? = null,
    public val immutableId: Output<String>? = null,
    public val kind: Output<Either<String, KnownDataCollectionEndpointResourceKind>>? = null,
    public val location: Output<String>? = null,
    public val networkAcls: Output<DataCollectionEndpointNetworkAclsArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.DataCollectionEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.DataCollectionEndpointArgs =
        com.pulumi.azurenative.insights.DataCollectionEndpointArgs.builder()
            .dataCollectionEndpointName(dataCollectionEndpointName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .immutableId(immutableId?.applyValue({ args0 -> args0 }))
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .networkAcls(networkAcls?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DataCollectionEndpointArgs].
 */
@PulumiTagMarker
public class DataCollectionEndpointArgsBuilder internal constructor() {
    private var dataCollectionEndpointName: Output<String>? = null

    private var description: Output<String>? = null

    private var identity: Output<DataCollectionEndpointResourceIdentityArgs>? = null

    private var immutableId: Output<String>? = null

    private var kind: Output<Either<String, KnownDataCollectionEndpointResourceKind>>? = null

    private var location: Output<String>? = null

    private var networkAcls: Output<DataCollectionEndpointNetworkAclsArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the data collection endpoint. The name is case insensitive.
     */
    @JvmName("bpfsgoayybusqbtl")
    public suspend fun dataCollectionEndpointName(`value`: Output<String>) {
        this.dataCollectionEndpointName = value
    }

    /**
     * @param value Description of the data collection endpoint.
     */
    @JvmName("ixwnjfrfcgrnubsy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Managed service identity of the resource.
     */
    @JvmName("leshyjyxuesrdojw")
    public suspend fun identity(`value`: Output<DataCollectionEndpointResourceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The immutable ID of this data collection endpoint resource. This property is READ-ONLY.
     */
    @JvmName("umrmawonmvqrpesm")
    public suspend fun immutableId(`value`: Output<String>) {
        this.immutableId = value
    }

    /**
     * @param value The kind of the resource.
     */
    @JvmName("gsmyyslyncyomlvh")
    public suspend
    fun kind(`value`: Output<Either<String, KnownDataCollectionEndpointResourceKind>>) {
        this.kind = value
    }

    /**
     * @param value The geo-location where the resource lives.
     */
    @JvmName("wrmorotjithssbqh")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Network access control rules for the endpoints.
     */
    @JvmName("vwahukqlokgiygcj")
    public suspend fun networkAcls(`value`: Output<DataCollectionEndpointNetworkAclsArgs>) {
        this.networkAcls = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("odtvxkmnrjayhuln")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qbthjoxwnqvcdabj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the data collection endpoint. The name is case insensitive.
     */
    @JvmName("dbqvpkcsbqgwihdq")
    public suspend fun dataCollectionEndpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataCollectionEndpointName = mapped
    }

    /**
     * @param value Description of the data collection endpoint.
     */
    @JvmName("hwnneyhfudufxmyh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Managed service identity of the resource.
     */
    @JvmName("gkxxjhompohdnpxg")
    public suspend fun identity(`value`: DataCollectionEndpointResourceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed service identity of the resource.
     */
    @JvmName("dysxjrmvikysajlq")
    public suspend
    fun identity(argument: suspend DataCollectionEndpointResourceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = DataCollectionEndpointResourceIdentityArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The immutable ID of this data collection endpoint resource. This property is READ-ONLY.
     */
    @JvmName("eooyvemmadqpvndp")
    public suspend fun immutableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.immutableId = mapped
    }

    /**
     * @param value The kind of the resource.
     */
    @JvmName("vjmlmiecwedivoru")
    public suspend fun kind(`value`: Either<String, KnownDataCollectionEndpointResourceKind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The kind of the resource.
     */
    @JvmName("jlhcswkwihvtqpcw")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KnownDataCollectionEndpointResourceKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The kind of the resource.
     */
    @JvmName("vdqymxpmqiconnvh")
    public fun kind(`value`: KnownDataCollectionEndpointResourceKind) {
        val toBeMapped = Either.ofRight<String, KnownDataCollectionEndpointResourceKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The geo-location where the resource lives.
     */
    @JvmName("qgbrbtwglidhxgew")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Network access control rules for the endpoints.
     */
    @JvmName("cxjxmmkmstdjqabt")
    public suspend fun networkAcls(`value`: DataCollectionEndpointNetworkAclsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkAcls = mapped
    }

    /**
     * @param argument Network access control rules for the endpoints.
     */
    @JvmName("olqagpofrpwmfokv")
    public suspend
    fun networkAcls(argument: suspend DataCollectionEndpointNetworkAclsArgsBuilder.() -> Unit) {
        val toBeMapped = DataCollectionEndpointNetworkAclsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.networkAcls = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qplhjtmyqxuauiny")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("abhivagusgmarckg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("iidugpxiqrbaluax")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DataCollectionEndpointArgs = DataCollectionEndpointArgs(
        dataCollectionEndpointName = dataCollectionEndpointName,
        description = description,
        identity = identity,
        immutableId = immutableId,
        kind = kind,
        location = location,
        networkAcls = networkAcls,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
