@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionRuleResourceResponseIdentity
import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionRuleResourceResponseSystemData
import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionRuleResponseDataSources
import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionRuleResponseDestinations
import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionRuleResponseMetadata
import com.pulumi.azurenative.insights.kotlin.outputs.DataFlowResponse
import com.pulumi.azurenative.insights.kotlin.outputs.StreamDeclarationResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionRuleResourceResponseIdentity.Companion.toKotlin as dataCollectionRuleResourceResponseIdentityToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionRuleResourceResponseSystemData.Companion.toKotlin as dataCollectionRuleResourceResponseSystemDataToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionRuleResponseDataSources.Companion.toKotlin as dataCollectionRuleResponseDataSourcesToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionRuleResponseDestinations.Companion.toKotlin as dataCollectionRuleResponseDestinationsToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.DataCollectionRuleResponseMetadata.Companion.toKotlin as dataCollectionRuleResponseMetadataToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.DataFlowResponse.Companion.toKotlin as dataFlowResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.StreamDeclarationResponse.Companion.toKotlin as streamDeclarationResponseToKotlin

/**
 * Builder for [DataCollectionRule].
 */
@PulumiTagMarker
public class DataCollectionRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataCollectionRuleArgs = DataCollectionRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataCollectionRuleArgsBuilder.() -> Unit) {
        val builder = DataCollectionRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DataCollectionRule {
        val builtJavaResource =
            com.pulumi.azurenative.insights.DataCollectionRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DataCollectionRule(builtJavaResource)
    }
}

/**
 * Definition of ARM tracked top level resource.
 * Azure REST API version: 2022-06-01. Prior API version in Azure Native 1.x: 2019-11-01-preview.
 * Other available API versions: 2023-03-11.
 * ## Example Usage
 * ### Create or update data collection rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataCollectionRule = new AzureNative.Insights.DataCollectionRule("dataCollectionRule", new()
 *     {
 *         DataCollectionRuleName = "myCollectionRule",
 *         DataFlows = new[]
 *         {
 *             new AzureNative.Insights.Inputs.DataFlowArgs
 *             {
 *                 Destinations = new[]
 *                 {
 *                     "centralWorkspace",
 *                 },
 *                 Streams = new[]
 *                 {
 *                     AzureNative.Insights.KnownDataFlowStreams.Microsoft_Perf,
 *                     AzureNative.Insights.KnownDataFlowStreams.Microsoft_Syslog,
 *                     AzureNative.Insights.KnownDataFlowStreams.Microsoft_WindowsEvent,
 *                 },
 *             },
 *         },
 *         DataSources = new AzureNative.Insights.Inputs.DataCollectionRuleDataSourcesArgs
 *         {
 *             PerformanceCounters = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.PerfCounterDataSourceArgs
 *                 {
 *                     CounterSpecifiers = new[]
 *                     {
 *                         "\\Processor(_Total)\\% Processor Time",
 *                         "\\Memory\\Committed Bytes",
 *                         "\\LogicalDisk(_Total)\\Free Megabytes",
 *                         "\\PhysicalDisk(_Total)\\Avg. Disk Queue Length",
 *                     },
 *                     Name = "cloudTeamCoreCounters",
 *                     SamplingFrequencyInSeconds = 15,
 *                     Streams = new[]
 *                     {
 *                         AzureNative.Insights.KnownPerfCounterDataSourceStreams.Microsoft_Perf,
 *                     },
 *                 },
 *                 new AzureNative.Insights.Inputs.PerfCounterDataSourceArgs
 *                 {
 *                     CounterSpecifiers = new[]
 *                     {
 *                         "\\Process(_Total)\\Thread Count",
 *                     },
 *                     Name = "appTeamExtraCounters",
 *                     SamplingFrequencyInSeconds = 30,
 *                     Streams = new[]
 *                     {
 *                         AzureNative.Insights.KnownPerfCounterDataSourceStreams.Microsoft_Perf,
 *                     },
 *                 },
 *             },
 *             Syslog = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.SyslogDataSourceArgs
 *                 {
 *                     FacilityNames = new[]
 *                     {
 *                         AzureNative.Insights.KnownSyslogDataSourceFacilityNames.Cron,
 *                     },
 *                     LogLevels = new[]
 *                     {
 *                         AzureNative.Insights.KnownSyslogDataSourceLogLevels.Debug,
 *                         AzureNative.Insights.KnownSyslogDataSourceLogLevels.Critical,
 *                         AzureNative.Insights.KnownSyslogDataSourceLogLevels.Emergency,
 *                     },
 *                     Name = "cronSyslog",
 *                     Streams = new[]
 *                     {
 *                         AzureNative.Insights.KnownSyslogDataSourceStreams.Microsoft_Syslog,
 *                     },
 *                 },
 *                 new AzureNative.Insights.Inputs.SyslogDataSourceArgs
 *                 {
 *                     FacilityNames = new[]
 *                     {
 *                         AzureNative.Insights.KnownSyslogDataSourceFacilityNames.Syslog,
 *                     },
 *                     LogLevels = new[]
 *                     {
 *                         AzureNative.Insights.KnownSyslogDataSourceLogLevels.Alert,
 *                         AzureNative.Insights.KnownSyslogDataSourceLogLevels.Critical,
 *                         AzureNative.Insights.KnownSyslogDataSourceLogLevels.Emergency,
 *                     },
 *                     Name = "syslogBase",
 *                     Streams = new[]
 *                     {
 *                         AzureNative.Insights.KnownSyslogDataSourceStreams.Microsoft_Syslog,
 *                     },
 *                 },
 *             },
 *             WindowsEventLogs = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.WindowsEventLogDataSourceArgs
 *                 {
 *                     Name = "cloudSecurityTeamEvents",
 *                     Streams = new[]
 *                     {
 *                         AzureNative.Insights.KnownWindowsEventLogDataSourceStreams.Microsoft_WindowsEvent,
 *                     },
 *                     XPathQueries = new[]
 *                     {
 *                         "Security!",
 *                     },
 *                 },
 *                 new AzureNative.Insights.Inputs.WindowsEventLogDataSourceArgs
 *                 {
 *                     Name = "appTeam1AppEvents",
 *                     Streams = new[]
 *                     {
 *                         AzureNative.Insights.KnownWindowsEventLogDataSourceStreams.Microsoft_WindowsEvent,
 *                     },
 *                     XPathQueries = new[]
 *                     {
 *                         "System![System[(Level = 1 or Level = 2 or Level = 3)]]",
 *                         "Application!*[System[(Level = 1 or Level = 2 or Level = 3)]]",
 *                     },
 *                 },
 *             },
 *         },
 *         Destinations = new AzureNative.Insights.Inputs.DataCollectionRuleDestinationsArgs
 *         {
 *             LogAnalytics = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.LogAnalyticsDestinationArgs
 *                 {
 *                     Name = "centralWorkspace",
 *                     WorkspaceResourceId = "/subscriptions/703362b3-f278-4e4b-9179-c76eaf41ffc2/resourceGroups/myResourceGroup/providers/Microsoft.OperationalInsights/workspaces/centralTeamWorkspace",
 *                 },
 *             },
 *         },
 *         Location = "eastus",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewDataCollectionRule(ctx, "dataCollectionRule", &insights.DataCollectionRuleArgs{
 * 			DataCollectionRuleName: pulumi.String("myCollectionRule"),
 * 			DataFlows: insights.DataFlowArray{
 * 				&insights.DataFlowArgs{
 * 					Destinations: pulumi.StringArray{
 * 						pulumi.String("centralWorkspace"),
 * 					},
 * 					Streams: pulumi.StringArray{
 * 						pulumi.String(insights.KnownDataFlowStreams_Microsoft_Perf),
 * 						pulumi.String(insights.KnownDataFlowStreams_Microsoft_Syslog),
 * 						pulumi.String(insights.KnownDataFlowStreams_Microsoft_WindowsEvent),
 * 					},
 * 				},
 * 			},
 * 			DataSources: &insights.DataCollectionRuleDataSourcesArgs{
 * 				PerformanceCounters: insights.PerfCounterDataSourceArray{
 * 					&insights.PerfCounterDataSourceArgs{
 * 						CounterSpecifiers: pulumi.StringArray{
 * 							pulumi.String("\\Processor(_Total)\\% Processor Time"),
 * 							pulumi.String("\\Memory\\Committed Bytes"),
 * 							pulumi.String("\\LogicalDisk(_Total)\\Free Megabytes"),
 * 							pulumi.String("\\PhysicalDisk(_Total)\\Avg. Disk Queue Length"),
 * 						},
 * 						Name:                       pulumi.String("cloudTeamCoreCounters"),
 * 						SamplingFrequencyInSeconds: pulumi.Int(15),
 * 						Streams: pulumi.StringArray{
 * 							pulumi.String(insights.KnownPerfCounterDataSourceStreams_Microsoft_Perf),
 * 						},
 * 					},
 * 					&insights.PerfCounterDataSourceArgs{
 * 						CounterSpecifiers: pulumi.StringArray{
 * 							pulumi.String("\\Process(_Total)\\Thread Count"),
 * 						},
 * 						Name:                       pulumi.String("appTeamExtraCounters"),
 * 						SamplingFrequencyInSeconds: pulumi.Int(30),
 * 						Streams: pulumi.StringArray{
 * 							pulumi.String(insights.KnownPerfCounterDataSourceStreams_Microsoft_Perf),
 * 						},
 * 					},
 * 				},
 * 				Syslog: insights.SyslogDataSourceArray{
 * 					&insights.SyslogDataSourceArgs{
 * 						FacilityNames: pulumi.StringArray{
 * 							pulumi.String(insights.KnownSyslogDataSourceFacilityNamesCron),
 * 						},
 * 						LogLevels: pulumi.StringArray{
 * 							pulumi.String(insights.KnownSyslogDataSourceLogLevelsDebug),
 * 							pulumi.String(insights.KnownSyslogDataSourceLogLevelsCritical),
 * 							pulumi.String(insights.KnownSyslogDataSourceLogLevelsEmergency),
 * 						},
 * 						Name: pulumi.String("cronSyslog"),
 * 						Streams: pulumi.StringArray{
 * 							pulumi.String(insights.KnownSyslogDataSourceStreams_Microsoft_Syslog),
 * 						},
 * 					},
 * 					&insights.SyslogDataSourceArgs{
 * 						FacilityNames: pulumi.StringArray{
 * 							pulumi.String(insights.KnownSyslogDataSourceFacilityNamesSyslog),
 * 						},
 * 						LogLevels: pulumi.StringArray{
 * 							pulumi.String(insights.KnownSyslogDataSourceLogLevelsAlert),
 * 							pulumi.String(insights.KnownSyslogDataSourceLogLevelsCritical),
 * 							pulumi.String(insights.KnownSyslogDataSourceLogLevelsEmergency),
 * 						},
 * 						Name: pulumi.String("syslogBase"),
 * 						Streams: pulumi.StringArray{
 * 							pulumi.String(insights.KnownSyslogDataSourceStreams_Microsoft_Syslog),
 * 						},
 * 					},
 * 				},
 * 				WindowsEventLogs: insights.WindowsEventLogDataSourceArray{
 * 					&insights.WindowsEventLogDataSourceArgs{
 * 						Name: pulumi.String("cloudSecurityTeamEvents"),
 * 						Streams: pulumi.StringArray{
 * 							pulumi.String(insights.KnownWindowsEventLogDataSourceStreams_Microsoft_WindowsEvent),
 * 						},
 * 						XPathQueries: pulumi.StringArray{
 * 							pulumi.String("Security!"),
 * 						},
 * 					},
 * 					&insights.WindowsEventLogDataSourceArgs{
 * 						Name: pulumi.String("appTeam1AppEvents"),
 * 						Streams: pulumi.StringArray{
 * 							pulumi.String(insights.KnownWindowsEventLogDataSourceStreams_Microsoft_WindowsEvent),
 * 						},
 * 						XPathQueries: pulumi.StringArray{
 * 							pulumi.String("System![System[(Level = 1 or Level = 2 or Level = 3)]]"),
 * 							pulumi.String("Application!*[System[(Level = 1 or Level = 2 or Level = 3)]]"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Destinations: &insights.DataCollectionRuleDestinationsArgs{
 * 				LogAnalytics: insights.LogAnalyticsDestinationArray{
 * 					&insights.LogAnalyticsDestinationArgs{
 * 						Name:                pulumi.String("centralWorkspace"),
 * 						WorkspaceResourceId: pulumi.String("/subscriptions/703362b3-f278-4e4b-9179-c76eaf41ffc2/resourceGroups/myResourceGroup/providers/Microsoft.OperationalInsights/workspaces/centralTeamWorkspace"),
 * 					},
 * 				},
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.DataCollectionRule;
 * import com.pulumi.azurenative.insights.DataCollectionRuleArgs;
 * import com.pulumi.azurenative.insights.inputs.DataFlowArgs;
 * import com.pulumi.azurenative.insights.inputs.DataCollectionRuleDataSourcesArgs;
 * import com.pulumi.azurenative.insights.inputs.DataCollectionRuleDestinationsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataCollectionRule = new DataCollectionRule("dataCollectionRule", DataCollectionRuleArgs.builder()
 *             .dataCollectionRuleName("myCollectionRule")
 *             .dataFlows(DataFlowArgs.builder()
 *                 .destinations("centralWorkspace")
 *                 .streams(
 *                     "Microsoft-Perf",
 *                     "Microsoft-Syslog",
 *                     "Microsoft-WindowsEvent")
 *                 .build())
 *             .dataSources(DataCollectionRuleDataSourcesArgs.builder()
 *                 .performanceCounters(
 *                     PerfCounterDataSourceArgs.builder()
 *                         .counterSpecifiers(
 *                             "\\Processor(_Total)\\% Processor Time",
 *                             "\\Memory\\Committed Bytes",
 *                             "\\LogicalDisk(_Total)\\Free Megabytes",
 *                             "\\PhysicalDisk(_Total)\\Avg. Disk Queue Length")
 *                         .name("cloudTeamCoreCounters")
 *                         .samplingFrequencyInSeconds(15)
 *                         .streams("Microsoft-Perf")
 *                         .build(),
 *                     PerfCounterDataSourceArgs.builder()
 *                         .counterSpecifiers("\\Process(_Total)\\Thread Count")
 *                         .name("appTeamExtraCounters")
 *                         .samplingFrequencyInSeconds(30)
 *                         .streams("Microsoft-Perf")
 *                         .build())
 *                 .syslog(
 *                     SyslogDataSourceArgs.builder()
 *                         .facilityNames("cron")
 *                         .logLevels(
 *                             "Debug",
 *                             "Critical",
 *                             "Emergency")
 *                         .name("cronSyslog")
 *                         .streams("Microsoft-Syslog")
 *                         .build(),
 *                     SyslogDataSourceArgs.builder()
 *                         .facilityNames("syslog")
 *                         .logLevels(
 *                             "Alert",
 *                             "Critical",
 *                             "Emergency")
 *                         .name("syslogBase")
 *                         .streams("Microsoft-Syslog")
 *                         .build())
 *                 .windowsEventLogs(
 *                     WindowsEventLogDataSourceArgs.builder()
 *                         .name("cloudSecurityTeamEvents")
 *                         .streams("Microsoft-WindowsEvent")
 *                         .xPathQueries("Security!")
 *                         .build(),
 *                     WindowsEventLogDataSourceArgs.builder()
 *                         .name("appTeam1AppEvents")
 *                         .streams("Microsoft-WindowsEvent")
 *                         .xPathQueries(
 *                             "System![System[(Level = 1 or Level = 2 or Level = 3)]]",
 *                             "Application!*[System[(Level = 1 or Level = 2 or Level = 3)]]")
 *                         .build())
 *                 .build())
 *             .destinations(DataCollectionRuleDestinationsArgs.builder()
 *                 .logAnalytics(LogAnalyticsDestinationArgs.builder()
 *                     .name("centralWorkspace")
 *                     .workspaceResourceId("/subscriptions/703362b3-f278-4e4b-9179-c76eaf41ffc2/resourceGroups/myResourceGroup/providers/Microsoft.OperationalInsights/workspaces/centralTeamWorkspace")
 *                     .build())
 *                 .build())
 *             .location("eastus")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:DataCollectionRule myCollectionRule /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionRules/{dataCollectionRuleName}
 * ```
 */
public class DataCollectionRule internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.DataCollectionRule,
) : KotlinCustomResource(javaResource, DataCollectionRuleMapper) {
    /**
     * The resource ID of the data collection endpoint that this rule can be used with.
     */
    public val dataCollectionEndpointId: Output<String>?
        get() = javaResource.dataCollectionEndpointId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The specification of data flows.
     */
    public val dataFlows: Output<List<DataFlowResponse>>?
        get() = javaResource.dataFlows().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> dataFlowResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The specification of data sources.
     * This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
     */
    public val dataSources: Output<DataCollectionRuleResponseDataSources>?
        get() = javaResource.dataSources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dataCollectionRuleResponseDataSourcesToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Description of the data collection rule.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The specification of destinations.
     */
    public val destinations: Output<DataCollectionRuleResponseDestinations>?
        get() = javaResource.destinations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dataCollectionRuleResponseDestinationsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource entity tag (ETag).
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Managed service identity of the resource.
     */
    public val identity: Output<DataCollectionRuleResourceResponseIdentity>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dataCollectionRuleResourceResponseIdentityToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The immutable ID of this data collection rule. This property is READ-ONLY.
     */
    public val immutableId: Output<String>
        get() = javaResource.immutableId().applyValue({ args0 -> args0 })

    /**
     * The kind of the resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The geo-location where the resource lives.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Metadata about the resource
     */
    public val metadata: Output<DataCollectionRuleResponseMetadata>
        get() = javaResource.metadata().applyValue({ args0 ->
            args0.let({ args0 ->
                dataCollectionRuleResponseMetadataToKotlin(args0)
            })
        })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The resource provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Declaration of custom streams used in this rule.
     */
    public val streamDeclarations: Output<Map<String, StreamDeclarationResponse>>?
        get() = javaResource.streamDeclarations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            streamDeclarationResponseToKotlin(args0)
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<DataCollectionRuleResourceResponseSystemData>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                dataCollectionRuleResourceResponseSystemDataToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DataCollectionRuleMapper : ResourceMapper<DataCollectionRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.DataCollectionRule::class == javaResource::class

    override fun map(javaResource: Resource): DataCollectionRule = DataCollectionRule(
        javaResource as
            com.pulumi.azurenative.insights.DataCollectionRule,
    )
}

/**
 * @see [DataCollectionRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataCollectionRule].
 */
public suspend fun dataCollectionRule(
    name: String,
    block: suspend DataCollectionRuleResourceBuilder.() -> Unit,
): DataCollectionRule {
    val builder = DataCollectionRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataCollectionRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataCollectionRule(name: String): DataCollectionRule {
    val builder = DataCollectionRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
