@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.DataCollectionRuleArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.KnownDataCollectionRuleResourceKind
import com.pulumi.azurenative.insights.kotlin.inputs.DataCollectionRuleDataSourcesArgs
import com.pulumi.azurenative.insights.kotlin.inputs.DataCollectionRuleDataSourcesArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.DataCollectionRuleDestinationsArgs
import com.pulumi.azurenative.insights.kotlin.inputs.DataCollectionRuleDestinationsArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.DataCollectionRuleResourceIdentityArgs
import com.pulumi.azurenative.insights.kotlin.inputs.DataCollectionRuleResourceIdentityArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.DataFlowArgs
import com.pulumi.azurenative.insights.kotlin.inputs.DataFlowArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.StreamDeclarationArgs
import com.pulumi.azurenative.insights.kotlin.inputs.StreamDeclarationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Definition of ARM tracked top level resource.
 * Azure REST API version: 2022-06-01. Prior API version in Azure Native 1.x: 2019-11-01-preview.
 * Other available API versions: 2023-03-11.
 * ## Example Usage
 * ### Create or update data collection rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataCollectionRule = new AzureNative.Insights.DataCollectionRule("dataCollectionRule", new()
 *     {
 *         DataCollectionRuleName = "myCollectionRule",
 *         DataFlows = new[]
 *         {
 *             new AzureNative.Insights.Inputs.DataFlowArgs
 *             {
 *                 Destinations = new[]
 *                 {
 *                     "centralWorkspace",
 *                 },
 *                 Streams = new[]
 *                 {
 *                     AzureNative.Insights.KnownDataFlowStreams.Microsoft_Perf,
 *                     AzureNative.Insights.KnownDataFlowStreams.Microsoft_Syslog,
 *                     AzureNative.Insights.KnownDataFlowStreams.Microsoft_WindowsEvent,
 *                 },
 *             },
 *         },
 *         DataSources = new AzureNative.Insights.Inputs.DataCollectionRuleDataSourcesArgs
 *         {
 *             PerformanceCounters = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.PerfCounterDataSourceArgs
 *                 {
 *                     CounterSpecifiers = new[]
 *                     {
 *                         "\\Processor(_Total)\\% Processor Time",
 *                         "\\Memory\\Committed Bytes",
 *                         "\\LogicalDisk(_Total)\\Free Megabytes",
 *                         "\\PhysicalDisk(_Total)\\Avg. Disk Queue Length",
 *                     },
 *                     Name = "cloudTeamCoreCounters",
 *                     SamplingFrequencyInSeconds = 15,
 *                     Streams = new[]
 *                     {
 *                         AzureNative.Insights.KnownPerfCounterDataSourceStreams.Microsoft_Perf,
 *                     },
 *                 },
 *                 new AzureNative.Insights.Inputs.PerfCounterDataSourceArgs
 *                 {
 *                     CounterSpecifiers = new[]
 *                     {
 *                         "\\Process(_Total)\\Thread Count",
 *                     },
 *                     Name = "appTeamExtraCounters",
 *                     SamplingFrequencyInSeconds = 30,
 *                     Streams = new[]
 *                     {
 *                         AzureNative.Insights.KnownPerfCounterDataSourceStreams.Microsoft_Perf,
 *                     },
 *                 },
 *             },
 *             Syslog = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.SyslogDataSourceArgs
 *                 {
 *                     FacilityNames = new[]
 *                     {
 *                         AzureNative.Insights.KnownSyslogDataSourceFacilityNames.Cron,
 *                     },
 *                     LogLevels = new[]
 *                     {
 *                         AzureNative.Insights.KnownSyslogDataSourceLogLevels.Debug,
 *                         AzureNative.Insights.KnownSyslogDataSourceLogLevels.Critical,
 *                         AzureNative.Insights.KnownSyslogDataSourceLogLevels.Emergency,
 *                     },
 *                     Name = "cronSyslog",
 *                     Streams = new[]
 *                     {
 *                         AzureNative.Insights.KnownSyslogDataSourceStreams.Microsoft_Syslog,
 *                     },
 *                 },
 *                 new AzureNative.Insights.Inputs.SyslogDataSourceArgs
 *                 {
 *                     FacilityNames = new[]
 *                     {
 *                         AzureNative.Insights.KnownSyslogDataSourceFacilityNames.Syslog,
 *                     },
 *                     LogLevels = new[]
 *                     {
 *                         AzureNative.Insights.KnownSyslogDataSourceLogLevels.Alert,
 *                         AzureNative.Insights.KnownSyslogDataSourceLogLevels.Critical,
 *                         AzureNative.Insights.KnownSyslogDataSourceLogLevels.Emergency,
 *                     },
 *                     Name = "syslogBase",
 *                     Streams = new[]
 *                     {
 *                         AzureNative.Insights.KnownSyslogDataSourceStreams.Microsoft_Syslog,
 *                     },
 *                 },
 *             },
 *             WindowsEventLogs = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.WindowsEventLogDataSourceArgs
 *                 {
 *                     Name = "cloudSecurityTeamEvents",
 *                     Streams = new[]
 *                     {
 *                         AzureNative.Insights.KnownWindowsEventLogDataSourceStreams.Microsoft_WindowsEvent,
 *                     },
 *                     XPathQueries = new[]
 *                     {
 *                         "Security!",
 *                     },
 *                 },
 *                 new AzureNative.Insights.Inputs.WindowsEventLogDataSourceArgs
 *                 {
 *                     Name = "appTeam1AppEvents",
 *                     Streams = new[]
 *                     {
 *                         AzureNative.Insights.KnownWindowsEventLogDataSourceStreams.Microsoft_WindowsEvent,
 *                     },
 *                     XPathQueries = new[]
 *                     {
 *                         "System![System[(Level = 1 or Level = 2 or Level = 3)]]",
 *                         "Application!*[System[(Level = 1 or Level = 2 or Level = 3)]]",
 *                     },
 *                 },
 *             },
 *         },
 *         Destinations = new AzureNative.Insights.Inputs.DataCollectionRuleDestinationsArgs
 *         {
 *             LogAnalytics = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.LogAnalyticsDestinationArgs
 *                 {
 *                     Name = "centralWorkspace",
 *                     WorkspaceResourceId = "/subscriptions/703362b3-f278-4e4b-9179-c76eaf41ffc2/resourceGroups/myResourceGroup/providers/Microsoft.OperationalInsights/workspaces/centralTeamWorkspace",
 *                 },
 *             },
 *         },
 *         Location = "eastus",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewDataCollectionRule(ctx, "dataCollectionRule", &insights.DataCollectionRuleArgs{
 * 			DataCollectionRuleName: pulumi.String("myCollectionRule"),
 * 			DataFlows: insights.DataFlowArray{
 * 				&insights.DataFlowArgs{
 * 					Destinations: pulumi.StringArray{
 * 						pulumi.String("centralWorkspace"),
 * 					},
 * 					Streams: pulumi.StringArray{
 * 						pulumi.String(insights.KnownDataFlowStreams_Microsoft_Perf),
 * 						pulumi.String(insights.KnownDataFlowStreams_Microsoft_Syslog),
 * 						pulumi.String(insights.KnownDataFlowStreams_Microsoft_WindowsEvent),
 * 					},
 * 				},
 * 			},
 * 			DataSources: &insights.DataCollectionRuleDataSourcesArgs{
 * 				PerformanceCounters: insights.PerfCounterDataSourceArray{
 * 					&insights.PerfCounterDataSourceArgs{
 * 						CounterSpecifiers: pulumi.StringArray{
 * 							pulumi.String("\\Processor(_Total)\\% Processor Time"),
 * 							pulumi.String("\\Memory\\Committed Bytes"),
 * 							pulumi.String("\\LogicalDisk(_Total)\\Free Megabytes"),
 * 							pulumi.String("\\PhysicalDisk(_Total)\\Avg. Disk Queue Length"),
 * 						},
 * 						Name:                       pulumi.String("cloudTeamCoreCounters"),
 * 						SamplingFrequencyInSeconds: pulumi.Int(15),
 * 						Streams: pulumi.StringArray{
 * 							pulumi.String(insights.KnownPerfCounterDataSourceStreams_Microsoft_Perf),
 * 						},
 * 					},
 * 					&insights.PerfCounterDataSourceArgs{
 * 						CounterSpecifiers: pulumi.StringArray{
 * 							pulumi.String("\\Process(_Total)\\Thread Count"),
 * 						},
 * 						Name:                       pulumi.String("appTeamExtraCounters"),
 * 						SamplingFrequencyInSeconds: pulumi.Int(30),
 * 						Streams: pulumi.StringArray{
 * 							pulumi.String(insights.KnownPerfCounterDataSourceStreams_Microsoft_Perf),
 * 						},
 * 					},
 * 				},
 * 				Syslog: insights.SyslogDataSourceArray{
 * 					&insights.SyslogDataSourceArgs{
 * 						FacilityNames: pulumi.StringArray{
 * 							pulumi.String(insights.KnownSyslogDataSourceFacilityNamesCron),
 * 						},
 * 						LogLevels: pulumi.StringArray{
 * 							pulumi.String(insights.KnownSyslogDataSourceLogLevelsDebug),
 * 							pulumi.String(insights.KnownSyslogDataSourceLogLevelsCritical),
 * 							pulumi.String(insights.KnownSyslogDataSourceLogLevelsEmergency),
 * 						},
 * 						Name: pulumi.String("cronSyslog"),
 * 						Streams: pulumi.StringArray{
 * 							pulumi.String(insights.KnownSyslogDataSourceStreams_Microsoft_Syslog),
 * 						},
 * 					},
 * 					&insights.SyslogDataSourceArgs{
 * 						FacilityNames: pulumi.StringArray{
 * 							pulumi.String(insights.KnownSyslogDataSourceFacilityNamesSyslog),
 * 						},
 * 						LogLevels: pulumi.StringArray{
 * 							pulumi.String(insights.KnownSyslogDataSourceLogLevelsAlert),
 * 							pulumi.String(insights.KnownSyslogDataSourceLogLevelsCritical),
 * 							pulumi.String(insights.KnownSyslogDataSourceLogLevelsEmergency),
 * 						},
 * 						Name: pulumi.String("syslogBase"),
 * 						Streams: pulumi.StringArray{
 * 							pulumi.String(insights.KnownSyslogDataSourceStreams_Microsoft_Syslog),
 * 						},
 * 					},
 * 				},
 * 				WindowsEventLogs: insights.WindowsEventLogDataSourceArray{
 * 					&insights.WindowsEventLogDataSourceArgs{
 * 						Name: pulumi.String("cloudSecurityTeamEvents"),
 * 						Streams: pulumi.StringArray{
 * 							pulumi.String(insights.KnownWindowsEventLogDataSourceStreams_Microsoft_WindowsEvent),
 * 						},
 * 						XPathQueries: pulumi.StringArray{
 * 							pulumi.String("Security!"),
 * 						},
 * 					},
 * 					&insights.WindowsEventLogDataSourceArgs{
 * 						Name: pulumi.String("appTeam1AppEvents"),
 * 						Streams: pulumi.StringArray{
 * 							pulumi.String(insights.KnownWindowsEventLogDataSourceStreams_Microsoft_WindowsEvent),
 * 						},
 * 						XPathQueries: pulumi.StringArray{
 * 							pulumi.String("System![System[(Level = 1 or Level = 2 or Level = 3)]]"),
 * 							pulumi.String("Application!*[System[(Level = 1 or Level = 2 or Level = 3)]]"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Destinations: &insights.DataCollectionRuleDestinationsArgs{
 * 				LogAnalytics: insights.LogAnalyticsDestinationArray{
 * 					&insights.LogAnalyticsDestinationArgs{
 * 						Name:                pulumi.String("centralWorkspace"),
 * 						WorkspaceResourceId: pulumi.String("/subscriptions/703362b3-f278-4e4b-9179-c76eaf41ffc2/resourceGroups/myResourceGroup/providers/Microsoft.OperationalInsights/workspaces/centralTeamWorkspace"),
 * 					},
 * 				},
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.DataCollectionRule;
 * import com.pulumi.azurenative.insights.DataCollectionRuleArgs;
 * import com.pulumi.azurenative.insights.inputs.DataFlowArgs;
 * import com.pulumi.azurenative.insights.inputs.DataCollectionRuleDataSourcesArgs;
 * import com.pulumi.azurenative.insights.inputs.DataCollectionRuleDestinationsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataCollectionRule = new DataCollectionRule("dataCollectionRule", DataCollectionRuleArgs.builder()
 *             .dataCollectionRuleName("myCollectionRule")
 *             .dataFlows(DataFlowArgs.builder()
 *                 .destinations("centralWorkspace")
 *                 .streams(
 *                     "Microsoft-Perf",
 *                     "Microsoft-Syslog",
 *                     "Microsoft-WindowsEvent")
 *                 .build())
 *             .dataSources(DataCollectionRuleDataSourcesArgs.builder()
 *                 .performanceCounters(
 *                     PerfCounterDataSourceArgs.builder()
 *                         .counterSpecifiers(
 *                             "\\Processor(_Total)\\% Processor Time",
 *                             "\\Memory\\Committed Bytes",
 *                             "\\LogicalDisk(_Total)\\Free Megabytes",
 *                             "\\PhysicalDisk(_Total)\\Avg. Disk Queue Length")
 *                         .name("cloudTeamCoreCounters")
 *                         .samplingFrequencyInSeconds(15)
 *                         .streams("Microsoft-Perf")
 *                         .build(),
 *                     PerfCounterDataSourceArgs.builder()
 *                         .counterSpecifiers("\\Process(_Total)\\Thread Count")
 *                         .name("appTeamExtraCounters")
 *                         .samplingFrequencyInSeconds(30)
 *                         .streams("Microsoft-Perf")
 *                         .build())
 *                 .syslog(
 *                     SyslogDataSourceArgs.builder()
 *                         .facilityNames("cron")
 *                         .logLevels(
 *                             "Debug",
 *                             "Critical",
 *                             "Emergency")
 *                         .name("cronSyslog")
 *                         .streams("Microsoft-Syslog")
 *                         .build(),
 *                     SyslogDataSourceArgs.builder()
 *                         .facilityNames("syslog")
 *                         .logLevels(
 *                             "Alert",
 *                             "Critical",
 *                             "Emergency")
 *                         .name("syslogBase")
 *                         .streams("Microsoft-Syslog")
 *                         .build())
 *                 .windowsEventLogs(
 *                     WindowsEventLogDataSourceArgs.builder()
 *                         .name("cloudSecurityTeamEvents")
 *                         .streams("Microsoft-WindowsEvent")
 *                         .xPathQueries("Security!")
 *                         .build(),
 *                     WindowsEventLogDataSourceArgs.builder()
 *                         .name("appTeam1AppEvents")
 *                         .streams("Microsoft-WindowsEvent")
 *                         .xPathQueries(
 *                             "System![System[(Level = 1 or Level = 2 or Level = 3)]]",
 *                             "Application!*[System[(Level = 1 or Level = 2 or Level = 3)]]")
 *                         .build())
 *                 .build())
 *             .destinations(DataCollectionRuleDestinationsArgs.builder()
 *                 .logAnalytics(LogAnalyticsDestinationArgs.builder()
 *                     .name("centralWorkspace")
 *                     .workspaceResourceId("/subscriptions/703362b3-f278-4e4b-9179-c76eaf41ffc2/resourceGroups/myResourceGroup/providers/Microsoft.OperationalInsights/workspaces/centralTeamWorkspace")
 *                     .build())
 *                 .build())
 *             .location("eastus")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:DataCollectionRule myCollectionRule /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionRules/{dataCollectionRuleName}
 * ```
 * @property dataCollectionEndpointId The resource ID of the data collection endpoint that this rule can be used with.
 * @property dataCollectionRuleName The name of the data collection rule. The name is case insensitive.
 * @property dataFlows The specification of data flows.
 * @property dataSources The specification of data sources.
 * This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
 * @property description Description of the data collection rule.
 * @property destinations The specification of destinations.
 * @property identity Managed service identity of the resource.
 * @property kind The kind of the resource.
 * @property location The geo-location where the resource lives.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property streamDeclarations Declaration of custom streams used in this rule.
 * @property tags Resource tags.
 */
public data class DataCollectionRuleArgs(
    public val dataCollectionEndpointId: Output<String>? = null,
    public val dataCollectionRuleName: Output<String>? = null,
    public val dataFlows: Output<List<DataFlowArgs>>? = null,
    public val dataSources: Output<DataCollectionRuleDataSourcesArgs>? = null,
    public val description: Output<String>? = null,
    public val destinations: Output<DataCollectionRuleDestinationsArgs>? = null,
    public val identity: Output<DataCollectionRuleResourceIdentityArgs>? = null,
    public val kind: Output<Either<String, KnownDataCollectionRuleResourceKind>>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val streamDeclarations: Output<Map<String, StreamDeclarationArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.DataCollectionRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.DataCollectionRuleArgs =
        com.pulumi.azurenative.insights.DataCollectionRuleArgs.builder()
            .dataCollectionEndpointId(dataCollectionEndpointId?.applyValue({ args0 -> args0 }))
            .dataCollectionRuleName(dataCollectionRuleName?.applyValue({ args0 -> args0 }))
            .dataFlows(
                dataFlows?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .dataSources(dataSources?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .destinations(destinations?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .streamDeclarations(
                streamDeclarations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DataCollectionRuleArgs].
 */
@PulumiTagMarker
public class DataCollectionRuleArgsBuilder internal constructor() {
    private var dataCollectionEndpointId: Output<String>? = null

    private var dataCollectionRuleName: Output<String>? = null

    private var dataFlows: Output<List<DataFlowArgs>>? = null

    private var dataSources: Output<DataCollectionRuleDataSourcesArgs>? = null

    private var description: Output<String>? = null

    private var destinations: Output<DataCollectionRuleDestinationsArgs>? = null

    private var identity: Output<DataCollectionRuleResourceIdentityArgs>? = null

    private var kind: Output<Either<String, KnownDataCollectionRuleResourceKind>>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var streamDeclarations: Output<Map<String, StreamDeclarationArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The resource ID of the data collection endpoint that this rule can be used with.
     */
    @JvmName("xwgrktplduvwptsj")
    public suspend fun dataCollectionEndpointId(`value`: Output<String>) {
        this.dataCollectionEndpointId = value
    }

    /**
     * @param value The name of the data collection rule. The name is case insensitive.
     */
    @JvmName("gkipqvndytwpkpbe")
    public suspend fun dataCollectionRuleName(`value`: Output<String>) {
        this.dataCollectionRuleName = value
    }

    /**
     * @param value The specification of data flows.
     */
    @JvmName("rclljhkqlfjqtatb")
    public suspend fun dataFlows(`value`: Output<List<DataFlowArgs>>) {
        this.dataFlows = value
    }

    @JvmName("dywcaihlqkkysnnp")
    public suspend fun dataFlows(vararg values: Output<DataFlowArgs>) {
        this.dataFlows = Output.all(values.asList())
    }

    /**
     * @param values The specification of data flows.
     */
    @JvmName("ruffwovnlixreujm")
    public suspend fun dataFlows(values: List<Output<DataFlowArgs>>) {
        this.dataFlows = Output.all(values)
    }

    /**
     * @param value The specification of data sources.
     * This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
     */
    @JvmName("pnfivxyryufwcvof")
    public suspend fun dataSources(`value`: Output<DataCollectionRuleDataSourcesArgs>) {
        this.dataSources = value
    }

    /**
     * @param value Description of the data collection rule.
     */
    @JvmName("wknrywxktoxlymqx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The specification of destinations.
     */
    @JvmName("xcrtevojukwfvfsx")
    public suspend fun destinations(`value`: Output<DataCollectionRuleDestinationsArgs>) {
        this.destinations = value
    }

    /**
     * @param value Managed service identity of the resource.
     */
    @JvmName("xvvennsfltgebykm")
    public suspend fun identity(`value`: Output<DataCollectionRuleResourceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The kind of the resource.
     */
    @JvmName("mcgiongcttdyndye")
    public suspend fun kind(`value`: Output<Either<String, KnownDataCollectionRuleResourceKind>>) {
        this.kind = value
    }

    /**
     * @param value The geo-location where the resource lives.
     */
    @JvmName("jqdmhbvfwwbjsktq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("odaypptcxgqksjkc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Declaration of custom streams used in this rule.
     */
    @JvmName("umhpywolcolggvhl")
    public suspend fun streamDeclarations(`value`: Output<Map<String, StreamDeclarationArgs>>) {
        this.streamDeclarations = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qqbdivytadnqbrga")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The resource ID of the data collection endpoint that this rule can be used with.
     */
    @JvmName("rtlrjqciveukmqnw")
    public suspend fun dataCollectionEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataCollectionEndpointId = mapped
    }

    /**
     * @param value The name of the data collection rule. The name is case insensitive.
     */
    @JvmName("tjgajpuveypmkjga")
    public suspend fun dataCollectionRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataCollectionRuleName = mapped
    }

    /**
     * @param value The specification of data flows.
     */
    @JvmName("ywvpmgmxstsjmekq")
    public suspend fun dataFlows(`value`: List<DataFlowArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataFlows = mapped
    }

    /**
     * @param argument The specification of data flows.
     */
    @JvmName("nofuxchirupwxtpj")
    public suspend fun dataFlows(argument: List<suspend DataFlowArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { DataFlowArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.dataFlows = mapped
    }

    /**
     * @param argument The specification of data flows.
     */
    @JvmName("naqiodlfvgomyuxm")
    public suspend fun dataFlows(vararg argument: suspend DataFlowArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { DataFlowArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.dataFlows = mapped
    }

    /**
     * @param argument The specification of data flows.
     */
    @JvmName("dgmwwmcxrgrhrcqm")
    public suspend fun dataFlows(argument: suspend DataFlowArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataFlowArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataFlows = mapped
    }

    /**
     * @param values The specification of data flows.
     */
    @JvmName("mfiqirlfnldhtmtq")
    public suspend fun dataFlows(vararg values: DataFlowArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataFlows = mapped
    }

    /**
     * @param value The specification of data sources.
     * This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
     */
    @JvmName("juatirrrkfbkplxp")
    public suspend fun dataSources(`value`: DataCollectionRuleDataSourcesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSources = mapped
    }

    /**
     * @param argument The specification of data sources.
     * This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
     */
    @JvmName("fbcsphlylsfupgod")
    public suspend
    fun dataSources(argument: suspend DataCollectionRuleDataSourcesArgsBuilder.() -> Unit) {
        val toBeMapped = DataCollectionRuleDataSourcesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataSources = mapped
    }

    /**
     * @param value Description of the data collection rule.
     */
    @JvmName("mmepcpnxiayhpcne")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The specification of destinations.
     */
    @JvmName("lpnmwxotibabblyj")
    public suspend fun destinations(`value`: DataCollectionRuleDestinationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param argument The specification of destinations.
     */
    @JvmName("vjrqefugnfnbxvtb")
    public suspend
    fun destinations(argument: suspend DataCollectionRuleDestinationsArgsBuilder.() -> Unit) {
        val toBeMapped = DataCollectionRuleDestinationsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param value Managed service identity of the resource.
     */
    @JvmName("rmoyrtmeetympxea")
    public suspend fun identity(`value`: DataCollectionRuleResourceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed service identity of the resource.
     */
    @JvmName("fsaqsdjonjmaqndb")
    public suspend
    fun identity(argument: suspend DataCollectionRuleResourceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = DataCollectionRuleResourceIdentityArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The kind of the resource.
     */
    @JvmName("gkvyylmtmxdbnwxk")
    public suspend fun kind(`value`: Either<String, KnownDataCollectionRuleResourceKind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The kind of the resource.
     */
    @JvmName("ieymbywbrolcuwnf")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KnownDataCollectionRuleResourceKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The kind of the resource.
     */
    @JvmName("rpscmptjeieuujhk")
    public fun kind(`value`: KnownDataCollectionRuleResourceKind) {
        val toBeMapped = Either.ofRight<String, KnownDataCollectionRuleResourceKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The geo-location where the resource lives.
     */
    @JvmName("yhiqduufrjqtyyee")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wonbjdocqefpsvbe")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Declaration of custom streams used in this rule.
     */
    @JvmName("kmkpkkwdcajbyoxh")
    public suspend fun streamDeclarations(`value`: Map<String, StreamDeclarationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamDeclarations = mapped
    }

    /**
     * @param argument Declaration of custom streams used in this rule.
     */
    @JvmName("jwswytrwhspvblev")
    public suspend fun streamDeclarations(
        vararg
        argument: Pair<String, suspend StreamDeclarationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                StreamDeclarationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.streamDeclarations = mapped
    }

    /**
     * @param values Declaration of custom streams used in this rule.
     */
    @JvmName("htldfrnokykfjvax")
    public fun streamDeclarations(vararg values: Pair<String, StreamDeclarationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streamDeclarations = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("pecvjgheujwykltp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("xygxkjtnadhdjknh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DataCollectionRuleArgs = DataCollectionRuleArgs(
        dataCollectionEndpointId = dataCollectionEndpointId,
        dataCollectionRuleName = dataCollectionRuleName,
        dataFlows = dataFlows,
        dataSources = dataSources,
        description = description,
        destinations = destinations,
        identity = identity,
        kind = kind,
        location = location,
        resourceGroupName = resourceGroupName,
        streamDeclarations = streamDeclarations,
        tags = tags,
    )
}
