@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.DataCollectionRuleAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Definition of generic ARM proxy resource.
 * Azure REST API version: 2022-06-01. Prior API version in Azure Native 1.x: 2019-11-01-preview.
 * Other available API versions: 2023-03-11.
 * ## Example Usage
 * ### Create or update association
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataCollectionRuleAssociation = new AzureNative.Insights.DataCollectionRuleAssociation("dataCollectionRuleAssociation", new()
 *     {
 *         AssociationName = "myAssociation",
 *         DataCollectionRuleId = "/subscriptions/703362b3-f278-4e4b-9179-c76eaf41ffc2/resourceGroups/myResourceGroup/providers/Microsoft.Insights/dataCollectionRules/myCollectionRule",
 *         ResourceUri = "subscriptions/703362b3-f278-4e4b-9179-c76eaf41ffc2/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachines/myVm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewDataCollectionRuleAssociation(ctx, "dataCollectionRuleAssociation", &insights.DataCollectionRuleAssociationArgs{
 * 			AssociationName:      pulumi.String("myAssociation"),
 * 			DataCollectionRuleId: pulumi.String("/subscriptions/703362b3-f278-4e4b-9179-c76eaf41ffc2/resourceGroups/myResourceGroup/providers/Microsoft.Insights/dataCollectionRules/myCollectionRule"),
 * 			ResourceUri:          pulumi.String("subscriptions/703362b3-f278-4e4b-9179-c76eaf41ffc2/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachines/myVm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.DataCollectionRuleAssociation;
 * import com.pulumi.azurenative.insights.DataCollectionRuleAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataCollectionRuleAssociation = new DataCollectionRuleAssociation("dataCollectionRuleAssociation", DataCollectionRuleAssociationArgs.builder()
 *             .associationName("myAssociation")
 *             .dataCollectionRuleId("/subscriptions/703362b3-f278-4e4b-9179-c76eaf41ffc2/resourceGroups/myResourceGroup/providers/Microsoft.Insights/dataCollectionRules/myCollectionRule")
 *             .resourceUri("subscriptions/703362b3-f278-4e4b-9179-c76eaf41ffc2/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachines/myVm")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:DataCollectionRuleAssociation myAssociation /{resourceUri}/providers/Microsoft.Insights/dataCollectionRuleAssociations/{associationName}
 * ```
 * @property associationName The name of the association. The name is case insensitive.
 * @property dataCollectionEndpointId The resource ID of the data collection endpoint that is to be associated.
 * @property dataCollectionRuleId The resource ID of the data collection rule that is to be associated.
 * @property description Description of the association.
 * @property resourceUri The identifier of the resource.
 */
public data class DataCollectionRuleAssociationArgs(
    public val associationName: Output<String>? = null,
    public val dataCollectionEndpointId: Output<String>? = null,
    public val dataCollectionRuleId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val resourceUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.DataCollectionRuleAssociationArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.DataCollectionRuleAssociationArgs =
        com.pulumi.azurenative.insights.DataCollectionRuleAssociationArgs.builder()
            .associationName(associationName?.applyValue({ args0 -> args0 }))
            .dataCollectionEndpointId(dataCollectionEndpointId?.applyValue({ args0 -> args0 }))
            .dataCollectionRuleId(dataCollectionRuleId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .resourceUri(resourceUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataCollectionRuleAssociationArgs].
 */
@PulumiTagMarker
public class DataCollectionRuleAssociationArgsBuilder internal constructor() {
    private var associationName: Output<String>? = null

    private var dataCollectionEndpointId: Output<String>? = null

    private var dataCollectionRuleId: Output<String>? = null

    private var description: Output<String>? = null

    private var resourceUri: Output<String>? = null

    /**
     * @param value The name of the association. The name is case insensitive.
     */
    @JvmName("copbuaoppqyildjg")
    public suspend fun associationName(`value`: Output<String>) {
        this.associationName = value
    }

    /**
     * @param value The resource ID of the data collection endpoint that is to be associated.
     */
    @JvmName("fluuvucbvuceyurb")
    public suspend fun dataCollectionEndpointId(`value`: Output<String>) {
        this.dataCollectionEndpointId = value
    }

    /**
     * @param value The resource ID of the data collection rule that is to be associated.
     */
    @JvmName("ikqqejbfvdadxlxn")
    public suspend fun dataCollectionRuleId(`value`: Output<String>) {
        this.dataCollectionRuleId = value
    }

    /**
     * @param value Description of the association.
     */
    @JvmName("cqdtwhrekkmnbcsp")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The identifier of the resource.
     */
    @JvmName("gkenkthapfukvqut")
    public suspend fun resourceUri(`value`: Output<String>) {
        this.resourceUri = value
    }

    /**
     * @param value The name of the association. The name is case insensitive.
     */
    @JvmName("easnceqivaxjktrm")
    public suspend fun associationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associationName = mapped
    }

    /**
     * @param value The resource ID of the data collection endpoint that is to be associated.
     */
    @JvmName("sctvrvbtwuyhpfvb")
    public suspend fun dataCollectionEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataCollectionEndpointId = mapped
    }

    /**
     * @param value The resource ID of the data collection rule that is to be associated.
     */
    @JvmName("jpbomwagorcdvhed")
    public suspend fun dataCollectionRuleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataCollectionRuleId = mapped
    }

    /**
     * @param value Description of the association.
     */
    @JvmName("wvkiuuaeafrmnucu")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The identifier of the resource.
     */
    @JvmName("wwcpixdlwjglgoij")
    public suspend fun resourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUri = mapped
    }

    internal fun build(): DataCollectionRuleAssociationArgs = DataCollectionRuleAssociationArgs(
        associationName = associationName,
        dataCollectionEndpointId = dataCollectionEndpointId,
        dataCollectionRuleId = dataCollectionRuleId,
        description = description,
        resourceUri = resourceUri,
    )
}
