@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [GuestDiagnosticsSettingsAssociation].
 */
@PulumiTagMarker
public class GuestDiagnosticsSettingsAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GuestDiagnosticsSettingsAssociationArgs =
        GuestDiagnosticsSettingsAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend GuestDiagnosticsSettingsAssociationArgsBuilder.() -> Unit) {
        val builder = GuestDiagnosticsSettingsAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GuestDiagnosticsSettingsAssociation {
        val builtJavaResource =
            com.pulumi.azurenative.insights.GuestDiagnosticsSettingsAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GuestDiagnosticsSettingsAssociation(builtJavaResource)
    }
}

/**
 * Virtual machine guest diagnostic settings resource.
 * Azure REST API version: 2018-06-01-preview. Prior API version in Azure Native 1.x: 2018-06-01-preview.
 * ## Example Usage
 * ### Create or update an guest diagnostic settings association
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var guestDiagnosticsSettingsAssociation = new AzureNative.Insights.GuestDiagnosticsSettingsAssociation("guestDiagnosticsSettingsAssociation", new()
 *     {
 *         AssociationName = "healthSystemMachineConfigAssociation",
 *         GuestDiagnosticSettingsName = "/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/Default-Association-ResourceGroup/providers/providers/microsoft.insights/guestDiagnosticSettings/vmSettingForSecurity",
 *         Location = "Global",
 *         ResourceUri = "subscriptions/8498f01b-8064-4e37-856e-318f3c6c685f/resourceGroups/healthsystem/providers/Microsoft.Compute/virtualMachines/eastussojai",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewGuestDiagnosticsSettingsAssociation(ctx, "guestDiagnosticsSettingsAssociation", &insights.GuestDiagnosticsSettingsAssociationArgs{
 * 			AssociationName:             pulumi.String("healthSystemMachineConfigAssociation"),
 * 			GuestDiagnosticSettingsName: pulumi.String("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/Default-Association-ResourceGroup/providers/providers/microsoft.insights/guestDiagnosticSettings/vmSettingForSecurity"),
 * 			Location:                    pulumi.String("Global"),
 * 			ResourceUri:                 pulumi.String("subscriptions/8498f01b-8064-4e37-856e-318f3c6c685f/resourceGroups/healthsystem/providers/Microsoft.Compute/virtualMachines/eastussojai"),
 * 			Tags:                        nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.GuestDiagnosticsSettingsAssociation;
 * import com.pulumi.azurenative.insights.GuestDiagnosticsSettingsAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var guestDiagnosticsSettingsAssociation = new GuestDiagnosticsSettingsAssociation("guestDiagnosticsSettingsAssociation", GuestDiagnosticsSettingsAssociationArgs.builder()
 *             .associationName("healthSystemMachineConfigAssociation")
 *             .guestDiagnosticSettingsName("/subscriptions/187f412d-1758-44d9-b052-169e2564721d/resourceGroups/Default-Association-ResourceGroup/providers/providers/microsoft.insights/guestDiagnosticSettings/vmSettingForSecurity")
 *             .location("Global")
 *             .resourceUri("subscriptions/8498f01b-8064-4e37-856e-318f3c6c685f/resourceGroups/healthsystem/providers/Microsoft.Compute/virtualMachines/eastussojai")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:GuestDiagnosticsSettingsAssociation healthSystemMachineConfigAssociation /{resourceUri}/providers/microsoft.insights/guestDiagnosticSettingsAssociation/{associationName}
 * ```
 */
public class GuestDiagnosticsSettingsAssociation internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.GuestDiagnosticsSettingsAssociation,
) : KotlinCustomResource(javaResource, GuestDiagnosticsSettingsAssociationMapper) {
    /**
     * The guest diagnostic settings name.
     */
    public val guestDiagnosticSettingsName: Output<String>
        get() = javaResource.guestDiagnosticSettingsName().applyValue({ args0 -> args0 })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Azure resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Azure resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GuestDiagnosticsSettingsAssociationMapper :
    ResourceMapper<GuestDiagnosticsSettingsAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.GuestDiagnosticsSettingsAssociation::class == javaResource::class

    override fun map(javaResource: Resource): GuestDiagnosticsSettingsAssociation =
        GuestDiagnosticsSettingsAssociation(
            javaResource as
                com.pulumi.azurenative.insights.GuestDiagnosticsSettingsAssociation,
        )
}

/**
 * @see [GuestDiagnosticsSettingsAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GuestDiagnosticsSettingsAssociation].
 */
public suspend fun guestDiagnosticsSettingsAssociation(
    name: String,
    block: suspend GuestDiagnosticsSettingsAssociationResourceBuilder.() -> Unit,
):
    GuestDiagnosticsSettingsAssociation {
    val builder = GuestDiagnosticsSettingsAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GuestDiagnosticsSettingsAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun guestDiagnosticsSettingsAssociation(name: String): GuestDiagnosticsSettingsAssociation {
    val builder = GuestDiagnosticsSettingsAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
