@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.InsightsFunctions.getActionGroupPlain
import com.pulumi.azurenative.insights.InsightsFunctions.getActivityLogAlertPlain
import com.pulumi.azurenative.insights.InsightsFunctions.getAlertRulePlain
import com.pulumi.azurenative.insights.InsightsFunctions.getAnalyticsItemPlain
import com.pulumi.azurenative.insights.InsightsFunctions.getAutoscaleSettingPlain
import com.pulumi.azurenative.insights.InsightsFunctions.getComponentCurrentBillingFeaturePlain
import com.pulumi.azurenative.insights.InsightsFunctions.getComponentLinkedStorageAccountPlain
import com.pulumi.azurenative.insights.InsightsFunctions.getComponentPlain
import com.pulumi.azurenative.insights.InsightsFunctions.getDataCollectionEndpointPlain
import com.pulumi.azurenative.insights.InsightsFunctions.getDataCollectionRuleAssociationPlain
import com.pulumi.azurenative.insights.InsightsFunctions.getDataCollectionRulePlain
import com.pulumi.azurenative.insights.InsightsFunctions.getDiagnosticServiceTokenReadOnlyPlain
import com.pulumi.azurenative.insights.InsightsFunctions.getDiagnosticServiceTokenReadWritePlain
import com.pulumi.azurenative.insights.InsightsFunctions.getDiagnosticSettingPlain
import com.pulumi.azurenative.insights.InsightsFunctions.getExportConfigurationPlain
import com.pulumi.azurenative.insights.InsightsFunctions.getFavoritePlain
import com.pulumi.azurenative.insights.InsightsFunctions.getGuestDiagnosticsSettingPlain
import com.pulumi.azurenative.insights.InsightsFunctions.getGuestDiagnosticsSettingsAssociationPlain
import com.pulumi.azurenative.insights.InsightsFunctions.getLiveTokenPlain
import com.pulumi.azurenative.insights.InsightsFunctions.getLogProfilePlain
import com.pulumi.azurenative.insights.InsightsFunctions.getManagementGroupDiagnosticSettingPlain
import com.pulumi.azurenative.insights.InsightsFunctions.getMetricAlertPlain
import com.pulumi.azurenative.insights.InsightsFunctions.getMyWorkbookPlain
import com.pulumi.azurenative.insights.InsightsFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.insights.InsightsFunctions.getPrivateLinkScopePlain
import com.pulumi.azurenative.insights.InsightsFunctions.getPrivateLinkScopedResourcePlain
import com.pulumi.azurenative.insights.InsightsFunctions.getProactiveDetectionConfigurationPlain
import com.pulumi.azurenative.insights.InsightsFunctions.getScheduledQueryRulePlain
import com.pulumi.azurenative.insights.InsightsFunctions.getSubscriptionDiagnosticSettingPlain
import com.pulumi.azurenative.insights.InsightsFunctions.getTenantActionGroupPlain
import com.pulumi.azurenative.insights.InsightsFunctions.getTestResultFilePlain
import com.pulumi.azurenative.insights.InsightsFunctions.getWebTestPlain
import com.pulumi.azurenative.insights.InsightsFunctions.getWorkbookPlain
import com.pulumi.azurenative.insights.InsightsFunctions.getWorkbookTemplatePlain
import com.pulumi.azurenative.insights.InsightsFunctions.listDiagnosticSettingsCategoryPlain
import com.pulumi.azurenative.insights.InsightsFunctions.listEASubscriptionListMigrationDatePostPlain
import com.pulumi.azurenative.insights.kotlin.inputs.GetActionGroupPlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetActionGroupPlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetActivityLogAlertPlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetActivityLogAlertPlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetAlertRulePlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetAlertRulePlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetAnalyticsItemPlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetAnalyticsItemPlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetAutoscaleSettingPlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetAutoscaleSettingPlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetComponentCurrentBillingFeaturePlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetComponentCurrentBillingFeaturePlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetComponentLinkedStorageAccountPlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetComponentLinkedStorageAccountPlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetComponentPlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetComponentPlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetDataCollectionEndpointPlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetDataCollectionEndpointPlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetDataCollectionRuleAssociationPlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetDataCollectionRuleAssociationPlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetDataCollectionRulePlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetDataCollectionRulePlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetDiagnosticServiceTokenReadOnlyPlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetDiagnosticServiceTokenReadOnlyPlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetDiagnosticServiceTokenReadWritePlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetDiagnosticServiceTokenReadWritePlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetDiagnosticSettingPlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetDiagnosticSettingPlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetExportConfigurationPlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetExportConfigurationPlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetFavoritePlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetFavoritePlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetGuestDiagnosticsSettingPlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetGuestDiagnosticsSettingPlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetGuestDiagnosticsSettingsAssociationPlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetGuestDiagnosticsSettingsAssociationPlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetLiveTokenPlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetLiveTokenPlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetLogProfilePlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetLogProfilePlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetManagementGroupDiagnosticSettingPlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetManagementGroupDiagnosticSettingPlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetMetricAlertPlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetMetricAlertPlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetMyWorkbookPlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetMyWorkbookPlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetPrivateLinkScopePlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetPrivateLinkScopePlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetPrivateLinkScopedResourcePlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetPrivateLinkScopedResourcePlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetProactiveDetectionConfigurationPlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetProactiveDetectionConfigurationPlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetScheduledQueryRulePlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetScheduledQueryRulePlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetSubscriptionDiagnosticSettingPlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetSubscriptionDiagnosticSettingPlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetTenantActionGroupPlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetTenantActionGroupPlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetTestResultFilePlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetTestResultFilePlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetWebTestPlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetWebTestPlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetWorkbookPlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetWorkbookPlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.GetWorkbookTemplatePlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.GetWorkbookTemplatePlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.ListDiagnosticSettingsCategoryPlainArgs
import com.pulumi.azurenative.insights.kotlin.inputs.ListDiagnosticSettingsCategoryPlainArgsBuilder
import com.pulumi.azurenative.insights.kotlin.outputs.GetActionGroupResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetActivityLogAlertResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetAlertRuleResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetAnalyticsItemResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetAutoscaleSettingResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetComponentCurrentBillingFeatureResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetComponentLinkedStorageAccountResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetComponentResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetDataCollectionEndpointResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetDataCollectionRuleAssociationResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetDataCollectionRuleResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetDiagnosticServiceTokenReadOnlyResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetDiagnosticServiceTokenReadWriteResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetDiagnosticSettingResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetExportConfigurationResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetFavoriteResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetGuestDiagnosticsSettingResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetGuestDiagnosticsSettingsAssociationResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetLiveTokenResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetLogProfileResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetManagementGroupDiagnosticSettingResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetMetricAlertResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetMyWorkbookResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetPrivateLinkScopeResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetPrivateLinkScopedResourceResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetProactiveDetectionConfigurationResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetScheduledQueryRuleResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetSubscriptionDiagnosticSettingResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetTenantActionGroupResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetTestResultFileResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetWebTestResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetWorkbookResult
import com.pulumi.azurenative.insights.kotlin.outputs.GetWorkbookTemplateResult
import com.pulumi.azurenative.insights.kotlin.outputs.ListDiagnosticSettingsCategoryResult
import com.pulumi.azurenative.insights.kotlin.outputs.ListEASubscriptionListMigrationDatePostResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.insights.kotlin.outputs.GetActionGroupResult.Companion.toKotlin as getActionGroupResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetActivityLogAlertResult.Companion.toKotlin as getActivityLogAlertResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetAlertRuleResult.Companion.toKotlin as getAlertRuleResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetAnalyticsItemResult.Companion.toKotlin as getAnalyticsItemResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetAutoscaleSettingResult.Companion.toKotlin as getAutoscaleSettingResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetComponentCurrentBillingFeatureResult.Companion.toKotlin as getComponentCurrentBillingFeatureResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetComponentLinkedStorageAccountResult.Companion.toKotlin as getComponentLinkedStorageAccountResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetComponentResult.Companion.toKotlin as getComponentResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetDataCollectionEndpointResult.Companion.toKotlin as getDataCollectionEndpointResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetDataCollectionRuleAssociationResult.Companion.toKotlin as getDataCollectionRuleAssociationResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetDataCollectionRuleResult.Companion.toKotlin as getDataCollectionRuleResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetDiagnosticServiceTokenReadOnlyResult.Companion.toKotlin as getDiagnosticServiceTokenReadOnlyResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetDiagnosticServiceTokenReadWriteResult.Companion.toKotlin as getDiagnosticServiceTokenReadWriteResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetDiagnosticSettingResult.Companion.toKotlin as getDiagnosticSettingResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetExportConfigurationResult.Companion.toKotlin as getExportConfigurationResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetFavoriteResult.Companion.toKotlin as getFavoriteResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetGuestDiagnosticsSettingResult.Companion.toKotlin as getGuestDiagnosticsSettingResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetGuestDiagnosticsSettingsAssociationResult.Companion.toKotlin as getGuestDiagnosticsSettingsAssociationResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetLiveTokenResult.Companion.toKotlin as getLiveTokenResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetLogProfileResult.Companion.toKotlin as getLogProfileResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetManagementGroupDiagnosticSettingResult.Companion.toKotlin as getManagementGroupDiagnosticSettingResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetMetricAlertResult.Companion.toKotlin as getMetricAlertResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetMyWorkbookResult.Companion.toKotlin as getMyWorkbookResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetPrivateLinkScopeResult.Companion.toKotlin as getPrivateLinkScopeResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetPrivateLinkScopedResourceResult.Companion.toKotlin as getPrivateLinkScopedResourceResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetProactiveDetectionConfigurationResult.Companion.toKotlin as getProactiveDetectionConfigurationResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetScheduledQueryRuleResult.Companion.toKotlin as getScheduledQueryRuleResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetSubscriptionDiagnosticSettingResult.Companion.toKotlin as getSubscriptionDiagnosticSettingResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetTenantActionGroupResult.Companion.toKotlin as getTenantActionGroupResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetTestResultFileResult.Companion.toKotlin as getTestResultFileResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetWebTestResult.Companion.toKotlin as getWebTestResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetWorkbookResult.Companion.toKotlin as getWorkbookResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.GetWorkbookTemplateResult.Companion.toKotlin as getWorkbookTemplateResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.ListDiagnosticSettingsCategoryResult.Companion.toKotlin as listDiagnosticSettingsCategoryResultToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.ListEASubscriptionListMigrationDatePostResult.Companion.toKotlin as listEASubscriptionListMigrationDatePostResultToKotlin

public object InsightsFunctions {
    /**
     * Get an action group.
     * Azure REST API version: 2023-01-01.
     * @param argument null
     * @return An action group resource.
     */
    public suspend fun getActionGroup(argument: GetActionGroupPlainArgs): GetActionGroupResult =
        getActionGroupResultToKotlin(getActionGroupPlain(argument.toJava()).await())

    /**
     * @see [getActionGroup].
     * @param actionGroupName The name of the action group.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An action group resource.
     */
    public suspend fun getActionGroup(actionGroupName: String, resourceGroupName: String):
        GetActionGroupResult {
        val argument = GetActionGroupPlainArgs(
            actionGroupName = actionGroupName,
            resourceGroupName = resourceGroupName,
        )
        return getActionGroupResultToKotlin(getActionGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getActionGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetActionGroupPlainArgs].
     * @return An action group resource.
     */
    public suspend fun getActionGroup(argument: suspend GetActionGroupPlainArgsBuilder.() -> Unit):
        GetActionGroupResult {
        val builder = GetActionGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getActionGroupResultToKotlin(getActionGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Get an Activity Log Alert rule.
     * Azure REST API version: 2020-10-01.
     * Other available API versions: 2017-04-01, 2023-01-01-preview.
     * @param argument null
     * @return An Activity Log Alert rule resource.
     */
    public suspend fun getActivityLogAlert(argument: GetActivityLogAlertPlainArgs):
        GetActivityLogAlertResult =
        getActivityLogAlertResultToKotlin(getActivityLogAlertPlain(argument.toJava()).await())

    /**
     * @see [getActivityLogAlert].
     * @param activityLogAlertName The name of the Activity Log Alert rule.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An Activity Log Alert rule resource.
     */
    public suspend fun getActivityLogAlert(activityLogAlertName: String, resourceGroupName: String):
        GetActivityLogAlertResult {
        val argument = GetActivityLogAlertPlainArgs(
            activityLogAlertName = activityLogAlertName,
            resourceGroupName = resourceGroupName,
        )
        return getActivityLogAlertResultToKotlin(getActivityLogAlertPlain(argument.toJava()).await())
    }

    /**
     * @see [getActivityLogAlert].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetActivityLogAlertPlainArgs].
     * @return An Activity Log Alert rule resource.
     */
    public suspend
    fun getActivityLogAlert(argument: suspend GetActivityLogAlertPlainArgsBuilder.() -> Unit):
        GetActivityLogAlertResult {
        val builder = GetActivityLogAlertPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getActivityLogAlertResultToKotlin(getActivityLogAlertPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a classic metric alert rule
     * Azure REST API version: 2016-03-01.
     * @param argument null
     * @return The alert rule resource.
     */
    public suspend fun getAlertRule(argument: GetAlertRulePlainArgs): GetAlertRuleResult =
        getAlertRuleResultToKotlin(getAlertRulePlain(argument.toJava()).await())

    /**
     * @see [getAlertRule].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param ruleName The name of the rule.
     * @return The alert rule resource.
     */
    public suspend fun getAlertRule(resourceGroupName: String, ruleName: String): GetAlertRuleResult {
        val argument = GetAlertRulePlainArgs(
            resourceGroupName = resourceGroupName,
            ruleName = ruleName,
        )
        return getAlertRuleResultToKotlin(getAlertRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getAlertRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetAlertRulePlainArgs].
     * @return The alert rule resource.
     */
    public suspend fun getAlertRule(argument: suspend GetAlertRulePlainArgsBuilder.() -> Unit):
        GetAlertRuleResult {
        val builder = GetAlertRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAlertRuleResultToKotlin(getAlertRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a specific Analytics Items defined within an Application Insights component.
     * Azure REST API version: 2015-05-01.
     * @param argument null
     * @return Properties that define an Analytics item that is associated to an Application Insights component.
     */
    public suspend fun getAnalyticsItem(argument: GetAnalyticsItemPlainArgs): GetAnalyticsItemResult =
        getAnalyticsItemResultToKotlin(getAnalyticsItemPlain(argument.toJava()).await())

    /**
     * @see [getAnalyticsItem].
     * @param id The Id of a specific item defined in the Application Insights component
     * @param name The name of a specific item defined in the Application Insights component
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param scopePath Enum indicating if this item definition is owned by a specific user or is shared between all users with access to the Application Insights component.
     * @return Properties that define an Analytics item that is associated to an Application Insights component.
     */
    public suspend fun getAnalyticsItem(
        id: String? = null,
        name: String? = null,
        resourceGroupName: String,
        resourceName: String,
        scopePath: String,
    ): GetAnalyticsItemResult {
        val argument = GetAnalyticsItemPlainArgs(
            id = id,
            name = name,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
            scopePath = scopePath,
        )
        return getAnalyticsItemResultToKotlin(getAnalyticsItemPlain(argument.toJava()).await())
    }

    /**
     * @see [getAnalyticsItem].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetAnalyticsItemPlainArgs].
     * @return Properties that define an Analytics item that is associated to an Application Insights component.
     */
    public suspend
    fun getAnalyticsItem(argument: suspend GetAnalyticsItemPlainArgsBuilder.() -> Unit):
        GetAnalyticsItemResult {
        val builder = GetAnalyticsItemPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAnalyticsItemResultToKotlin(getAnalyticsItemPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an autoscale setting
     * Azure REST API version: 2022-10-01.
     * @param argument null
     * @return The autoscale setting resource.
     */
    public suspend fun getAutoscaleSetting(argument: GetAutoscaleSettingPlainArgs):
        GetAutoscaleSettingResult =
        getAutoscaleSettingResultToKotlin(getAutoscaleSettingPlain(argument.toJava()).await())

    /**
     * @see [getAutoscaleSetting].
     * @param autoscaleSettingName The autoscale setting name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The autoscale setting resource.
     */
    public suspend fun getAutoscaleSetting(autoscaleSettingName: String, resourceGroupName: String):
        GetAutoscaleSettingResult {
        val argument = GetAutoscaleSettingPlainArgs(
            autoscaleSettingName = autoscaleSettingName,
            resourceGroupName = resourceGroupName,
        )
        return getAutoscaleSettingResultToKotlin(getAutoscaleSettingPlain(argument.toJava()).await())
    }

    /**
     * @see [getAutoscaleSetting].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetAutoscaleSettingPlainArgs].
     * @return The autoscale setting resource.
     */
    public suspend
    fun getAutoscaleSetting(argument: suspend GetAutoscaleSettingPlainArgsBuilder.() -> Unit):
        GetAutoscaleSettingResult {
        val builder = GetAutoscaleSettingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAutoscaleSettingResultToKotlin(getAutoscaleSettingPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns an Application Insights component.
     * Azure REST API version: 2020-02-02.
     * Other available API versions: 2020-02-02-preview.
     * @param argument null
     * @return An Application Insights component definition.
     */
    public suspend fun getComponent(argument: GetComponentPlainArgs): GetComponentResult =
        getComponentResultToKotlin(getComponentPlain(argument.toJava()).await())

    /**
     * @see [getComponent].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @return An Application Insights component definition.
     */
    public suspend fun getComponent(resourceGroupName: String, resourceName: String):
        GetComponentResult {
        val argument = GetComponentPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getComponentResultToKotlin(getComponentPlain(argument.toJava()).await())
    }

    /**
     * @see [getComponent].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetComponentPlainArgs].
     * @return An Application Insights component definition.
     */
    public suspend fun getComponent(argument: suspend GetComponentPlainArgsBuilder.() -> Unit):
        GetComponentResult {
        val builder = GetComponentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getComponentResultToKotlin(getComponentPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns current billing features for an Application Insights component.
     * Azure REST API version: 2015-05-01.
     * @param argument null
     * @return An Application Insights component billing features
     */
    public suspend
    fun getComponentCurrentBillingFeature(argument: GetComponentCurrentBillingFeaturePlainArgs):
        GetComponentCurrentBillingFeatureResult =
        getComponentCurrentBillingFeatureResultToKotlin(getComponentCurrentBillingFeaturePlain(argument.toJava()).await())

    /**
     * @see [getComponentCurrentBillingFeature].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @return An Application Insights component billing features
     */
    public suspend fun getComponentCurrentBillingFeature(
        resourceGroupName: String,
        resourceName: String,
    ): GetComponentCurrentBillingFeatureResult {
        val argument = GetComponentCurrentBillingFeaturePlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getComponentCurrentBillingFeatureResultToKotlin(getComponentCurrentBillingFeaturePlain(argument.toJava()).await())
    }

    /**
     * @see [getComponentCurrentBillingFeature].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetComponentCurrentBillingFeaturePlainArgs].
     * @return An Application Insights component billing features
     */
    public suspend
    fun getComponentCurrentBillingFeature(argument: suspend GetComponentCurrentBillingFeaturePlainArgsBuilder.() -> Unit):
        GetComponentCurrentBillingFeatureResult {
        val builder = GetComponentCurrentBillingFeaturePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getComponentCurrentBillingFeatureResultToKotlin(getComponentCurrentBillingFeaturePlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the current linked storage settings for an Application Insights component.
     * Azure REST API version: 2020-03-01-preview.
     * @param argument null
     * @return An Application Insights component linked storage accounts
     */
    public suspend
    fun getComponentLinkedStorageAccount(argument: GetComponentLinkedStorageAccountPlainArgs):
        GetComponentLinkedStorageAccountResult =
        getComponentLinkedStorageAccountResultToKotlin(getComponentLinkedStorageAccountPlain(argument.toJava()).await())

    /**
     * @see [getComponentLinkedStorageAccount].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param storageType The type of the Application Insights component data source for the linked storage account.
     * @return An Application Insights component linked storage accounts
     */
    public suspend fun getComponentLinkedStorageAccount(
        resourceGroupName: String,
        resourceName: String,
        storageType: String,
    ): GetComponentLinkedStorageAccountResult {
        val argument = GetComponentLinkedStorageAccountPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
            storageType = storageType,
        )
        return getComponentLinkedStorageAccountResultToKotlin(getComponentLinkedStorageAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getComponentLinkedStorageAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetComponentLinkedStorageAccountPlainArgs].
     * @return An Application Insights component linked storage accounts
     */
    public suspend
    fun getComponentLinkedStorageAccount(argument: suspend GetComponentLinkedStorageAccountPlainArgsBuilder.() -> Unit):
        GetComponentLinkedStorageAccountResult {
        val builder = GetComponentLinkedStorageAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getComponentLinkedStorageAccountResultToKotlin(getComponentLinkedStorageAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Definition of ARM tracked top level resource.
     * Azure REST API version: 2022-06-01.
     * Other available API versions: 2023-03-11.
     * @param argument null
     * @return Definition of ARM tracked top level resource.
     */
    public suspend fun getDataCollectionEndpoint(argument: GetDataCollectionEndpointPlainArgs):
        GetDataCollectionEndpointResult =
        getDataCollectionEndpointResultToKotlin(getDataCollectionEndpointPlain(argument.toJava()).await())

    /**
     * @see [getDataCollectionEndpoint].
     * @param dataCollectionEndpointName The name of the data collection endpoint. The name is case insensitive.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Definition of ARM tracked top level resource.
     */
    public suspend fun getDataCollectionEndpoint(
        dataCollectionEndpointName: String,
        resourceGroupName: String,
    ): GetDataCollectionEndpointResult {
        val argument = GetDataCollectionEndpointPlainArgs(
            dataCollectionEndpointName = dataCollectionEndpointName,
            resourceGroupName = resourceGroupName,
        )
        return getDataCollectionEndpointResultToKotlin(getDataCollectionEndpointPlain(argument.toJava()).await())
    }

    /**
     * @see [getDataCollectionEndpoint].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetDataCollectionEndpointPlainArgs].
     * @return Definition of ARM tracked top level resource.
     */
    public suspend
    fun getDataCollectionEndpoint(argument: suspend GetDataCollectionEndpointPlainArgsBuilder.() -> Unit):
        GetDataCollectionEndpointResult {
        val builder = GetDataCollectionEndpointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataCollectionEndpointResultToKotlin(getDataCollectionEndpointPlain(builtArgument.toJava()).await())
    }

    /**
     * Definition of ARM tracked top level resource.
     * Azure REST API version: 2022-06-01.
     * Other available API versions: 2023-03-11.
     * @param argument null
     * @return Definition of ARM tracked top level resource.
     */
    public suspend fun getDataCollectionRule(argument: GetDataCollectionRulePlainArgs):
        GetDataCollectionRuleResult =
        getDataCollectionRuleResultToKotlin(getDataCollectionRulePlain(argument.toJava()).await())

    /**
     * @see [getDataCollectionRule].
     * @param dataCollectionRuleName The name of the data collection rule. The name is case insensitive.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Definition of ARM tracked top level resource.
     */
    public suspend fun getDataCollectionRule(
        dataCollectionRuleName: String,
        resourceGroupName: String,
    ): GetDataCollectionRuleResult {
        val argument = GetDataCollectionRulePlainArgs(
            dataCollectionRuleName = dataCollectionRuleName,
            resourceGroupName = resourceGroupName,
        )
        return getDataCollectionRuleResultToKotlin(getDataCollectionRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getDataCollectionRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetDataCollectionRulePlainArgs].
     * @return Definition of ARM tracked top level resource.
     */
    public suspend
    fun getDataCollectionRule(argument: suspend GetDataCollectionRulePlainArgsBuilder.() -> Unit):
        GetDataCollectionRuleResult {
        val builder = GetDataCollectionRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataCollectionRuleResultToKotlin(getDataCollectionRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Definition of generic ARM proxy resource.
     * Azure REST API version: 2022-06-01.
     * Other available API versions: 2023-03-11.
     * @param argument null
     * @return Definition of generic ARM proxy resource.
     */
    public suspend
    fun getDataCollectionRuleAssociation(argument: GetDataCollectionRuleAssociationPlainArgs):
        GetDataCollectionRuleAssociationResult =
        getDataCollectionRuleAssociationResultToKotlin(getDataCollectionRuleAssociationPlain(argument.toJava()).await())

    /**
     * @see [getDataCollectionRuleAssociation].
     * @param associationName The name of the association. The name is case insensitive.
     * @param resourceUri The identifier of the resource.
     * @return Definition of generic ARM proxy resource.
     */
    public suspend fun getDataCollectionRuleAssociation(associationName: String, resourceUri: String):
        GetDataCollectionRuleAssociationResult {
        val argument = GetDataCollectionRuleAssociationPlainArgs(
            associationName = associationName,
            resourceUri = resourceUri,
        )
        return getDataCollectionRuleAssociationResultToKotlin(getDataCollectionRuleAssociationPlain(argument.toJava()).await())
    }

    /**
     * @see [getDataCollectionRuleAssociation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetDataCollectionRuleAssociationPlainArgs].
     * @return Definition of generic ARM proxy resource.
     */
    public suspend
    fun getDataCollectionRuleAssociation(argument: suspend GetDataCollectionRuleAssociationPlainArgsBuilder.() -> Unit):
        GetDataCollectionRuleAssociationResult {
        val builder = GetDataCollectionRuleAssociationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataCollectionRuleAssociationResultToKotlin(getDataCollectionRuleAssociationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an read-only access token for application insights diagnostic service data.
     * Azure REST API version: 2021-03-03-preview.
     * @param argument null
     * @return The response to a diagnostic services token query.
     */
    public suspend
    fun getDiagnosticServiceTokenReadOnly(argument: GetDiagnosticServiceTokenReadOnlyPlainArgs):
        GetDiagnosticServiceTokenReadOnlyResult =
        getDiagnosticServiceTokenReadOnlyResultToKotlin(getDiagnosticServiceTokenReadOnlyPlain(argument.toJava()).await())

    /**
     * @see [getDiagnosticServiceTokenReadOnly].
     * @param resourceUri The identifier of the resource.
     * @return The response to a diagnostic services token query.
     */
    public suspend fun getDiagnosticServiceTokenReadOnly(resourceUri: String):
        GetDiagnosticServiceTokenReadOnlyResult {
        val argument = GetDiagnosticServiceTokenReadOnlyPlainArgs(
            resourceUri = resourceUri,
        )
        return getDiagnosticServiceTokenReadOnlyResultToKotlin(getDiagnosticServiceTokenReadOnlyPlain(argument.toJava()).await())
    }

    /**
     * @see [getDiagnosticServiceTokenReadOnly].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetDiagnosticServiceTokenReadOnlyPlainArgs].
     * @return The response to a diagnostic services token query.
     */
    public suspend
    fun getDiagnosticServiceTokenReadOnly(argument: suspend GetDiagnosticServiceTokenReadOnlyPlainArgsBuilder.() -> Unit):
        GetDiagnosticServiceTokenReadOnlyResult {
        val builder = GetDiagnosticServiceTokenReadOnlyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDiagnosticServiceTokenReadOnlyResultToKotlin(getDiagnosticServiceTokenReadOnlyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an read-write access token for application insights diagnostic service data.
     * Azure REST API version: 2021-03-03-preview.
     * @param argument null
     * @return The response to a diagnostic services token query.
     */
    public suspend
    fun getDiagnosticServiceTokenReadWrite(argument: GetDiagnosticServiceTokenReadWritePlainArgs):
        GetDiagnosticServiceTokenReadWriteResult =
        getDiagnosticServiceTokenReadWriteResultToKotlin(getDiagnosticServiceTokenReadWritePlain(argument.toJava()).await())

    /**
     * @see [getDiagnosticServiceTokenReadWrite].
     * @param resourceUri The identifier of the resource.
     * @return The response to a diagnostic services token query.
     */
    public suspend fun getDiagnosticServiceTokenReadWrite(resourceUri: String):
        GetDiagnosticServiceTokenReadWriteResult {
        val argument = GetDiagnosticServiceTokenReadWritePlainArgs(
            resourceUri = resourceUri,
        )
        return getDiagnosticServiceTokenReadWriteResultToKotlin(getDiagnosticServiceTokenReadWritePlain(argument.toJava()).await())
    }

    /**
     * @see [getDiagnosticServiceTokenReadWrite].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetDiagnosticServiceTokenReadWritePlainArgs].
     * @return The response to a diagnostic services token query.
     */
    public suspend
    fun getDiagnosticServiceTokenReadWrite(argument: suspend GetDiagnosticServiceTokenReadWritePlainArgsBuilder.() -> Unit):
        GetDiagnosticServiceTokenReadWriteResult {
        val builder = GetDiagnosticServiceTokenReadWritePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDiagnosticServiceTokenReadWriteResultToKotlin(getDiagnosticServiceTokenReadWritePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the active diagnostic settings for the specified resource.
     * Azure REST API version: 2021-05-01-preview.
     * @param argument null
     * @return The diagnostic setting resource.
     */
    public suspend fun getDiagnosticSetting(argument: GetDiagnosticSettingPlainArgs):
        GetDiagnosticSettingResult =
        getDiagnosticSettingResultToKotlin(getDiagnosticSettingPlain(argument.toJava()).await())

    /**
     * @see [getDiagnosticSetting].
     * @param name The name of the diagnostic setting.
     * @param resourceUri The identifier of the resource.
     * @return The diagnostic setting resource.
     */
    public suspend fun getDiagnosticSetting(name: String, resourceUri: String):
        GetDiagnosticSettingResult {
        val argument = GetDiagnosticSettingPlainArgs(
            name = name,
            resourceUri = resourceUri,
        )
        return getDiagnosticSettingResultToKotlin(getDiagnosticSettingPlain(argument.toJava()).await())
    }

    /**
     * @see [getDiagnosticSetting].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetDiagnosticSettingPlainArgs].
     * @return The diagnostic setting resource.
     */
    public suspend
    fun getDiagnosticSetting(argument: suspend GetDiagnosticSettingPlainArgsBuilder.() -> Unit):
        GetDiagnosticSettingResult {
        val builder = GetDiagnosticSettingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDiagnosticSettingResultToKotlin(getDiagnosticSettingPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the Continuous Export configuration for this export id.
     * Azure REST API version: 2015-05-01.
     * @param argument null
     * @return Properties that define a Continuous Export configuration.
     */
    public suspend fun getExportConfiguration(argument: GetExportConfigurationPlainArgs):
        GetExportConfigurationResult =
        getExportConfigurationResultToKotlin(getExportConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getExportConfiguration].
     * @param exportId The Continuous Export configuration ID. This is unique within a Application Insights component.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @return Properties that define a Continuous Export configuration.
     */
    public suspend fun getExportConfiguration(
        exportId: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetExportConfigurationResult {
        val argument = GetExportConfigurationPlainArgs(
            exportId = exportId,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getExportConfigurationResultToKotlin(getExportConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getExportConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetExportConfigurationPlainArgs].
     * @return Properties that define a Continuous Export configuration.
     */
    public suspend
    fun getExportConfiguration(argument: suspend GetExportConfigurationPlainArgsBuilder.() -> Unit):
        GetExportConfigurationResult {
        val builder = GetExportConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getExportConfigurationResultToKotlin(getExportConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a single favorite by its FavoriteId, defined within an Application Insights component.
     * Azure REST API version: 2015-05-01.
     * @param argument null
     * @return Properties that define a favorite that is associated to an Application Insights component.
     */
    public suspend fun getFavorite(argument: GetFavoritePlainArgs): GetFavoriteResult =
        getFavoriteResultToKotlin(getFavoritePlain(argument.toJava()).await())

    /**
     * @see [getFavorite].
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @return Properties that define a favorite that is associated to an Application Insights component.
     */
    public suspend fun getFavorite(
        favoriteId: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetFavoriteResult {
        val argument = GetFavoritePlainArgs(
            favoriteId = favoriteId,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getFavoriteResultToKotlin(getFavoritePlain(argument.toJava()).await())
    }

    /**
     * @see [getFavorite].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetFavoritePlainArgs].
     * @return Properties that define a favorite that is associated to an Application Insights component.
     */
    public suspend fun getFavorite(argument: suspend GetFavoritePlainArgsBuilder.() -> Unit):
        GetFavoriteResult {
        val builder = GetFavoritePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFavoriteResultToKotlin(getFavoritePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets guest diagnostics settings.
     * Azure REST API version: 2018-06-01-preview.
     * @param argument null
     * @return Virtual machine guest diagnostics settings resource.
     */
    public suspend fun getGuestDiagnosticsSetting(argument: GetGuestDiagnosticsSettingPlainArgs):
        GetGuestDiagnosticsSettingResult =
        getGuestDiagnosticsSettingResultToKotlin(getGuestDiagnosticsSettingPlain(argument.toJava()).await())

    /**
     * @see [getGuestDiagnosticsSetting].
     * @param diagnosticSettingsName The name of the diagnostic setting.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Virtual machine guest diagnostics settings resource.
     */
    public suspend fun getGuestDiagnosticsSetting(
        diagnosticSettingsName: String,
        resourceGroupName: String,
    ): GetGuestDiagnosticsSettingResult {
        val argument = GetGuestDiagnosticsSettingPlainArgs(
            diagnosticSettingsName = diagnosticSettingsName,
            resourceGroupName = resourceGroupName,
        )
        return getGuestDiagnosticsSettingResultToKotlin(getGuestDiagnosticsSettingPlain(argument.toJava()).await())
    }

    /**
     * @see [getGuestDiagnosticsSetting].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetGuestDiagnosticsSettingPlainArgs].
     * @return Virtual machine guest diagnostics settings resource.
     */
    public suspend
    fun getGuestDiagnosticsSetting(argument: suspend GetGuestDiagnosticsSettingPlainArgsBuilder.() -> Unit):
        GetGuestDiagnosticsSettingResult {
        val builder = GetGuestDiagnosticsSettingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGuestDiagnosticsSettingResultToKotlin(getGuestDiagnosticsSettingPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets guest diagnostics association settings.
     * Azure REST API version: 2018-06-01-preview.
     * @param argument null
     * @return Virtual machine guest diagnostic settings resource.
     */
    public suspend
    fun getGuestDiagnosticsSettingsAssociation(argument: GetGuestDiagnosticsSettingsAssociationPlainArgs):
        GetGuestDiagnosticsSettingsAssociationResult =
        getGuestDiagnosticsSettingsAssociationResultToKotlin(getGuestDiagnosticsSettingsAssociationPlain(argument.toJava()).await())

    /**
     * @see [getGuestDiagnosticsSettingsAssociation].
     * @param associationName The name of the diagnostic settings association.
     * @param resourceUri The fully qualified ID of the resource, including the resource name and resource type.
     * @return Virtual machine guest diagnostic settings resource.
     */
    public suspend fun getGuestDiagnosticsSettingsAssociation(
        associationName: String,
        resourceUri: String,
    ): GetGuestDiagnosticsSettingsAssociationResult {
        val argument = GetGuestDiagnosticsSettingsAssociationPlainArgs(
            associationName = associationName,
            resourceUri = resourceUri,
        )
        return getGuestDiagnosticsSettingsAssociationResultToKotlin(getGuestDiagnosticsSettingsAssociationPlain(argument.toJava()).await())
    }

    /**
     * @see [getGuestDiagnosticsSettingsAssociation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetGuestDiagnosticsSettingsAssociationPlainArgs].
     * @return Virtual machine guest diagnostic settings resource.
     */
    public suspend
    fun getGuestDiagnosticsSettingsAssociation(argument: suspend GetGuestDiagnosticsSettingsAssociationPlainArgsBuilder.() -> Unit):
        GetGuestDiagnosticsSettingsAssociationResult {
        val builder = GetGuestDiagnosticsSettingsAssociationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGuestDiagnosticsSettingsAssociationResultToKotlin(getGuestDiagnosticsSettingsAssociationPlain(builtArgument.toJava()).await())
    }

    /**
     * **Gets an access token for live metrics stream data.**
     * Azure REST API version: 2021-10-14.
     * Other available API versions: 2020-06-02-preview.
     * @param argument null
     * @return The response to a live token query.
     */
    public suspend fun getLiveToken(argument: GetLiveTokenPlainArgs): GetLiveTokenResult =
        getLiveTokenResultToKotlin(getLiveTokenPlain(argument.toJava()).await())

    /**
     * @see [getLiveToken].
     * @param resourceUri The identifier of the resource.
     * @return The response to a live token query.
     */
    public suspend fun getLiveToken(resourceUri: String): GetLiveTokenResult {
        val argument = GetLiveTokenPlainArgs(
            resourceUri = resourceUri,
        )
        return getLiveTokenResultToKotlin(getLiveTokenPlain(argument.toJava()).await())
    }

    /**
     * @see [getLiveToken].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetLiveTokenPlainArgs].
     * @return The response to a live token query.
     */
    public suspend fun getLiveToken(argument: suspend GetLiveTokenPlainArgsBuilder.() -> Unit):
        GetLiveTokenResult {
        val builder = GetLiveTokenPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLiveTokenResultToKotlin(getLiveTokenPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the log profile.
     * Azure REST API version: 2016-03-01.
     * @param argument null
     * @return The log profile resource.
     */
    public suspend fun getLogProfile(argument: GetLogProfilePlainArgs): GetLogProfileResult =
        getLogProfileResultToKotlin(getLogProfilePlain(argument.toJava()).await())

    /**
     * @see [getLogProfile].
     * @param logProfileName The name of the log profile.
     * @return The log profile resource.
     */
    public suspend fun getLogProfile(logProfileName: String): GetLogProfileResult {
        val argument = GetLogProfilePlainArgs(
            logProfileName = logProfileName,
        )
        return getLogProfileResultToKotlin(getLogProfilePlain(argument.toJava()).await())
    }

    /**
     * @see [getLogProfile].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetLogProfilePlainArgs].
     * @return The log profile resource.
     */
    public suspend fun getLogProfile(argument: suspend GetLogProfilePlainArgsBuilder.() -> Unit):
        GetLogProfileResult {
        val builder = GetLogProfilePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLogProfileResultToKotlin(getLogProfilePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the active management group diagnostic settings for the specified resource.
     * Azure REST API version: 2021-05-01-preview.
     * Other available API versions: 2020-01-01-preview.
     * @param argument null
     * @return The management group diagnostic setting resource.
     */
    public suspend
    fun getManagementGroupDiagnosticSetting(argument: GetManagementGroupDiagnosticSettingPlainArgs):
        GetManagementGroupDiagnosticSettingResult =
        getManagementGroupDiagnosticSettingResultToKotlin(getManagementGroupDiagnosticSettingPlain(argument.toJava()).await())

    /**
     * @see [getManagementGroupDiagnosticSetting].
     * @param managementGroupId The management group id.
     * @param name The name of the diagnostic setting.
     * @return The management group diagnostic setting resource.
     */
    public suspend fun getManagementGroupDiagnosticSetting(managementGroupId: String, name: String):
        GetManagementGroupDiagnosticSettingResult {
        val argument = GetManagementGroupDiagnosticSettingPlainArgs(
            managementGroupId = managementGroupId,
            name = name,
        )
        return getManagementGroupDiagnosticSettingResultToKotlin(getManagementGroupDiagnosticSettingPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagementGroupDiagnosticSetting].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetManagementGroupDiagnosticSettingPlainArgs].
     * @return The management group diagnostic setting resource.
     */
    public suspend
    fun getManagementGroupDiagnosticSetting(argument: suspend GetManagementGroupDiagnosticSettingPlainArgsBuilder.() -> Unit):
        GetManagementGroupDiagnosticSettingResult {
        val builder = GetManagementGroupDiagnosticSettingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagementGroupDiagnosticSettingResultToKotlin(getManagementGroupDiagnosticSettingPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve an alert rule definition.
     * Azure REST API version: 2018-03-01.
     * @param argument null
     * @return The metric alert resource.
     */
    public suspend fun getMetricAlert(argument: GetMetricAlertPlainArgs): GetMetricAlertResult =
        getMetricAlertResultToKotlin(getMetricAlertPlain(argument.toJava()).await())

    /**
     * @see [getMetricAlert].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param ruleName The name of the rule.
     * @return The metric alert resource.
     */
    public suspend fun getMetricAlert(resourceGroupName: String, ruleName: String):
        GetMetricAlertResult {
        val argument = GetMetricAlertPlainArgs(
            resourceGroupName = resourceGroupName,
            ruleName = ruleName,
        )
        return getMetricAlertResultToKotlin(getMetricAlertPlain(argument.toJava()).await())
    }

    /**
     * @see [getMetricAlert].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetMetricAlertPlainArgs].
     * @return The metric alert resource.
     */
    public suspend fun getMetricAlert(argument: suspend GetMetricAlertPlainArgsBuilder.() -> Unit):
        GetMetricAlertResult {
        val builder = GetMetricAlertPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMetricAlertResultToKotlin(getMetricAlertPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a single private workbook by its resourceName.
     * Azure REST API version: 2021-03-08.
     * @param argument null
     * @return An Application Insights private workbook definition.
     */
    public suspend fun getMyWorkbook(argument: GetMyWorkbookPlainArgs): GetMyWorkbookResult =
        getMyWorkbookResultToKotlin(getMyWorkbookPlain(argument.toJava()).await())

    /**
     * @see [getMyWorkbook].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @return An Application Insights private workbook definition.
     */
    public suspend fun getMyWorkbook(resourceGroupName: String, resourceName: String):
        GetMyWorkbookResult {
        val argument = GetMyWorkbookPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getMyWorkbookResultToKotlin(getMyWorkbookPlain(argument.toJava()).await())
    }

    /**
     * @see [getMyWorkbook].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetMyWorkbookPlainArgs].
     * @return An Application Insights private workbook definition.
     */
    public suspend fun getMyWorkbook(argument: suspend GetMyWorkbookPlainArgsBuilder.() -> Unit):
        GetMyWorkbookResult {
        val builder = GetMyWorkbookPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMyWorkbookResultToKotlin(getMyWorkbookPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a private endpoint connection.
     * Azure REST API version: 2021-07-01-preview.
     * Other available API versions: 2019-10-17-preview.
     * @param argument null
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param scopeName The name of the Azure Monitor PrivateLinkScope resource.
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        scopeName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            scopeName = scopeName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a Azure Monitor PrivateLinkScope.
     * Azure REST API version: 2021-07-01-preview.
     * Other available API versions: 2019-10-17-preview.
     * @param argument null
     * @return An Azure Monitor PrivateLinkScope definition.
     */
    public suspend fun getPrivateLinkScope(argument: GetPrivateLinkScopePlainArgs):
        GetPrivateLinkScopeResult =
        getPrivateLinkScopeResultToKotlin(getPrivateLinkScopePlain(argument.toJava()).await())

    /**
     * @see [getPrivateLinkScope].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param scopeName The name of the Azure Monitor PrivateLinkScope resource.
     * @return An Azure Monitor PrivateLinkScope definition.
     */
    public suspend fun getPrivateLinkScope(resourceGroupName: String, scopeName: String):
        GetPrivateLinkScopeResult {
        val argument = GetPrivateLinkScopePlainArgs(
            resourceGroupName = resourceGroupName,
            scopeName = scopeName,
        )
        return getPrivateLinkScopeResultToKotlin(getPrivateLinkScopePlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateLinkScope].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetPrivateLinkScopePlainArgs].
     * @return An Azure Monitor PrivateLinkScope definition.
     */
    public suspend
    fun getPrivateLinkScope(argument: suspend GetPrivateLinkScopePlainArgsBuilder.() -> Unit):
        GetPrivateLinkScopeResult {
        val builder = GetPrivateLinkScopePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateLinkScopeResultToKotlin(getPrivateLinkScopePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a scoped resource in a private link scope.
     * Azure REST API version: 2021-07-01-preview.
     * @param argument null
     * @return A private link scoped resource
     */
    public suspend fun getPrivateLinkScopedResource(argument: GetPrivateLinkScopedResourcePlainArgs):
        GetPrivateLinkScopedResourceResult =
        getPrivateLinkScopedResourceResultToKotlin(getPrivateLinkScopedResourcePlain(argument.toJava()).await())

    /**
     * @see [getPrivateLinkScopedResource].
     * @param name The name of the scoped resource object.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param scopeName The name of the Azure Monitor PrivateLinkScope resource.
     * @return A private link scoped resource
     */
    public suspend fun getPrivateLinkScopedResource(
        name: String,
        resourceGroupName: String,
        scopeName: String,
    ): GetPrivateLinkScopedResourceResult {
        val argument = GetPrivateLinkScopedResourcePlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            scopeName = scopeName,
        )
        return getPrivateLinkScopedResourceResultToKotlin(getPrivateLinkScopedResourcePlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateLinkScopedResource].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetPrivateLinkScopedResourcePlainArgs].
     * @return A private link scoped resource
     */
    public suspend
    fun getPrivateLinkScopedResource(argument: suspend GetPrivateLinkScopedResourcePlainArgsBuilder.() -> Unit):
        GetPrivateLinkScopedResourceResult {
        val builder = GetPrivateLinkScopedResourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateLinkScopedResourceResultToKotlin(getPrivateLinkScopedResourcePlain(builtArgument.toJava()).await())
    }

    /**
     * Get the ProactiveDetection configuration for this configuration id.
     * Azure REST API version: 2018-05-01-preview.
     * Other available API versions: 2015-05-01.
     * @param argument null
     * @return A ProactiveDetection configuration definition.
     */
    public suspend
    fun getProactiveDetectionConfiguration(argument: GetProactiveDetectionConfigurationPlainArgs):
        GetProactiveDetectionConfigurationResult =
        getProactiveDetectionConfigurationResultToKotlin(getProactiveDetectionConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getProactiveDetectionConfiguration].
     * @param configurationId The ProactiveDetection configuration ID. This is unique within a Application Insights component.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @return A ProactiveDetection configuration definition.
     */
    public suspend fun getProactiveDetectionConfiguration(
        configurationId: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetProactiveDetectionConfigurationResult {
        val argument = GetProactiveDetectionConfigurationPlainArgs(
            configurationId = configurationId,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getProactiveDetectionConfigurationResultToKotlin(getProactiveDetectionConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getProactiveDetectionConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetProactiveDetectionConfigurationPlainArgs].
     * @return A ProactiveDetection configuration definition.
     */
    public suspend
    fun getProactiveDetectionConfiguration(argument: suspend GetProactiveDetectionConfigurationPlainArgsBuilder.() -> Unit):
        GetProactiveDetectionConfigurationResult {
        val builder = GetProactiveDetectionConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProactiveDetectionConfigurationResultToKotlin(getProactiveDetectionConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve an scheduled query rule definition.
     * Azure REST API version: 2023-03-15-preview.
     * Other available API versions: 2018-04-16, 2020-05-01-preview, 2022-08-01-preview, 2023-12-01.
     * @param argument null
     * @return The scheduled query rule resource.
     */
    public suspend fun getScheduledQueryRule(argument: GetScheduledQueryRulePlainArgs):
        GetScheduledQueryRuleResult =
        getScheduledQueryRuleResultToKotlin(getScheduledQueryRulePlain(argument.toJava()).await())

    /**
     * @see [getScheduledQueryRule].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param ruleName The name of the rule.
     * @return The scheduled query rule resource.
     */
    public suspend fun getScheduledQueryRule(resourceGroupName: String, ruleName: String):
        GetScheduledQueryRuleResult {
        val argument = GetScheduledQueryRulePlainArgs(
            resourceGroupName = resourceGroupName,
            ruleName = ruleName,
        )
        return getScheduledQueryRuleResultToKotlin(getScheduledQueryRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getScheduledQueryRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetScheduledQueryRulePlainArgs].
     * @return The scheduled query rule resource.
     */
    public suspend
    fun getScheduledQueryRule(argument: suspend GetScheduledQueryRulePlainArgsBuilder.() -> Unit):
        GetScheduledQueryRuleResult {
        val builder = GetScheduledQueryRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScheduledQueryRuleResultToKotlin(getScheduledQueryRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the active subscription diagnostic settings for the specified resource.
     * Azure REST API version: 2021-05-01-preview.
     * Other available API versions: 2017-05-01-preview.
     * @param argument null
     * @return The subscription diagnostic setting resource.
     */
    public suspend
    fun getSubscriptionDiagnosticSetting(argument: GetSubscriptionDiagnosticSettingPlainArgs):
        GetSubscriptionDiagnosticSettingResult =
        getSubscriptionDiagnosticSettingResultToKotlin(getSubscriptionDiagnosticSettingPlain(argument.toJava()).await())

    /**
     * @see [getSubscriptionDiagnosticSetting].
     * @param name The name of the diagnostic setting.
     * @return The subscription diagnostic setting resource.
     */
    public suspend fun getSubscriptionDiagnosticSetting(name: String):
        GetSubscriptionDiagnosticSettingResult {
        val argument = GetSubscriptionDiagnosticSettingPlainArgs(
            name = name,
        )
        return getSubscriptionDiagnosticSettingResultToKotlin(getSubscriptionDiagnosticSettingPlain(argument.toJava()).await())
    }

    /**
     * @see [getSubscriptionDiagnosticSetting].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetSubscriptionDiagnosticSettingPlainArgs].
     * @return The subscription diagnostic setting resource.
     */
    public suspend
    fun getSubscriptionDiagnosticSetting(argument: suspend GetSubscriptionDiagnosticSettingPlainArgsBuilder.() -> Unit):
        GetSubscriptionDiagnosticSettingResult {
        val builder = GetSubscriptionDiagnosticSettingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSubscriptionDiagnosticSettingResultToKotlin(getSubscriptionDiagnosticSettingPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a tenant action group.
     * Azure REST API version: 2023-05-01-preview.
     * @param argument null
     * @return A tenant action group resource.
     */
    public suspend fun getTenantActionGroup(argument: GetTenantActionGroupPlainArgs):
        GetTenantActionGroupResult =
        getTenantActionGroupResultToKotlin(getTenantActionGroupPlain(argument.toJava()).await())

    /**
     * @see [getTenantActionGroup].
     * @param managementGroupId The management group id.
     * @param tenantActionGroupName The name of the action group.
     * @return A tenant action group resource.
     */
    public suspend fun getTenantActionGroup(managementGroupId: String, tenantActionGroupName: String):
        GetTenantActionGroupResult {
        val argument = GetTenantActionGroupPlainArgs(
            managementGroupId = managementGroupId,
            tenantActionGroupName = tenantActionGroupName,
        )
        return getTenantActionGroupResultToKotlin(getTenantActionGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getTenantActionGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetTenantActionGroupPlainArgs].
     * @return A tenant action group resource.
     */
    public suspend
    fun getTenantActionGroup(argument: suspend GetTenantActionGroupPlainArgsBuilder.() -> Unit):
        GetTenantActionGroupResult {
        val builder = GetTenantActionGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTenantActionGroupResultToKotlin(getTenantActionGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a file test result for the matching test
     * Azure REST API version: 2020-02-10-preview.
     * @param argument null
     * @return Test result.
     */
    public suspend fun getTestResultFile(argument: GetTestResultFilePlainArgs):
        GetTestResultFileResult =
        getTestResultFileResultToKotlin(getTestResultFilePlain(argument.toJava()).await())

    /**
     * @see [getTestResultFile].
     * @param continuationToken The continuation token.
     * @param downloadAs The format to use when returning the webtest result.
     * @param geoLocationId The location ID where the webtest was physically run.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param testSuccessfulCriteria The success state criteria for the webtest result.
     * @param timeStamp The posix (epoch) time stamp for the webtest result.
     * @param webTestName The name of the Application Insights webtest resource.
     * @return Test result.
     */
    public suspend fun getTestResultFile(
        continuationToken: String? = null,
        downloadAs: String,
        geoLocationId: String,
        resourceGroupName: String,
        testSuccessfulCriteria: Boolean? = null,
        timeStamp: Int,
        webTestName: String,
    ): GetTestResultFileResult {
        val argument = GetTestResultFilePlainArgs(
            continuationToken = continuationToken,
            downloadAs = downloadAs,
            geoLocationId = geoLocationId,
            resourceGroupName = resourceGroupName,
            testSuccessfulCriteria = testSuccessfulCriteria,
            timeStamp = timeStamp,
            webTestName = webTestName,
        )
        return getTestResultFileResultToKotlin(getTestResultFilePlain(argument.toJava()).await())
    }

    /**
     * @see [getTestResultFile].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetTestResultFilePlainArgs].
     * @return Test result.
     */
    public suspend
    fun getTestResultFile(argument: suspend GetTestResultFilePlainArgsBuilder.() -> Unit):
        GetTestResultFileResult {
        val builder = GetTestResultFilePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTestResultFileResultToKotlin(getTestResultFilePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a specific Application Insights web test definition.
     * Azure REST API version: 2022-06-15.
     * Other available API versions: 2020-10-05-preview.
     * @param argument null
     * @return An Application Insights WebTest definition.
     */
    public suspend fun getWebTest(argument: GetWebTestPlainArgs): GetWebTestResult =
        getWebTestResultToKotlin(getWebTestPlain(argument.toJava()).await())

    /**
     * @see [getWebTest].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param webTestName The name of the Application Insights WebTest resource.
     * @return An Application Insights WebTest definition.
     */
    public suspend fun getWebTest(resourceGroupName: String, webTestName: String): GetWebTestResult {
        val argument = GetWebTestPlainArgs(
            resourceGroupName = resourceGroupName,
            webTestName = webTestName,
        )
        return getWebTestResultToKotlin(getWebTestPlain(argument.toJava()).await())
    }

    /**
     * @see [getWebTest].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetWebTestPlainArgs].
     * @return An Application Insights WebTest definition.
     */
    public suspend fun getWebTest(argument: suspend GetWebTestPlainArgsBuilder.() -> Unit):
        GetWebTestResult {
        val builder = GetWebTestPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWebTestResultToKotlin(getWebTestPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a single workbook by its resourceName.
     * Azure REST API version: 2022-04-01.
     * Other available API versions: 2015-05-01, 2021-03-08, 2021-08-01, 2023-06-01.
     * @param argument null
     * @return A workbook definition.
     */
    public suspend fun getWorkbook(argument: GetWorkbookPlainArgs): GetWorkbookResult =
        getWorkbookResultToKotlin(getWorkbookPlain(argument.toJava()).await())

    /**
     * @see [getWorkbook].
     * @param canFetchContent Flag indicating whether or not to return the full content for each applicable workbook. If false, only return summary content for workbooks.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the resource.
     * @return A workbook definition.
     */
    public suspend fun getWorkbook(
        canFetchContent: Boolean? = null,
        resourceGroupName: String,
        resourceName: String,
    ): GetWorkbookResult {
        val argument = GetWorkbookPlainArgs(
            canFetchContent = canFetchContent,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getWorkbookResultToKotlin(getWorkbookPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkbook].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetWorkbookPlainArgs].
     * @return A workbook definition.
     */
    public suspend fun getWorkbook(argument: suspend GetWorkbookPlainArgsBuilder.() -> Unit):
        GetWorkbookResult {
        val builder = GetWorkbookPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkbookResultToKotlin(getWorkbookPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a single workbook template by its resourceName.
     * Azure REST API version: 2020-11-20.
     * @param argument null
     * @return An Application Insights workbook template definition.
     */
    public suspend fun getWorkbookTemplate(argument: GetWorkbookTemplatePlainArgs):
        GetWorkbookTemplateResult =
        getWorkbookTemplateResultToKotlin(getWorkbookTemplatePlain(argument.toJava()).await())

    /**
     * @see [getWorkbookTemplate].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @return An Application Insights workbook template definition.
     */
    public suspend fun getWorkbookTemplate(resourceGroupName: String, resourceName: String):
        GetWorkbookTemplateResult {
        val argument = GetWorkbookTemplatePlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getWorkbookTemplateResultToKotlin(getWorkbookTemplatePlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkbookTemplate].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;GetWorkbookTemplatePlainArgs].
     * @return An Application Insights workbook template definition.
     */
    public suspend
    fun getWorkbookTemplate(argument: suspend GetWorkbookTemplatePlainArgsBuilder.() -> Unit):
        GetWorkbookTemplateResult {
        val builder = GetWorkbookTemplatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkbookTemplateResultToKotlin(getWorkbookTemplatePlain(builtArgument.toJava()).await())
    }

    /**
     * Lists the diagnostic settings categories for the specified resource.
     * Azure REST API version: 2021-05-01-preview.
     * Other available API versions: 2017-05-01-preview.
     * @param argument null
     * @return Represents a collection of diagnostic setting category resources.
     */
    public suspend
    fun listDiagnosticSettingsCategory(argument: ListDiagnosticSettingsCategoryPlainArgs):
        ListDiagnosticSettingsCategoryResult =
        listDiagnosticSettingsCategoryResultToKotlin(listDiagnosticSettingsCategoryPlain(argument.toJava()).await())

    /**
     * @see [listDiagnosticSettingsCategory].
     * @param resourceUri The identifier of the resource.
     * @return Represents a collection of diagnostic setting category resources.
     */
    public suspend fun listDiagnosticSettingsCategory(resourceUri: String):
        ListDiagnosticSettingsCategoryResult {
        val argument = ListDiagnosticSettingsCategoryPlainArgs(
            resourceUri = resourceUri,
        )
        return listDiagnosticSettingsCategoryResultToKotlin(listDiagnosticSettingsCategoryPlain(argument.toJava()).await())
    }

    /**
     * @see [listDiagnosticSettingsCategory].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;insights&#46;kotlin&#46;inputs&#46;ListDiagnosticSettingsCategoryPlainArgs].
     * @return Represents a collection of diagnostic setting category resources.
     */
    public suspend
    fun listDiagnosticSettingsCategory(argument: suspend ListDiagnosticSettingsCategoryPlainArgsBuilder.() -> Unit):
        ListDiagnosticSettingsCategoryResult {
        val builder = ListDiagnosticSettingsCategoryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listDiagnosticSettingsCategoryResultToKotlin(listDiagnosticSettingsCategoryPlain(builtArgument.toJava()).await())
    }

    /**
     * list date to migrate to new pricing model.
     * Azure REST API version: 2017-10-01.
     * @param argument null
     * @return Subscription migrate date information properties
     */
    public suspend fun listEASubscriptionListMigrationDatePost():
        ListEASubscriptionListMigrationDatePostResult =
        listEASubscriptionListMigrationDatePostResultToKotlin(listEASubscriptionListMigrationDatePostPlain().await())
}
