@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.kotlin.outputs.MyWorkbookManagedIdentityResponse
import com.pulumi.azurenative.insights.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.insights.kotlin.outputs.MyWorkbookManagedIdentityResponse.Companion.toKotlin as myWorkbookManagedIdentityResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [MyWorkbook].
 */
@PulumiTagMarker
public class MyWorkbookResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MyWorkbookArgs = MyWorkbookArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MyWorkbookArgsBuilder.() -> Unit) {
        val builder = MyWorkbookArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MyWorkbook {
        val builtJavaResource = com.pulumi.azurenative.insights.MyWorkbook(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MyWorkbook(builtJavaResource)
    }
}

/**
 * An Application Insights private workbook definition.
 * Azure REST API version: 2021-03-08. Prior API version in Azure Native 1.x: 2020-10-20.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:MyWorkbook deadb33f-8bee-4d3b-a059-9be8dac93960 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/myWorkbooks/{resourceName}
 * ```
 */
public class MyWorkbook internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.MyWorkbook,
) : KotlinCustomResource(javaResource, MyWorkbookMapper) {
    /**
     * Workbook category, as defined by the user at creation time.
     */
    public val category: Output<String>
        get() = javaResource.category().applyValue({ args0 -> args0 })

    /**
     * The user-defined name of the private workbook.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Resource etag
     */
    public val etag: Output<Map<String, String>>?
        get() = javaResource.etag().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Identity used for BYOS
     */
    public val identity: Output<MyWorkbookManagedIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    myWorkbookManagedIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The kind of workbook. Choices are user and shared.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure resource name
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Configuration of this particular private workbook. Configuration data is a string containing valid JSON
     */
    public val serializedData: Output<String>
        get() = javaResource.serializedData().applyValue({ args0 -> args0 })

    /**
     * Optional resourceId for a source resource.
     */
    public val sourceId: Output<String>?
        get() = javaResource.sourceId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * BYOS Storage Account URI
     */
    public val storageUri: Output<String>?
        get() = javaResource.storageUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Date and time in UTC of the last modification that was made to this private workbook definition.
     */
    public val timeModified: Output<String>
        get() = javaResource.timeModified().applyValue({ args0 -> args0 })

    /**
     * Azure resource type
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Unique user id of the specific user that owns this private workbook.
     */
    public val userId: Output<String>
        get() = javaResource.userId().applyValue({ args0 -> args0 })

    /**
     * This instance's version of the data model. This can change as new features are added that can be marked private workbook.
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object MyWorkbookMapper : ResourceMapper<MyWorkbook> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.MyWorkbook::class == javaResource::class

    override fun map(javaResource: Resource): MyWorkbook = MyWorkbook(
        javaResource as
            com.pulumi.azurenative.insights.MyWorkbook,
    )
}

/**
 * @see [MyWorkbook].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MyWorkbook].
 */
public suspend fun myWorkbook(name: String, block: suspend MyWorkbookResourceBuilder.() -> Unit):
    MyWorkbook {
    val builder = MyWorkbookResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MyWorkbook].
 * @param name The _unique_ name of the resulting resource.
 */
public fun myWorkbook(name: String): MyWorkbook {
    val builder = MyWorkbookResourceBuilder()
    builder.name(name)
    return builder.build()
}
