@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.PrivateLinkScopeArgs.builder
import com.pulumi.azurenative.insights.kotlin.inputs.AccessModeSettingsArgs
import com.pulumi.azurenative.insights.kotlin.inputs.AccessModeSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Azure Monitor PrivateLinkScope definition.
 * Azure REST API version: 2021-07-01-preview. Prior API version in Azure Native 1.x: 2019-10-17-preview.
 * Other available API versions: 2019-10-17-preview.
 * ## Example Usage
 * ### PrivateLinkScopeCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkScope = new AzureNative.Insights.PrivateLinkScope("privateLinkScope", new()
 *     {
 *         AccessModeSettings = new AzureNative.Insights.Inputs.AccessModeSettingsArgs
 *         {
 *             Exclusions = new() { },
 *             IngestionAccessMode = AzureNative.Insights.AccessMode.Open,
 *             QueryAccessMode = AzureNative.Insights.AccessMode.Open,
 *         },
 *         Location = "Global",
 *         ResourceGroupName = "my-resource-group",
 *         ScopeName = "my-privatelinkscope",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewPrivateLinkScope(ctx, "privateLinkScope", &insights.PrivateLinkScopeArgs{
 * 			AccessModeSettings: &insights.AccessModeSettingsArgs{
 * 				Exclusions:          insights.AccessModeSettingsExclusionArray{},
 * 				IngestionAccessMode: pulumi.String(insights.AccessModeOpen),
 * 				QueryAccessMode:     pulumi.String(insights.AccessModeOpen),
 * 			},
 * 			Location:          pulumi.String("Global"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			ScopeName:         pulumi.String("my-privatelinkscope"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.PrivateLinkScope;
 * import com.pulumi.azurenative.insights.PrivateLinkScopeArgs;
 * import com.pulumi.azurenative.insights.inputs.AccessModeSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkScope = new PrivateLinkScope("privateLinkScope", PrivateLinkScopeArgs.builder()
 *             .accessModeSettings(AccessModeSettingsArgs.builder()
 *                 .exclusions()
 *                 .ingestionAccessMode("Open")
 *                 .queryAccessMode("Open")
 *                 .build())
 *             .location("Global")
 *             .resourceGroupName("my-resource-group")
 *             .scopeName("my-privatelinkscope")
 *             .build());
 *     }
 * }
 * ```
 * ### PrivateLinkScopeUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkScope = new AzureNative.Insights.PrivateLinkScope("privateLinkScope", new()
 *     {
 *         AccessModeSettings = new AzureNative.Insights.Inputs.AccessModeSettingsArgs
 *         {
 *             Exclusions = new() { },
 *             IngestionAccessMode = AzureNative.Insights.AccessMode.Open,
 *             QueryAccessMode = AzureNative.Insights.AccessMode.Open,
 *         },
 *         Location = "Global",
 *         ResourceGroupName = "my-resource-group",
 *         ScopeName = "my-privatelinkscope",
 *         Tags =
 *         {
 *             { "Tag1", "Value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewPrivateLinkScope(ctx, "privateLinkScope", &insights.PrivateLinkScopeArgs{
 * 			AccessModeSettings: &insights.AccessModeSettingsArgs{
 * 				Exclusions:          insights.AccessModeSettingsExclusionArray{},
 * 				IngestionAccessMode: pulumi.String(insights.AccessModeOpen),
 * 				QueryAccessMode:     pulumi.String(insights.AccessModeOpen),
 * 			},
 * 			Location:          pulumi.String("Global"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			ScopeName:         pulumi.String("my-privatelinkscope"),
 * 			Tags: pulumi.StringMap{
 * 				"Tag1": pulumi.String("Value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.PrivateLinkScope;
 * import com.pulumi.azurenative.insights.PrivateLinkScopeArgs;
 * import com.pulumi.azurenative.insights.inputs.AccessModeSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkScope = new PrivateLinkScope("privateLinkScope", PrivateLinkScopeArgs.builder()
 *             .accessModeSettings(AccessModeSettingsArgs.builder()
 *                 .exclusions()
 *                 .ingestionAccessMode("Open")
 *                 .queryAccessMode("Open")
 *                 .build())
 *             .location("Global")
 *             .resourceGroupName("my-resource-group")
 *             .scopeName("my-privatelinkscope")
 *             .tags(Map.of("Tag1", "Value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:PrivateLinkScope my-privatelinkscope /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/privateLinkScopes/{scopeName}
 * ```
 * @property accessModeSettings Access mode settings
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scopeName The name of the Azure Monitor PrivateLinkScope resource.
 * @property tags Resource tags.
 */
public data class PrivateLinkScopeArgs(
    public val accessModeSettings: Output<AccessModeSettingsArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scopeName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.PrivateLinkScopeArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.PrivateLinkScopeArgs =
        com.pulumi.azurenative.insights.PrivateLinkScopeArgs.builder()
            .accessModeSettings(
                accessModeSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scopeName(scopeName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PrivateLinkScopeArgs].
 */
@PulumiTagMarker
public class PrivateLinkScopeArgsBuilder internal constructor() {
    private var accessModeSettings: Output<AccessModeSettingsArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scopeName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Access mode settings
     */
    @JvmName("pmsnlekecrcnsmcm")
    public suspend fun accessModeSettings(`value`: Output<AccessModeSettingsArgs>) {
        this.accessModeSettings = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("nlkqxcfbpqxmtoij")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fboxlfinltsgtisp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Azure Monitor PrivateLinkScope resource.
     */
    @JvmName("hswneundxhemfwor")
    public suspend fun scopeName(`value`: Output<String>) {
        this.scopeName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rsrqvplutqqwmbmm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Access mode settings
     */
    @JvmName("xksgummcvrfhlumm")
    public suspend fun accessModeSettings(`value`: AccessModeSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessModeSettings = mapped
    }

    /**
     * @param argument Access mode settings
     */
    @JvmName("wfewgwamuhmkqsgh")
    public suspend
    fun accessModeSettings(argument: suspend AccessModeSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AccessModeSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accessModeSettings = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("hskjskbemqigccwi")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("elgrbxnxeavdqjpp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Azure Monitor PrivateLinkScope resource.
     */
    @JvmName("tkfbodtbnusmpisy")
    public suspend fun scopeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopeName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vxdgdqhcydrkcfyr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("kyyrxbpecasfxcof")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PrivateLinkScopeArgs = PrivateLinkScopeArgs(
        accessModeSettings = accessModeSettings,
        location = location,
        resourceGroupName = resourceGroupName,
        scopeName = scopeName,
        tags = tags,
    )
}
