@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.PrivateLinkScopedResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A private link scoped resource
 * Azure REST API version: 2021-07-01-preview. Prior API version in Azure Native 1.x: 2019-10-17-preview.
 * ## Example Usage
 * ### Update a scoped resource in a private link scope.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkScopedResource = new AzureNative.Insights.PrivateLinkScopedResource("privateLinkScopedResource", new()
 *     {
 *         LinkedResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/MyResourceGroup/providers/Microsoft.Insights/components/my-component",
 *         Name = "scoped-resource-name",
 *         ResourceGroupName = "MyResourceGroup",
 *         ScopeName = "MyPrivateLinkScope",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewPrivateLinkScopedResource(ctx, "privateLinkScopedResource", &insights.PrivateLinkScopedResourceArgs{
 * 			LinkedResourceId:  pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/MyResourceGroup/providers/Microsoft.Insights/components/my-component"),
 * 			Name:              pulumi.String("scoped-resource-name"),
 * 			ResourceGroupName: pulumi.String("MyResourceGroup"),
 * 			ScopeName:         pulumi.String("MyPrivateLinkScope"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.PrivateLinkScopedResource;
 * import com.pulumi.azurenative.insights.PrivateLinkScopedResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkScopedResource = new PrivateLinkScopedResource("privateLinkScopedResource", PrivateLinkScopedResourceArgs.builder()
 *             .linkedResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/MyResourceGroup/providers/Microsoft.Insights/components/my-component")
 *             .name("scoped-resource-name")
 *             .resourceGroupName("MyResourceGroup")
 *             .scopeName("MyPrivateLinkScope")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:PrivateLinkScopedResource scoped-resource-name /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/privateLinkScopes/{scopeName}/scopedResources/{name}
 * ```
 * @property linkedResourceId The resource id of the scoped Azure monitor resource.
 * @property name The name of the scoped resource object.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scopeName The name of the Azure Monitor PrivateLinkScope resource.
 */
public data class PrivateLinkScopedResourceArgs(
    public val linkedResourceId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scopeName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.PrivateLinkScopedResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.PrivateLinkScopedResourceArgs =
        com.pulumi.azurenative.insights.PrivateLinkScopedResourceArgs.builder()
            .linkedResourceId(linkedResourceId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scopeName(scopeName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateLinkScopedResourceArgs].
 */
@PulumiTagMarker
public class PrivateLinkScopedResourceArgsBuilder internal constructor() {
    private var linkedResourceId: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scopeName: Output<String>? = null

    /**
     * @param value The resource id of the scoped Azure monitor resource.
     */
    @JvmName("kusdsjwlgspstywq")
    public suspend fun linkedResourceId(`value`: Output<String>) {
        this.linkedResourceId = value
    }

    /**
     * @param value The name of the scoped resource object.
     */
    @JvmName("ltvgnaflyelwuwnp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ffsyrcxjowxrkkfm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Azure Monitor PrivateLinkScope resource.
     */
    @JvmName("ccehfkpvwokupioj")
    public suspend fun scopeName(`value`: Output<String>) {
        this.scopeName = value
    }

    /**
     * @param value The resource id of the scoped Azure monitor resource.
     */
    @JvmName("yxfbpxmcemrhebeg")
    public suspend fun linkedResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedResourceId = mapped
    }

    /**
     * @param value The name of the scoped resource object.
     */
    @JvmName("hlnuoympwmvjphwy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rprrgalneblwtgrs")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Azure Monitor PrivateLinkScope resource.
     */
    @JvmName("sxrrbmmlvwffwqce")
    public suspend fun scopeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopeName = mapped
    }

    internal fun build(): PrivateLinkScopedResourceArgs = PrivateLinkScopedResourceArgs(
        linkedResourceId = linkedResourceId,
        name = name,
        resourceGroupName = resourceGroupName,
        scopeName = scopeName,
    )
}
