@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.kotlin.outputs.ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesResponseRuleDefinitions
import com.pulumi.azurenative.insights.kotlin.outputs.ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesResponseRuleDefinitions.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ProactiveDetectionConfiguration].
 */
@PulumiTagMarker
public class ProactiveDetectionConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProactiveDetectionConfigurationArgs = ProactiveDetectionConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProactiveDetectionConfigurationArgsBuilder.() -> Unit) {
        val builder = ProactiveDetectionConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProactiveDetectionConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.insights.ProactiveDetectionConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ProactiveDetectionConfiguration(builtJavaResource)
    }
}

/**
 * A ProactiveDetection configuration definition.
 * Azure REST API version: 2018-05-01-preview. Prior API version in Azure Native 1.x: 2015-05-01.
 * Other available API versions: 2015-05-01.
 * ## Example Usage
 * ### ProactiveDetectionConfigurationUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var proactiveDetectionConfiguration = new AzureNative.Insights.ProactiveDetectionConfiguration("proactiveDetectionConfiguration", new()
 *     {
 *         ConfigurationId = "slowpageloadtime",
 *         CustomEmails = new[]
 *         {
 *             "foo@microsoft.com",
 *             "foo2@microsoft.com",
 *         },
 *         Enabled = true,
 *         Location = "South Central US",
 *         Name = "slowpageloadtime",
 *         ResourceGroupName = "my-resource-group",
 *         ResourceName = "my-component",
 *         RuleDefinitions = new AzureNative.Insights.Inputs.ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitionsArgs
 *         {
 *             Description = "Smart Detection rules notify you of performance anomaly issues.",
 *             DisplayName = "Slow page load time",
 *             HelpUrl = "https://docs.microsoft.com/en-us/azure/application-insights/app-insights-proactive-performance-diagnostics",
 *             IsEnabledByDefault = true,
 *             IsHidden = false,
 *             IsInPreview = false,
 *             Name = "slowpageloadtime",
 *             SupportsEmailNotifications = true,
 *         },
 *         SendEmailsToSubscriptionOwners = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewProactiveDetectionConfiguration(ctx, "proactiveDetectionConfiguration", &insights.ProactiveDetectionConfigurationArgs{
 * 			ConfigurationId: pulumi.String("slowpageloadtime"),
 * 			CustomEmails: pulumi.StringArray{
 * 				pulumi.String("foo@microsoft.com"),
 * 				pulumi.String("foo2@microsoft.com"),
 * 			},
 * 			Enabled:           pulumi.Bool(true),
 * 			Location:          pulumi.String("South Central US"),
 * 			Name:              pulumi.String("slowpageloadtime"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			ResourceName:      pulumi.String("my-component"),
 * 			RuleDefinitions: &insights.ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitionsArgs{
 * 				Description:                pulumi.String("Smart Detection rules notify you of performance anomaly issues."),
 * 				DisplayName:                pulumi.String("Slow page load time"),
 * 				HelpUrl:                    pulumi.String("https://docs.microsoft.com/en-us/azure/application-insights/app-insights-proactive-performance-diagnostics"),
 * 				IsEnabledByDefault:         pulumi.Bool(true),
 * 				IsHidden:                   pulumi.Bool(false),
 * 				IsInPreview:                pulumi.Bool(false),
 * 				Name:                       pulumi.String("slowpageloadtime"),
 * 				SupportsEmailNotifications: pulumi.Bool(true),
 * 			},
 * 			SendEmailsToSubscriptionOwners: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.ProactiveDetectionConfiguration;
 * import com.pulumi.azurenative.insights.ProactiveDetectionConfigurationArgs;
 * import com.pulumi.azurenative.insights.inputs.ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var proactiveDetectionConfiguration = new ProactiveDetectionConfiguration("proactiveDetectionConfiguration", ProactiveDetectionConfigurationArgs.builder()
 *             .configurationId("slowpageloadtime")
 *             .customEmails(
 *                 "foo@microsoft.com",
 *                 "foo2@microsoft.com")
 *             .enabled(true)
 *             .location("South Central US")
 *             .name("slowpageloadtime")
 *             .resourceGroupName("my-resource-group")
 *             .resourceName("my-component")
 *             .ruleDefinitions(ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesRuleDefinitionsArgs.builder()
 *                 .description("Smart Detection rules notify you of performance anomaly issues.")
 *                 .displayName("Slow page load time")
 *                 .helpUrl("https://docs.microsoft.com/en-us/azure/application-insights/app-insights-proactive-performance-diagnostics")
 *                 .isEnabledByDefault(true)
 *                 .isHidden(false)
 *                 .isInPreview(false)
 *                 .name("slowpageloadtime")
 *                 .supportsEmailNotifications(true)
 *                 .build())
 *             .sendEmailsToSubscriptionOwners(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:ProactiveDetectionConfiguration slowpageloadtime /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/ProactiveDetectionConfigs/{ConfigurationId}
 * ```
 */
public class ProactiveDetectionConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.ProactiveDetectionConfiguration,
) : KotlinCustomResource(javaResource, ProactiveDetectionConfigurationMapper) {
    /**
     * Custom email addresses for this rule notifications
     */
    public val customEmails: Output<List<String>>?
        get() = javaResource.customEmails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * A flag that indicates whether this rule is enabled by the user
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The last time this rule was updated
     */
    public val lastUpdatedTime: Output<String>
        get() = javaResource.lastUpdatedTime().applyValue({ args0 -> args0 })

    /**
     * Resource location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The rule name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Static definitions of the ProactiveDetection configuration rule (same values for all components).
     */
    public val ruleDefinitions:
        Output<ApplicationInsightsComponentProactiveDetectionConfigurationPropertiesResponseRuleDefinitions>?
        get() = javaResource.ruleDefinitions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A flag that indicated whether notifications on this rule should be sent to subscription owners
     */
    public val sendEmailsToSubscriptionOwners: Output<Boolean>?
        get() = javaResource.sendEmailsToSubscriptionOwners().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ProactiveDetectionConfigurationMapper :
    ResourceMapper<ProactiveDetectionConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.ProactiveDetectionConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): ProactiveDetectionConfiguration =
        ProactiveDetectionConfiguration(
            javaResource as
                com.pulumi.azurenative.insights.ProactiveDetectionConfiguration,
        )
}

/**
 * @see [ProactiveDetectionConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProactiveDetectionConfiguration].
 */
public suspend fun proactiveDetectionConfiguration(
    name: String,
    block: suspend ProactiveDetectionConfigurationResourceBuilder.() -> Unit,
):
    ProactiveDetectionConfiguration {
    val builder = ProactiveDetectionConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProactiveDetectionConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun proactiveDetectionConfiguration(name: String): ProactiveDetectionConfiguration {
    val builder = ProactiveDetectionConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
