@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.kotlin.outputs.AzureAppPushReceiverResponse
import com.pulumi.azurenative.insights.kotlin.outputs.EmailReceiverResponse
import com.pulumi.azurenative.insights.kotlin.outputs.SmsReceiverResponse
import com.pulumi.azurenative.insights.kotlin.outputs.VoiceReceiverResponse
import com.pulumi.azurenative.insights.kotlin.outputs.WebhookReceiverResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.insights.kotlin.outputs.AzureAppPushReceiverResponse.Companion.toKotlin as azureAppPushReceiverResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.EmailReceiverResponse.Companion.toKotlin as emailReceiverResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.SmsReceiverResponse.Companion.toKotlin as smsReceiverResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.VoiceReceiverResponse.Companion.toKotlin as voiceReceiverResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.WebhookReceiverResponse.Companion.toKotlin as webhookReceiverResponseToKotlin

/**
 * Builder for [TenantActionGroup].
 */
@PulumiTagMarker
public class TenantActionGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TenantActionGroupArgs = TenantActionGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TenantActionGroupArgsBuilder.() -> Unit) {
        val builder = TenantActionGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TenantActionGroup {
        val builtJavaResource =
            com.pulumi.azurenative.insights.TenantActionGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TenantActionGroup(builtJavaResource)
    }
}

/**
 * A tenant action group resource.
 * Azure REST API version: 2023-05-01-preview.
 * ## Example Usage
 * ### Create or update a tenant action group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tenantActionGroup = new AzureNative.Insights.TenantActionGroup("tenantActionGroup", new()
 *     {
 *         AzureAppPushReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.AzureAppPushReceiverArgs
 *             {
 *                 EmailAddress = "johndoe@email.com",
 *                 Name = "Sample azureAppPush",
 *             },
 *         },
 *         EmailReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.EmailReceiverArgs
 *             {
 *                 EmailAddress = "johndoe@email.com",
 *                 Name = "John Doe's email",
 *                 UseCommonAlertSchema = false,
 *             },
 *             new AzureNative.Insights.Inputs.EmailReceiverArgs
 *             {
 *                 EmailAddress = "janesmith@email.com",
 *                 Name = "Jane Smith's email",
 *                 UseCommonAlertSchema = true,
 *             },
 *         },
 *         Enabled = true,
 *         GroupShortName = "sample",
 *         Location = "Global",
 *         ManagementGroupId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *         SmsReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.SmsReceiverArgs
 *             {
 *                 CountryCode = "1",
 *                 Name = "John Doe's mobile",
 *                 PhoneNumber = "2062022299",
 *             },
 *             new AzureNative.Insights.Inputs.SmsReceiverArgs
 *             {
 *                 CountryCode = "1",
 *                 Name = "Jane Smith's mobile",
 *                 PhoneNumber = "0987654321",
 *             },
 *         },
 *         Tags = null,
 *         TenantActionGroupName = "testTenantActionGroup",
 *         VoiceReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.VoiceReceiverArgs
 *             {
 *                 CountryCode = "1",
 *                 Name = "Sample voice",
 *                 PhoneNumber = "2062022299",
 *             },
 *         },
 *         WebhookReceivers = new[]
 *         {
 *             new AzureNative.Insights.Inputs.WebhookReceiverArgs
 *             {
 *                 Name = "Sample webhook 1",
 *                 ServiceUri = "http://www.example.com/webhook1",
 *                 UseCommonAlertSchema = true,
 *             },
 *             new AzureNative.Insights.Inputs.WebhookReceiverArgs
 *             {
 *                 IdentifierUri = "http://someidentifier/d7811ba3-7996-4a93-99b6-6b2f3f355f8a",
 *                 Name = "Sample webhook 2",
 *                 ObjectId = "d3bb868c-fe44-452c-aa26-769a6538c808",
 *                 ServiceUri = "http://www.example.com/webhook2",
 *                 TenantId = "68a4459a-ccb8-493c-b9da-dd30457d1b84",
 *                 UseAadAuth = true,
 *                 UseCommonAlertSchema = true,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewTenantActionGroup(ctx, "tenantActionGroup", &insights.TenantActionGroupArgs{
 * 			AzureAppPushReceivers: insights.AzureAppPushReceiverArray{
 * 				&insights.AzureAppPushReceiverArgs{
 * 					EmailAddress: pulumi.String("johndoe@email.com"),
 * 					Name:         pulumi.String("Sample azureAppPush"),
 * 				},
 * 			},
 * 			EmailReceivers: insights.EmailReceiverArray{
 * 				&insights.EmailReceiverArgs{
 * 					EmailAddress:         pulumi.String("johndoe@email.com"),
 * 					Name:                 pulumi.String("John Doe's email"),
 * 					UseCommonAlertSchema: pulumi.Bool(false),
 * 				},
 * 				&insights.EmailReceiverArgs{
 * 					EmailAddress:         pulumi.String("janesmith@email.com"),
 * 					Name:                 pulumi.String("Jane Smith's email"),
 * 					UseCommonAlertSchema: pulumi.Bool(true),
 * 				},
 * 			},
 * 			Enabled:           pulumi.Bool(true),
 * 			GroupShortName:    pulumi.String("sample"),
 * 			Location:          pulumi.String("Global"),
 * 			ManagementGroupId: pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 			SmsReceivers: insights.SmsReceiverArray{
 * 				&insights.SmsReceiverArgs{
 * 					CountryCode: pulumi.String("1"),
 * 					Name:        pulumi.String("John Doe's mobile"),
 * 					PhoneNumber: pulumi.String("2062022299"),
 * 				},
 * 				&insights.SmsReceiverArgs{
 * 					CountryCode: pulumi.String("1"),
 * 					Name:        pulumi.String("Jane Smith's mobile"),
 * 					PhoneNumber: pulumi.String("0987654321"),
 * 				},
 * 			},
 * 			Tags:                  nil,
 * 			TenantActionGroupName: pulumi.String("testTenantActionGroup"),
 * 			VoiceReceivers: insights.VoiceReceiverArray{
 * 				&insights.VoiceReceiverArgs{
 * 					CountryCode: pulumi.String("1"),
 * 					Name:        pulumi.String("Sample voice"),
 * 					PhoneNumber: pulumi.String("2062022299"),
 * 				},
 * 			},
 * 			WebhookReceivers: insights.WebhookReceiverArray{
 * 				&insights.WebhookReceiverArgs{
 * 					Name:                 pulumi.String("Sample webhook 1"),
 * 					ServiceUri:           pulumi.String("http://www.example.com/webhook1"),
 * 					UseCommonAlertSchema: pulumi.Bool(true),
 * 				},
 * 				&insights.WebhookReceiverArgs{
 * 					IdentifierUri:        pulumi.String("http://someidentifier/d7811ba3-7996-4a93-99b6-6b2f3f355f8a"),
 * 					Name:                 pulumi.String("Sample webhook 2"),
 * 					ObjectId:             pulumi.String("d3bb868c-fe44-452c-aa26-769a6538c808"),
 * 					ServiceUri:           pulumi.String("http://www.example.com/webhook2"),
 * 					TenantId:             pulumi.String("68a4459a-ccb8-493c-b9da-dd30457d1b84"),
 * 					UseAadAuth:           pulumi.Bool(true),
 * 					UseCommonAlertSchema: pulumi.Bool(true),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.TenantActionGroup;
 * import com.pulumi.azurenative.insights.TenantActionGroupArgs;
 * import com.pulumi.azurenative.insights.inputs.AzureAppPushReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.EmailReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.SmsReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.VoiceReceiverArgs;
 * import com.pulumi.azurenative.insights.inputs.WebhookReceiverArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tenantActionGroup = new TenantActionGroup("tenantActionGroup", TenantActionGroupArgs.builder()
 *             .azureAppPushReceivers(AzureAppPushReceiverArgs.builder()
 *                 .emailAddress("johndoe@email.com")
 *                 .name("Sample azureAppPush")
 *                 .build())
 *             .emailReceivers(
 *                 EmailReceiverArgs.builder()
 *                     .emailAddress("johndoe@email.com")
 *                     .name("John Doe's email")
 *                     .useCommonAlertSchema(false)
 *                     .build(),
 *                 EmailReceiverArgs.builder()
 *                     .emailAddress("janesmith@email.com")
 *                     .name("Jane Smith's email")
 *                     .useCommonAlertSchema(true)
 *                     .build())
 *             .enabled(true)
 *             .groupShortName("sample")
 *             .location("Global")
 *             .managementGroupId("72f988bf-86f1-41af-91ab-2d7cd011db47")
 *             .smsReceivers(
 *                 SmsReceiverArgs.builder()
 *                     .countryCode("1")
 *                     .name("John Doe's mobile")
 *                     .phoneNumber("2062022299")
 *                     .build(),
 *                 SmsReceiverArgs.builder()
 *                     .countryCode("1")
 *                     .name("Jane Smith's mobile")
 *                     .phoneNumber("0987654321")
 *                     .build())
 *             .tags()
 *             .tenantActionGroupName("testTenantActionGroup")
 *             .voiceReceivers(VoiceReceiverArgs.builder()
 *                 .countryCode("1")
 *                 .name("Sample voice")
 *                 .phoneNumber("2062022299")
 *                 .build())
 *             .webhookReceivers(
 *                 WebhookReceiverArgs.builder()
 *                     .name("Sample webhook 1")
 *                     .serviceUri("http://www.example.com/webhook1")
 *                     .useCommonAlertSchema(true)
 *                     .build(),
 *                 WebhookReceiverArgs.builder()
 *                     .identifierUri("http://someidentifier/d7811ba3-7996-4a93-99b6-6b2f3f355f8a")
 *                     .name("Sample webhook 2")
 *                     .objectId("d3bb868c-fe44-452c-aa26-769a6538c808")
 *                     .serviceUri("http://www.example.com/webhook2")
 *                     .tenantId("68a4459a-ccb8-493c-b9da-dd30457d1b84")
 *                     .useAadAuth(true)
 *                     .useCommonAlertSchema(true)
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:TenantActionGroup testTenantActionGroup /providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Insights/tenantActionGroups/{tenantActionGroupName}
 * ```
 */
public class TenantActionGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.TenantActionGroup,
) : KotlinCustomResource(javaResource, TenantActionGroupMapper) {
    /**
     * The list of AzureAppPush receivers that are part of this tenant action group.
     */
    public val azureAppPushReceivers: Output<List<AzureAppPushReceiverResponse>>?
        get() = javaResource.azureAppPushReceivers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        azureAppPushReceiverResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The list of email receivers that are part of this tenant action group.
     */
    public val emailReceivers: Output<List<EmailReceiverResponse>>?
        get() = javaResource.emailReceivers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        emailReceiverResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Indicates whether this tenant action group is enabled. If a tenant action group is not enabled, then none of its receivers will receive communications.
     */
    public val enabled: Output<Boolean>
        get() = javaResource.enabled().applyValue({ args0 -> args0 })

    /**
     * The short name of the action group. This will be used in SMS messages.
     */
    public val groupShortName: Output<String>
        get() = javaResource.groupShortName().applyValue({ args0 -> args0 })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Azure resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The list of SMS receivers that are part of this tenant action group.
     */
    public val smsReceivers: Output<List<SmsReceiverResponse>>?
        get() = javaResource.smsReceivers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> smsReceiverResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Azure resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The list of voice receivers that are part of this tenant action group.
     */
    public val voiceReceivers: Output<List<VoiceReceiverResponse>>?
        get() = javaResource.voiceReceivers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        voiceReceiverResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The list of webhook receivers that are part of this tenant action group.
     */
    public val webhookReceivers: Output<List<WebhookReceiverResponse>>?
        get() = javaResource.webhookReceivers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        webhookReceiverResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })
}

public object TenantActionGroupMapper : ResourceMapper<TenantActionGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.TenantActionGroup::class == javaResource::class

    override fun map(javaResource: Resource): TenantActionGroup = TenantActionGroup(
        javaResource as
            com.pulumi.azurenative.insights.TenantActionGroup,
    )
}

/**
 * @see [TenantActionGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TenantActionGroup].
 */
public suspend fun tenantActionGroup(
    name: String,
    block: suspend TenantActionGroupResourceBuilder.() -> Unit,
): TenantActionGroup {
    val builder = TenantActionGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TenantActionGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun tenantActionGroup(name: String): TenantActionGroup {
    val builder = TenantActionGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
