@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.kotlin.outputs.WebTestGeolocationResponse
import com.pulumi.azurenative.insights.kotlin.outputs.WebTestPropertiesResponseConfiguration
import com.pulumi.azurenative.insights.kotlin.outputs.WebTestPropertiesResponseRequest
import com.pulumi.azurenative.insights.kotlin.outputs.WebTestPropertiesResponseValidationRules
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.insights.kotlin.outputs.WebTestGeolocationResponse.Companion.toKotlin as webTestGeolocationResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.WebTestPropertiesResponseConfiguration.Companion.toKotlin as webTestPropertiesResponseConfigurationToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.WebTestPropertiesResponseRequest.Companion.toKotlin as webTestPropertiesResponseRequestToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.WebTestPropertiesResponseValidationRules.Companion.toKotlin as webTestPropertiesResponseValidationRulesToKotlin

/**
 * Builder for [WebTest].
 */
@PulumiTagMarker
public class WebTestResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebTestArgs = WebTestArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebTestArgsBuilder.() -> Unit) {
        val builder = WebTestArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebTest {
        val builtJavaResource = com.pulumi.azurenative.insights.WebTest(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return WebTest(builtJavaResource)
    }
}

/**
 * An Application Insights WebTest definition.
 * Azure REST API version: 2022-06-15. Prior API version in Azure Native 1.x: 2015-05-01.
 * Other available API versions: 2020-10-05-preview.
 * ## Example Usage
 * ### webTestCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webTest = new AzureNative.Insights.WebTest("webTest", new()
 *     {
 *         Configuration = new AzureNative.Insights.Inputs.WebTestPropertiesConfigurationArgs
 *         {
 *             WebTest = "<WebTest Name=\"my-webtest\" Id=\"678ddf96-1ab8-44c8-9274-123456789abc\" Enabled=\"True\" CssProjectStructure=\"\" CssIteration=\"\" Timeout=\"120\" WorkItemIds=\"\" xmlns=\"http://microsoft.com/schemas/VisualStudio/TeamTest/2010\" Description=\"\" CredentialUserName=\"\" CredentialPassword=\"\" PreAuthenticate=\"True\" Proxy=\"default\" StopOnError=\"False\" RecordedResultFile=\"\" ResultsLocale=\"\" ><Items><Request Method=\"GET\" Guid=\"a4162485-9114-fcfc-e086-123456789abc\" Version=\"1.1\" Url=\"http://my-component.azurewebsites.net\" ThinkTime=\"0\" Timeout=\"120\" ParseDependentRequests=\"True\" FollowRedirects=\"True\" RecordResult=\"True\" Cache=\"False\" ResponseTimeGoal=\"0\" Encoding=\"utf-8\" ExpectedHttpStatusCode=\"200\" ExpectedResponseUrl=\"\" ReportingName=\"\" IgnoreHttpStatusCode=\"False\" /></Items></WebTest>",
 *         },
 *         Description = "Ping web test alert for mytestwebapp",
 *         Enabled = true,
 *         Frequency = 900,
 *         Kind = AzureNative.Insights.WebTestKind.Ping,
 *         Location = "South Central US",
 *         Locations = new[]
 *         {
 *             new AzureNative.Insights.Inputs.WebTestGeolocationArgs
 *             {
 *                 Location = "us-fl-mia-edge",
 *             },
 *         },
 *         ResourceGroupName = "my-resource-group",
 *         RetryEnabled = true,
 *         SyntheticMonitorId = "my-webtest-my-component",
 *         Timeout = 120,
 *         WebTestKind = AzureNative.Insights.WebTestKind.Ping,
 *         WebTestName = "my-webtest-my-component",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewWebTest(ctx, "webTest", &insights.WebTestArgs{
 * 			Configuration: &insights.WebTestPropertiesConfigurationArgs{
 * 				WebTest: pulumi.String("<WebTest Name=\"my-webtest\" Id=\"678ddf96-1ab8-44c8-9274-123456789abc\" Enabled=\"True\" CssProjectStructure=\"\" CssIteration=\"\" Timeout=\"120\" WorkItemIds=\"\" xmlns=\"http://microsoft.com/schemas/VisualStudio/TeamTest/2010\" Description=\"\" CredentialUserName=\"\" CredentialPassword=\"\" PreAuthenticate=\"True\" Proxy=\"default\" StopOnError=\"False\" RecordedResultFile=\"\" ResultsLocale=\"\" ><Items><Request Method=\"GET\" Guid=\"a4162485-9114-fcfc-e086-123456789abc\" Version=\"1.1\" Url=\"http://my-component.azurewebsites.net\" ThinkTime=\"0\" Timeout=\"120\" ParseDependentRequests=\"True\" FollowRedirects=\"True\" RecordResult=\"True\" Cache=\"False\" ResponseTimeGoal=\"0\" Encoding=\"utf-8\" ExpectedHttpStatusCode=\"200\" ExpectedResponseUrl=\"\" ReportingName=\"\" IgnoreHttpStatusCode=\"False\" /></Items></WebTest>"),
 * 			},
 * 			Description: pulumi.String("Ping web test alert for mytestwebapp"),
 * 			Enabled:     pulumi.Bool(true),
 * 			Frequency:   pulumi.Int(900),
 * 			Kind:        insights.WebTestKindPing,
 * 			Location:    pulumi.String("South Central US"),
 * 			Locations: insights.WebTestGeolocationArray{
 * 				&insights.WebTestGeolocationArgs{
 * 					Location: pulumi.String("us-fl-mia-edge"),
 * 				},
 * 			},
 * 			ResourceGroupName:  pulumi.String("my-resource-group"),
 * 			RetryEnabled:       pulumi.Bool(true),
 * 			SyntheticMonitorId: pulumi.String("my-webtest-my-component"),
 * 			Timeout:            pulumi.Int(120),
 * 			WebTestKind:        insights.WebTestKindPing,
 * 			WebTestName:        pulumi.String("my-webtest-my-component"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.WebTest;
 * import com.pulumi.azurenative.insights.WebTestArgs;
 * import com.pulumi.azurenative.insights.inputs.WebTestPropertiesConfigurationArgs;
 * import com.pulumi.azurenative.insights.inputs.WebTestGeolocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webTest = new WebTest("webTest", WebTestArgs.builder()
 *             .configuration(WebTestPropertiesConfigurationArgs.builder()
 *                 .webTest("<WebTest Name=\"my-webtest\" Id=\"678ddf96-1ab8-44c8-9274-123456789abc\" Enabled=\"True\" CssProjectStructure=\"\" CssIteration=\"\" Timeout=\"120\" WorkItemIds=\"\" xmlns=\"http://microsoft.com/schemas/VisualStudio/TeamTest/2010\" Description=\"\" CredentialUserName=\"\" CredentialPassword=\"\" PreAuthenticate=\"True\" Proxy=\"default\" StopOnError=\"False\" RecordedResultFile=\"\" ResultsLocale=\"\" ><Items><Request Method=\"GET\" Guid=\"a4162485-9114-fcfc-e086-123456789abc\" Version=\"1.1\" Url=\"http://my-component.azurewebsites.net\" ThinkTime=\"0\" Timeout=\"120\" ParseDependentRequests=\"True\" FollowRedirects=\"True\" RecordResult=\"True\" Cache=\"False\" ResponseTimeGoal=\"0\" Encoding=\"utf-8\" ExpectedHttpStatusCode=\"200\" ExpectedResponseUrl=\"\" ReportingName=\"\" IgnoreHttpStatusCode=\"False\" /></Items></WebTest>")
 *                 .build())
 *             .description("Ping web test alert for mytestwebapp")
 *             .enabled(true)
 *             .frequency(900)
 *             .kind("ping")
 *             .location("South Central US")
 *             .locations(WebTestGeolocationArgs.builder()
 *                 .location("us-fl-mia-edge")
 *                 .build())
 *             .resourceGroupName("my-resource-group")
 *             .retryEnabled(true)
 *             .syntheticMonitorId("my-webtest-my-component")
 *             .timeout(120)
 *             .webTestKind("ping")
 *             .webTestName("my-webtest-my-component")
 *             .build());
 *     }
 * }
 * ```
 * ### webTestCreateStandard
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webTest = new AzureNative.Insights.WebTest("webTest", new()
 *     {
 *         Description = "Ping web test alert for mytestwebapp",
 *         Enabled = true,
 *         Frequency = 900,
 *         Location = "South Central US",
 *         Locations = new[]
 *         {
 *             new AzureNative.Insights.Inputs.WebTestGeolocationArgs
 *             {
 *                 Location = "us-fl-mia-edge",
 *             },
 *         },
 *         Request = new AzureNative.Insights.Inputs.WebTestPropertiesRequestArgs
 *         {
 *             Headers = new[]
 *             {
 *                 new AzureNative.Insights.Inputs.HeaderFieldArgs
 *                 {
 *                     HeaderFieldName = "Content-Language",
 *                     HeaderFieldValue = "de-DE",
 *                 },
 *                 new AzureNative.Insights.Inputs.HeaderFieldArgs
 *                 {
 *                     HeaderFieldName = "Accept-Language",
 *                     HeaderFieldValue = "de-DE",
 *                 },
 *             },
 *             HttpVerb = "POST",
 *             RequestBody = "SGVsbG8gd29ybGQ=",
 *             RequestUrl = "https://bing.com",
 *         },
 *         ResourceGroupName = "my-resource-group",
 *         RetryEnabled = true,
 *         SyntheticMonitorId = "my-webtest-my-component",
 *         Timeout = 120,
 *         ValidationRules = new AzureNative.Insights.Inputs.WebTestPropertiesValidationRulesArgs
 *         {
 *             SSLCertRemainingLifetimeCheck = 100,
 *             SSLCheck = true,
 *         },
 *         WebTestKind = AzureNative.Insights.WebTestKind.Standard,
 *         WebTestName = "my-webtest-my-component",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewWebTest(ctx, "webTest", &insights.WebTestArgs{
 * 			Description: pulumi.String("Ping web test alert for mytestwebapp"),
 * 			Enabled:     pulumi.Bool(true),
 * 			Frequency:   pulumi.Int(900),
 * 			Location:    pulumi.String("South Central US"),
 * 			Locations: insights.WebTestGeolocationArray{
 * 				&insights.WebTestGeolocationArgs{
 * 					Location: pulumi.String("us-fl-mia-edge"),
 * 				},
 * 			},
 * 			Request: &insights.WebTestPropertiesRequestArgs{
 * 				Headers: insights.HeaderFieldArray{
 * 					&insights.HeaderFieldArgs{
 * 						HeaderFieldName:  pulumi.String("Content-Language"),
 * 						HeaderFieldValue: pulumi.String("de-DE"),
 * 					},
 * 					&insights.HeaderFieldArgs{
 * 						HeaderFieldName:  pulumi.String("Accept-Language"),
 * 						HeaderFieldValue: pulumi.String("de-DE"),
 * 					},
 * 				},
 * 				HttpVerb:    pulumi.String("POST"),
 * 				RequestBody: pulumi.String("SGVsbG8gd29ybGQ="),
 * 				RequestUrl:  pulumi.String("https://bing.com"),
 * 			},
 * 			ResourceGroupName:  pulumi.String("my-resource-group"),
 * 			RetryEnabled:       pulumi.Bool(true),
 * 			SyntheticMonitorId: pulumi.String("my-webtest-my-component"),
 * 			Timeout:            pulumi.Int(120),
 * 			ValidationRules: &insights.WebTestPropertiesValidationRulesArgs{
 * 				SSLCertRemainingLifetimeCheck: pulumi.Int(100),
 * 				SSLCheck:                      pulumi.Bool(true),
 * 			},
 * 			WebTestKind: insights.WebTestKindStandard,
 * 			WebTestName: pulumi.String("my-webtest-my-component"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.WebTest;
 * import com.pulumi.azurenative.insights.WebTestArgs;
 * import com.pulumi.azurenative.insights.inputs.WebTestGeolocationArgs;
 * import com.pulumi.azurenative.insights.inputs.WebTestPropertiesRequestArgs;
 * import com.pulumi.azurenative.insights.inputs.WebTestPropertiesValidationRulesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webTest = new WebTest("webTest", WebTestArgs.builder()
 *             .description("Ping web test alert for mytestwebapp")
 *             .enabled(true)
 *             .frequency(900)
 *             .location("South Central US")
 *             .locations(WebTestGeolocationArgs.builder()
 *                 .location("us-fl-mia-edge")
 *                 .build())
 *             .request(WebTestPropertiesRequestArgs.builder()
 *                 .headers(
 *                     HeaderFieldArgs.builder()
 *                         .headerFieldName("Content-Language")
 *                         .headerFieldValue("de-DE")
 *                         .build(),
 *                     HeaderFieldArgs.builder()
 *                         .headerFieldName("Accept-Language")
 *                         .headerFieldValue("de-DE")
 *                         .build())
 *                 .httpVerb("POST")
 *                 .requestBody("SGVsbG8gd29ybGQ=")
 *                 .requestUrl("https://bing.com")
 *                 .build())
 *             .resourceGroupName("my-resource-group")
 *             .retryEnabled(true)
 *             .syntheticMonitorId("my-webtest-my-component")
 *             .timeout(120)
 *             .validationRules(WebTestPropertiesValidationRulesArgs.builder()
 *                 .sSLCertRemainingLifetimeCheck(100)
 *                 .sSLCheck(true)
 *                 .build())
 *             .webTestKind("standard")
 *             .webTestName("my-webtest-my-component")
 *             .build());
 *     }
 * }
 * ```
 * ### webTestUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webTest = new AzureNative.Insights.WebTest("webTest", new()
 *     {
 *         Configuration = new AzureNative.Insights.Inputs.WebTestPropertiesConfigurationArgs
 *         {
 *             WebTest = "<WebTest Name=\"my-webtest\" Id=\"678ddf96-1ab8-44c8-9274-123456789abc\" Enabled=\"True\" CssProjectStructure=\"\" CssIteration=\"\" Timeout=\"30\" WorkItemIds=\"\" xmlns=\"http://microsoft.com/schemas/VisualStudio/TeamTest/2010\" Description=\"\" CredentialUserName=\"\" CredentialPassword=\"\" PreAuthenticate=\"True\" Proxy=\"default\" StopOnError=\"False\" RecordedResultFile=\"\" ResultsLocale=\"\" ><Items><Request Method=\"GET\" Guid=\"a4162485-9114-fcfc-e086-123456789abc\" Version=\"1.1\" Url=\"http://my-component.azurewebsites.net\" ThinkTime=\"0\" Timeout=\"30\" ParseDependentRequests=\"True\" FollowRedirects=\"True\" RecordResult=\"True\" Cache=\"False\" ResponseTimeGoal=\"0\" Encoding=\"utf-8\" ExpectedHttpStatusCode=\"200\" ExpectedResponseUrl=\"\" ReportingName=\"\" IgnoreHttpStatusCode=\"False\" /></Items></WebTest>",
 *         },
 *         Frequency = 600,
 *         Kind = AzureNative.Insights.WebTestKind.Ping,
 *         Location = "South Central US",
 *         Locations = new[]
 *         {
 *             new AzureNative.Insights.Inputs.WebTestGeolocationArgs
 *             {
 *                 Location = "us-fl-mia-edge",
 *             },
 *             new AzureNative.Insights.Inputs.WebTestGeolocationArgs
 *             {
 *                 Location = "apac-hk-hkn-azr",
 *             },
 *         },
 *         ResourceGroupName = "my-resource-group",
 *         SyntheticMonitorId = "my-webtest-my-component",
 *         Timeout = 30,
 *         WebTestKind = AzureNative.Insights.WebTestKind.Ping,
 *         WebTestName = "my-webtest-my-component",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewWebTest(ctx, "webTest", &insights.WebTestArgs{
 * 			Configuration: &insights.WebTestPropertiesConfigurationArgs{
 * 				WebTest: pulumi.String("<WebTest Name=\"my-webtest\" Id=\"678ddf96-1ab8-44c8-9274-123456789abc\" Enabled=\"True\" CssProjectStructure=\"\" CssIteration=\"\" Timeout=\"30\" WorkItemIds=\"\" xmlns=\"http://microsoft.com/schemas/VisualStudio/TeamTest/2010\" Description=\"\" CredentialUserName=\"\" CredentialPassword=\"\" PreAuthenticate=\"True\" Proxy=\"default\" StopOnError=\"False\" RecordedResultFile=\"\" ResultsLocale=\"\" ><Items><Request Method=\"GET\" Guid=\"a4162485-9114-fcfc-e086-123456789abc\" Version=\"1.1\" Url=\"http://my-component.azurewebsites.net\" ThinkTime=\"0\" Timeout=\"30\" ParseDependentRequests=\"True\" FollowRedirects=\"True\" RecordResult=\"True\" Cache=\"False\" ResponseTimeGoal=\"0\" Encoding=\"utf-8\" ExpectedHttpStatusCode=\"200\" ExpectedResponseUrl=\"\" ReportingName=\"\" IgnoreHttpStatusCode=\"False\" /></Items></WebTest>"),
 * 			},
 * 			Frequency: pulumi.Int(600),
 * 			Kind:      insights.WebTestKindPing,
 * 			Location:  pulumi.String("South Central US"),
 * 			Locations: insights.WebTestGeolocationArray{
 * 				&insights.WebTestGeolocationArgs{
 * 					Location: pulumi.String("us-fl-mia-edge"),
 * 				},
 * 				&insights.WebTestGeolocationArgs{
 * 					Location: pulumi.String("apac-hk-hkn-azr"),
 * 				},
 * 			},
 * 			ResourceGroupName:  pulumi.String("my-resource-group"),
 * 			SyntheticMonitorId: pulumi.String("my-webtest-my-component"),
 * 			Timeout:            pulumi.Int(30),
 * 			WebTestKind:        insights.WebTestKindPing,
 * 			WebTestName:        pulumi.String("my-webtest-my-component"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.WebTest;
 * import com.pulumi.azurenative.insights.WebTestArgs;
 * import com.pulumi.azurenative.insights.inputs.WebTestPropertiesConfigurationArgs;
 * import com.pulumi.azurenative.insights.inputs.WebTestGeolocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webTest = new WebTest("webTest", WebTestArgs.builder()
 *             .configuration(WebTestPropertiesConfigurationArgs.builder()
 *                 .webTest("<WebTest Name=\"my-webtest\" Id=\"678ddf96-1ab8-44c8-9274-123456789abc\" Enabled=\"True\" CssProjectStructure=\"\" CssIteration=\"\" Timeout=\"30\" WorkItemIds=\"\" xmlns=\"http://microsoft.com/schemas/VisualStudio/TeamTest/2010\" Description=\"\" CredentialUserName=\"\" CredentialPassword=\"\" PreAuthenticate=\"True\" Proxy=\"default\" StopOnError=\"False\" RecordedResultFile=\"\" ResultsLocale=\"\" ><Items><Request Method=\"GET\" Guid=\"a4162485-9114-fcfc-e086-123456789abc\" Version=\"1.1\" Url=\"http://my-component.azurewebsites.net\" ThinkTime=\"0\" Timeout=\"30\" ParseDependentRequests=\"True\" FollowRedirects=\"True\" RecordResult=\"True\" Cache=\"False\" ResponseTimeGoal=\"0\" Encoding=\"utf-8\" ExpectedHttpStatusCode=\"200\" ExpectedResponseUrl=\"\" ReportingName=\"\" IgnoreHttpStatusCode=\"False\" /></Items></WebTest>")
 *                 .build())
 *             .frequency(600)
 *             .kind("ping")
 *             .location("South Central US")
 *             .locations(
 *                 WebTestGeolocationArgs.builder()
 *                     .location("us-fl-mia-edge")
 *                     .build(),
 *                 WebTestGeolocationArgs.builder()
 *                     .location("apac-hk-hkn-azr")
 *                     .build())
 *             .resourceGroupName("my-resource-group")
 *             .syntheticMonitorId("my-webtest-my-component")
 *             .timeout(30)
 *             .webTestKind("ping")
 *             .webTestName("my-webtest-my-component")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:WebTest my-webtest-my-component /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/webtests/{webTestName}
 * ```
 */
public class WebTest internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.WebTest,
) : KotlinCustomResource(javaResource, WebTestMapper) {
    /**
     * An XML configuration specification for a WebTest.
     */
    public val configuration: Output<WebTestPropertiesResponseConfiguration>?
        get() = javaResource.configuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> webTestPropertiesResponseConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * User defined description for this WebTest.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Is the test actively being monitored.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Interval in seconds between test runs for this WebTest. Default value is 300.
     */
    public val frequency: Output<Int>?
        get() = javaResource.frequency().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The kind of WebTest that this web test watches. Choices are ping, multistep and standard.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * A list of where to physically run the tests from to give global coverage for accessibility of your application.
     */
    public val locations: Output<List<WebTestGeolocationResponse>>
        get() = javaResource.locations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    webTestGeolocationResponseToKotlin(args0)
                })
            })
        })

    /**
     * Azure resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Current state of this component, whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Succeeded, Deploying, Canceled, and Failed.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The collection of request properties
     */
    public val request: Output<WebTestPropertiesResponseRequest>?
        get() = javaResource.request().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    webTestPropertiesResponseRequestToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Allow for retries should this WebTest fail.
     */
    public val retryEnabled: Output<Boolean>?
        get() = javaResource.retryEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Unique ID of this WebTest. This is typically the same value as the Name field.
     */
    public val syntheticMonitorId: Output<String>
        get() = javaResource.syntheticMonitorId().applyValue({ args0 -> args0 })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Seconds until this WebTest will timeout and fail. Default value is 30.
     */
    public val timeout: Output<Int>?
        get() = javaResource.timeout().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The collection of validation rule properties
     */
    public val validationRules: Output<WebTestPropertiesResponseValidationRules>?
        get() = javaResource.validationRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    webTestPropertiesResponseValidationRulesToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The kind of web test this is, valid choices are ping, multistep and standard.
     */
    public val webTestKind: Output<String>
        get() = javaResource.webTestKind().applyValue({ args0 -> args0 })

    /**
     * User defined name if this WebTest.
     */
    public val webTestName: Output<String>
        get() = javaResource.webTestName().applyValue({ args0 -> args0 })
}

public object WebTestMapper : ResourceMapper<WebTest> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.WebTest::class == javaResource::class

    override fun map(javaResource: Resource): WebTest = WebTest(
        javaResource as
            com.pulumi.azurenative.insights.WebTest,
    )
}

/**
 * @see [WebTest].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebTest].
 */
public suspend fun webTest(name: String, block: suspend WebTestResourceBuilder.() -> Unit):
    WebTest {
    val builder = WebTestResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebTest].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webTest(name: String): WebTest {
    val builder = WebTestResourceBuilder()
    builder.name(name)
    return builder.build()
}
