@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.kotlin.outputs.WorkbookTemplateGalleryResponse
import com.pulumi.azurenative.insights.kotlin.outputs.WorkbookTemplateLocalizedGalleryResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.insights.kotlin.outputs.WorkbookTemplateGalleryResponse.Companion.toKotlin as workbookTemplateGalleryResponseToKotlin
import com.pulumi.azurenative.insights.kotlin.outputs.WorkbookTemplateLocalizedGalleryResponse.Companion.toKotlin as workbookTemplateLocalizedGalleryResponseToKotlin

/**
 * Builder for [WorkbookTemplate].
 */
@PulumiTagMarker
public class WorkbookTemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkbookTemplateArgs = WorkbookTemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkbookTemplateArgsBuilder.() -> Unit) {
        val builder = WorkbookTemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WorkbookTemplate {
        val builtJavaResource =
            com.pulumi.azurenative.insights.WorkbookTemplate(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkbookTemplate(builtJavaResource)
    }
}

/**
 * An Application Insights workbook template definition.
 * Azure REST API version: 2020-11-20. Prior API version in Azure Native 1.x: 2019-10-17-preview.
 * ## Example Usage
 * ### WorkbookTemplateAdd
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workbookTemplate = new AzureNative.Insights.WorkbookTemplate("workbookTemplate", new()
 *     {
 *         Author = "Contoso",
 *         Galleries = new[]
 *         {
 *             new AzureNative.Insights.Inputs.WorkbookTemplateGalleryArgs
 *             {
 *                 Category = "Failures",
 *                 Name = "Simple Template",
 *                 Order = 100,
 *                 ResourceType = "microsoft.insights/components",
 *                 Type = "tsg",
 *             },
 *         },
 *         Location = "west us",
 *         Priority = 1,
 *         ResourceGroupName = "my-resource-group",
 *         ResourceName = "testtemplate2",
 *         TemplateData = new Dictionary<string, object?>
 *         {
 *             ["$schema"] = "https://github.com/Microsoft/Application-Insights-Workbooks/blob/master/schema/workbook.json",
 *             ["items"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["content"] = new Dictionary<string, object?>
 *                     {
 *                         ["json"] = @"## New workbook
 * ---
 * Welcome to your new workbook.  This area will display text formatted as markdown.
 * We've included a basic analytics query to get you started. Use the `Edit` button below each section to configure it or add more sections.",
 *                     },
 *                     ["name"] = "text - 2",
 *                     ["type"] = 1,
 *                 },
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["content"] = new Dictionary<string, object?>
 *                     {
 *                         ["exportToExcelOptions"] = "visible",
 *                         ["query"] = @"union withsource=TableName *
 * | summarize Count=count() by TableName
 * | render barchart",
 *                         ["queryType"] = 0,
 *                         ["resourceType"] = "microsoft.operationalinsights/workspaces",
 *                         ["size"] = 1,
 *                         ["version"] = "KqlItem/1.0",
 *                     },
 *                     ["name"] = "query - 2",
 *                     ["type"] = 3,
 *                 },
 *             },
 *             ["styleSettings"] = new Dictionary<string, object?>
 *             {
 *             },
 *             ["version"] = "Notebook/1.0",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewWorkbookTemplate(ctx, "workbookTemplate", &insights.WorkbookTemplateArgs{
 * 			Author: pulumi.String("Contoso"),
 * 			Galleries: insights.WorkbookTemplateGalleryArray{
 * 				&insights.WorkbookTemplateGalleryArgs{
 * 					Category:     pulumi.String("Failures"),
 * 					Name:         pulumi.String("Simple Template"),
 * 					Order:        pulumi.Int(100),
 * 					ResourceType: pulumi.String("microsoft.insights/components"),
 * 					Type:         pulumi.String("tsg"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("west us"),
 * 			Priority:          pulumi.Int(1),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			ResourceName:      pulumi.String("testtemplate2"),
 * 			TemplateData: pulumi.Any(map[string]interface{}{
 * 				"$schema": "https://github.com/Microsoft/Application-Insights-Workbooks/blob/master/schema/workbook.json",
 * 				"items": []interface{}{
 * 					map[string]interface{}{
 * 						"content": map[string]interface{}{
 * 							"json": "## New workbook\n---\n\nWelcome to your new workbook.  This area will display text formatted as markdown.\n\n\nWe've included a basic analytics query to get you started. Use the `Edit` button below each section to configure it or add more sections.",
 * 						},
 * 						"name": "text - 2",
 * 						"type": 1,
 * 					},
 * 					map[string]interface{}{
 * 						"content": map[string]interface{}{
 * 							"exportToExcelOptions": "visible",
 * 							"query":                "union withsource=TableName *\n| summarize Count=count() by TableName\n| render barchart",
 * 							"queryType":            0,
 * 							"resourceType":         "microsoft.operationalinsights/workspaces",
 * 							"size":                 1,
 * 							"version":              "KqlItem/1.0",
 * 						},
 * 						"name": "query - 2",
 * 						"type": 3,
 * 					},
 * 				},
 * 				"styleSettings": nil,
 * 				"version":       "Notebook/1.0",
 * 			}),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.WorkbookTemplate;
 * import com.pulumi.azurenative.insights.WorkbookTemplateArgs;
 * import com.pulumi.azurenative.insights.inputs.WorkbookTemplateGalleryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workbookTemplate = new WorkbookTemplate("workbookTemplate", WorkbookTemplateArgs.builder()
 *             .author("Contoso")
 *             .galleries(WorkbookTemplateGalleryArgs.builder()
 *                 .category("Failures")
 *                 .name("Simple Template")
 *                 .order(100)
 *                 .resourceType("microsoft.insights/components")
 *                 .type("tsg")
 *                 .build())
 *             .location("west us")
 *             .priority(1)
 *             .resourceGroupName("my-resource-group")
 *             .resourceName("testtemplate2")
 *             .templateData(Map.ofEntries(
 *                 Map.entry("$schema", "https://github.com/Microsoft/Application-Insights-Workbooks/blob/master/schema/workbook.json"),
 *                 Map.entry("items",
 *                     Map.ofEntries(
 *                         Map.entry("content", Map.of("json", """
 * ## New workbook
 * ---
 * Welcome to your new workbook.  This area will display text formatted as markdown.
 * We've included a basic analytics query to get you started. Use the `Edit` button below each section to configure it or add more sections.                        """)),
 *                         Map.entry("name", "text - 2"),
 *                         Map.entry("type", 1)
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("content", Map.ofEntries(
 *                             Map.entry("exportToExcelOptions", "visible"),
 *                             Map.entry("query", """
 * union withsource=TableName *
 * | summarize Count=count() by TableName
 * | render barchart                            """),
 *                             Map.entry("queryType", 0),
 *                             Map.entry("resourceType", "microsoft.operationalinsights/workspaces"),
 *                             Map.entry("size", 1),
 *                             Map.entry("version", "KqlItem/1.0")
 *                         )),
 *                         Map.entry("name", "query - 2"),
 *                         Map.entry("type", 3)
 *                     )),
 *                 Map.entry("styleSettings", ),
 *                 Map.entry("version", "Notebook/1.0")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:WorkbookTemplate testtemplate2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/workbooktemplates/{resourceName}
 * ```
 */
public class WorkbookTemplate internal constructor(
    override val javaResource: com.pulumi.azurenative.insights.WorkbookTemplate,
) : KotlinCustomResource(javaResource, WorkbookTemplateMapper) {
    /**
     * Information about the author of the workbook template.
     */
    public val author: Output<String>?
        get() = javaResource.author().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Workbook galleries supported by the template.
     */
    public val galleries: Output<List<WorkbookTemplateGalleryResponse>>
        get() = javaResource.galleries().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    workbookTemplateGalleryResponseToKotlin(args0)
                })
            })
        })

    /**
     * Key value pair of localized gallery. Each key is the locale code of languages supported by the Azure portal.
     */
    public val localized: Output<Map<String, List<WorkbookTemplateLocalizedGalleryResponse>>>?
        get() = javaResource.localized().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.map({ args0 ->
                            args0.let({ args0 ->
                                workbookTemplateLocalizedGalleryResponseToKotlin(args0)
                            })
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Azure resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Priority of the template. Determines which template to open when a workbook gallery is opened in viewer mode.
     */
    public val priority: Output<Int>?
        get() = javaResource.priority().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Valid JSON object containing workbook template payload.
     */
    public val templateData: Output<Any>
        get() = javaResource.templateData().applyValue({ args0 -> args0 })

    /**
     * Azure resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WorkbookTemplateMapper : ResourceMapper<WorkbookTemplate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.insights.WorkbookTemplate::class == javaResource::class

    override fun map(javaResource: Resource): WorkbookTemplate = WorkbookTemplate(
        javaResource as
            com.pulumi.azurenative.insights.WorkbookTemplate,
    )
}

/**
 * @see [WorkbookTemplate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkbookTemplate].
 */
public suspend fun workbookTemplate(
    name: String,
    block: suspend WorkbookTemplateResourceBuilder.() -> Unit,
): WorkbookTemplate {
    val builder = WorkbookTemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkbookTemplate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workbookTemplate(name: String): WorkbookTemplate {
    val builder = WorkbookTemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
