@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin

import com.pulumi.azurenative.insights.WorkbookTemplateArgs.builder
import com.pulumi.azurenative.insights.kotlin.inputs.WorkbookTemplateGalleryArgs
import com.pulumi.azurenative.insights.kotlin.inputs.WorkbookTemplateGalleryArgsBuilder
import com.pulumi.azurenative.insights.kotlin.inputs.WorkbookTemplateLocalizedGalleryArgs
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Application Insights workbook template definition.
 * Azure REST API version: 2020-11-20. Prior API version in Azure Native 1.x: 2019-10-17-preview.
 * ## Example Usage
 * ### WorkbookTemplateAdd
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workbookTemplate = new AzureNative.Insights.WorkbookTemplate("workbookTemplate", new()
 *     {
 *         Author = "Contoso",
 *         Galleries = new[]
 *         {
 *             new AzureNative.Insights.Inputs.WorkbookTemplateGalleryArgs
 *             {
 *                 Category = "Failures",
 *                 Name = "Simple Template",
 *                 Order = 100,
 *                 ResourceType = "microsoft.insights/components",
 *                 Type = "tsg",
 *             },
 *         },
 *         Location = "west us",
 *         Priority = 1,
 *         ResourceGroupName = "my-resource-group",
 *         ResourceName = "testtemplate2",
 *         TemplateData = new Dictionary<string, object?>
 *         {
 *             ["$schema"] = "https://github.com/Microsoft/Application-Insights-Workbooks/blob/master/schema/workbook.json",
 *             ["items"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["content"] = new Dictionary<string, object?>
 *                     {
 *                         ["json"] = @"## New workbook
 * ---
 * Welcome to your new workbook.  This area will display text formatted as markdown.
 * We've included a basic analytics query to get you started. Use the `Edit` button below each section to configure it or add more sections.",
 *                     },
 *                     ["name"] = "text - 2",
 *                     ["type"] = 1,
 *                 },
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["content"] = new Dictionary<string, object?>
 *                     {
 *                         ["exportToExcelOptions"] = "visible",
 *                         ["query"] = @"union withsource=TableName *
 * | summarize Count=count() by TableName
 * | render barchart",
 *                         ["queryType"] = 0,
 *                         ["resourceType"] = "microsoft.operationalinsights/workspaces",
 *                         ["size"] = 1,
 *                         ["version"] = "KqlItem/1.0",
 *                     },
 *                     ["name"] = "query - 2",
 *                     ["type"] = 3,
 *                 },
 *             },
 *             ["styleSettings"] = new Dictionary<string, object?>
 *             {
 *             },
 *             ["version"] = "Notebook/1.0",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/insights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := insights.NewWorkbookTemplate(ctx, "workbookTemplate", &insights.WorkbookTemplateArgs{
 * 			Author: pulumi.String("Contoso"),
 * 			Galleries: insights.WorkbookTemplateGalleryArray{
 * 				&insights.WorkbookTemplateGalleryArgs{
 * 					Category:     pulumi.String("Failures"),
 * 					Name:         pulumi.String("Simple Template"),
 * 					Order:        pulumi.Int(100),
 * 					ResourceType: pulumi.String("microsoft.insights/components"),
 * 					Type:         pulumi.String("tsg"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("west us"),
 * 			Priority:          pulumi.Int(1),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			ResourceName:      pulumi.String("testtemplate2"),
 * 			TemplateData: pulumi.Any(map[string]interface{}{
 * 				"$schema": "https://github.com/Microsoft/Application-Insights-Workbooks/blob/master/schema/workbook.json",
 * 				"items": []interface{}{
 * 					map[string]interface{}{
 * 						"content": map[string]interface{}{
 * 							"json": "## New workbook\n---\n\nWelcome to your new workbook.  This area will display text formatted as markdown.\n\n\nWe've included a basic analytics query to get you started. Use the `Edit` button below each section to configure it or add more sections.",
 * 						},
 * 						"name": "text - 2",
 * 						"type": 1,
 * 					},
 * 					map[string]interface{}{
 * 						"content": map[string]interface{}{
 * 							"exportToExcelOptions": "visible",
 * 							"query":                "union withsource=TableName *\n| summarize Count=count() by TableName\n| render barchart",
 * 							"queryType":            0,
 * 							"resourceType":         "microsoft.operationalinsights/workspaces",
 * 							"size":                 1,
 * 							"version":              "KqlItem/1.0",
 * 						},
 * 						"name": "query - 2",
 * 						"type": 3,
 * 					},
 * 				},
 * 				"styleSettings": nil,
 * 				"version":       "Notebook/1.0",
 * 			}),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.insights.WorkbookTemplate;
 * import com.pulumi.azurenative.insights.WorkbookTemplateArgs;
 * import com.pulumi.azurenative.insights.inputs.WorkbookTemplateGalleryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workbookTemplate = new WorkbookTemplate("workbookTemplate", WorkbookTemplateArgs.builder()
 *             .author("Contoso")
 *             .galleries(WorkbookTemplateGalleryArgs.builder()
 *                 .category("Failures")
 *                 .name("Simple Template")
 *                 .order(100)
 *                 .resourceType("microsoft.insights/components")
 *                 .type("tsg")
 *                 .build())
 *             .location("west us")
 *             .priority(1)
 *             .resourceGroupName("my-resource-group")
 *             .resourceName("testtemplate2")
 *             .templateData(Map.ofEntries(
 *                 Map.entry("$schema", "https://github.com/Microsoft/Application-Insights-Workbooks/blob/master/schema/workbook.json"),
 *                 Map.entry("items",
 *                     Map.ofEntries(
 *                         Map.entry("content", Map.of("json", """
 * ## New workbook
 * ---
 * Welcome to your new workbook.  This area will display text formatted as markdown.
 * We've included a basic analytics query to get you started. Use the `Edit` button below each section to configure it or add more sections.                        """)),
 *                         Map.entry("name", "text - 2"),
 *                         Map.entry("type", 1)
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("content", Map.ofEntries(
 *                             Map.entry("exportToExcelOptions", "visible"),
 *                             Map.entry("query", """
 * union withsource=TableName *
 * | summarize Count=count() by TableName
 * | render barchart                            """),
 *                             Map.entry("queryType", 0),
 *                             Map.entry("resourceType", "microsoft.operationalinsights/workspaces"),
 *                             Map.entry("size", 1),
 *                             Map.entry("version", "KqlItem/1.0")
 *                         )),
 *                         Map.entry("name", "query - 2"),
 *                         Map.entry("type", 3)
 *                     )),
 *                 Map.entry("styleSettings", ),
 *                 Map.entry("version", "Notebook/1.0")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:insights:WorkbookTemplate testtemplate2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/workbooktemplates/{resourceName}
 * ```
 * @property author Information about the author of the workbook template.
 * @property galleries Workbook galleries supported by the template.
 * @property localized Key value pair of localized gallery. Each key is the locale code of languages supported by the Azure portal.
 * @property location Resource location
 * @property priority Priority of the template. Determines which template to open when a workbook gallery is opened in viewer mode.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the Application Insights component resource.
 * @property tags Resource tags
 * @property templateData Valid JSON object containing workbook template payload.
 */
public data class WorkbookTemplateArgs(
    public val author: Output<String>? = null,
    public val galleries: Output<List<WorkbookTemplateGalleryArgs>>? = null,
    public val localized: Output<Map<String, List<WorkbookTemplateLocalizedGalleryArgs>>>? = null,
    public val location: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val templateData: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.WorkbookTemplateArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.WorkbookTemplateArgs =
        com.pulumi.azurenative.insights.WorkbookTemplateArgs.builder()
            .author(author?.applyValue({ args0 -> args0 }))
            .galleries(
                galleries?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .localized(
                localized?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
                    }).toMap()
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .templateData(templateData?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkbookTemplateArgs].
 */
@PulumiTagMarker
public class WorkbookTemplateArgsBuilder internal constructor() {
    private var author: Output<String>? = null

    private var galleries: Output<List<WorkbookTemplateGalleryArgs>>? = null

    private var localized: Output<Map<String, List<WorkbookTemplateLocalizedGalleryArgs>>>? = null

    private var location: Output<String>? = null

    private var priority: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var templateData: Output<Any>? = null

    /**
     * @param value Information about the author of the workbook template.
     */
    @JvmName("snsjttsypmfyvflo")
    public suspend fun author(`value`: Output<String>) {
        this.author = value
    }

    /**
     * @param value Workbook galleries supported by the template.
     */
    @JvmName("ugebfgujvsrvyrkn")
    public suspend fun galleries(`value`: Output<List<WorkbookTemplateGalleryArgs>>) {
        this.galleries = value
    }

    @JvmName("yolnxmdkbojpuihy")
    public suspend fun galleries(vararg values: Output<WorkbookTemplateGalleryArgs>) {
        this.galleries = Output.all(values.asList())
    }

    /**
     * @param values Workbook galleries supported by the template.
     */
    @JvmName("udyibmkionufxgwj")
    public suspend fun galleries(values: List<Output<WorkbookTemplateGalleryArgs>>) {
        this.galleries = Output.all(values)
    }

    /**
     * @param value Key value pair of localized gallery. Each key is the locale code of languages supported by the Azure portal.
     */
    @JvmName("twfgvlpoltkfijvy")
    public suspend
    fun localized(`value`: Output<Map<String, List<WorkbookTemplateLocalizedGalleryArgs>>>) {
        this.localized = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("outlqalbnrejcmui")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Priority of the template. Determines which template to open when a workbook gallery is opened in viewer mode.
     */
    @JvmName("uoeocmxswclefsya")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kjohthbrtbdxnbks")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Application Insights component resource.
     */
    @JvmName("eeuhgjjccawhiomy")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("vkckufqmeiebcpbv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Valid JSON object containing workbook template payload.
     */
    @JvmName("hgcfxfsouiqprycw")
    public suspend fun templateData(`value`: Output<Any>) {
        this.templateData = value
    }

    /**
     * @param value Information about the author of the workbook template.
     */
    @JvmName("tumkalemcvconcmw")
    public suspend fun author(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.author = mapped
    }

    /**
     * @param value Workbook galleries supported by the template.
     */
    @JvmName("xytsqrgpmnwbolwv")
    public suspend fun galleries(`value`: List<WorkbookTemplateGalleryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.galleries = mapped
    }

    /**
     * @param argument Workbook galleries supported by the template.
     */
    @JvmName("hircdjeuhomkrnev")
    public suspend
    fun galleries(argument: List<suspend WorkbookTemplateGalleryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WorkbookTemplateGalleryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.galleries = mapped
    }

    /**
     * @param argument Workbook galleries supported by the template.
     */
    @JvmName("doiainroeaesrleo")
    public suspend fun galleries(
        vararg
        argument: suspend WorkbookTemplateGalleryArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WorkbookTemplateGalleryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.galleries = mapped
    }

    /**
     * @param argument Workbook galleries supported by the template.
     */
    @JvmName("hibdkcymplhtqrdr")
    public suspend fun galleries(argument: suspend WorkbookTemplateGalleryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WorkbookTemplateGalleryArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.galleries = mapped
    }

    /**
     * @param values Workbook galleries supported by the template.
     */
    @JvmName("svjywswkttrhinru")
    public suspend fun galleries(vararg values: WorkbookTemplateGalleryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.galleries = mapped
    }

    /**
     * @param value Key value pair of localized gallery. Each key is the locale code of languages supported by the Azure portal.
     */
    @JvmName("pttuekkphulcabsq")
    public suspend fun localized(`value`: Map<String, List<WorkbookTemplateLocalizedGalleryArgs>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localized = mapped
    }

    /**
     * @param values Key value pair of localized gallery. Each key is the locale code of languages supported by the Azure portal.
     */
    @JvmName("pffreieepyxwafge")
    public fun localized(vararg values: Pair<String, List<WorkbookTemplateLocalizedGalleryArgs>>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.localized = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("bhjnpfkadqjvgdxx")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Priority of the template. Determines which template to open when a workbook gallery is opened in viewer mode.
     */
    @JvmName("rfcejgkuiktinqvd")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("roemfqxrffspjdma")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Application Insights component resource.
     */
    @JvmName("gidwekpmhqpxwkpm")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("brorxeywkoqayyja")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("dxvbprkmvapfaifa")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Valid JSON object containing workbook template payload.
     */
    @JvmName("eerlhfgawrrannoa")
    public suspend fun templateData(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateData = mapped
    }

    internal fun build(): WorkbookTemplateArgs = WorkbookTemplateArgs(
        author = author,
        galleries = galleries,
        localized = localized,
        location = location,
        priority = priority,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        tags = tags,
        templateData = templateData,
    )
}
