@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The criteria operator. Relevant and required only for rules of the kind LogAlert.
 */
public enum class ConditionOperator(
    public val javaValue: com.pulumi.azurenative.insights.enums.ConditionOperator,
) : ConvertibleToJava<com.pulumi.azurenative.insights.enums.ConditionOperator> {
    Equals(com.pulumi.azurenative.insights.enums.ConditionOperator.Equals),
    GreaterThan(com.pulumi.azurenative.insights.enums.ConditionOperator.GreaterThan),
    GreaterThanOrEqual(com.pulumi.azurenative.insights.enums.ConditionOperator.GreaterThanOrEqual),
    LessThan(com.pulumi.azurenative.insights.enums.ConditionOperator.LessThan),
    LessThanOrEqual(com.pulumi.azurenative.insights.enums.ConditionOperator.LessThanOrEqual),
    ;

    override fun toJava(): com.pulumi.azurenative.insights.enums.ConditionOperator = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.enums.ConditionOperator):
            ConditionOperator = ConditionOperator.values().first { it.javaValue == javaType }
    }
}
