@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * the time aggregation operator. How the data that are collected should be combined over time. The default value is the PrimaryAggregationType of the Metric.
 */
public enum class TimeAggregationOperator(
    public val javaValue: com.pulumi.azurenative.insights.enums.TimeAggregationOperator,
) : ConvertibleToJava<com.pulumi.azurenative.insights.enums.TimeAggregationOperator> {
    Average(com.pulumi.azurenative.insights.enums.TimeAggregationOperator.Average),
    Minimum(com.pulumi.azurenative.insights.enums.TimeAggregationOperator.Minimum),
    Maximum(com.pulumi.azurenative.insights.enums.TimeAggregationOperator.Maximum),
    Total(com.pulumi.azurenative.insights.enums.TimeAggregationOperator.Total),
    Last(com.pulumi.azurenative.insights.enums.TimeAggregationOperator.Last),
    ;

    override fun toJava(): com.pulumi.azurenative.insights.enums.TimeAggregationOperator = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.enums.TimeAggregationOperator):
            TimeAggregationOperator =
            TimeAggregationOperator.values().first { it.javaValue == javaType }
    }
}
