@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.AlertRuleAllOfConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An Activity Log Alert rule condition that is met when all its member conditions are met.
 * @property allOf The list of Activity Log Alert rule conditions.
 */
public data class AlertRuleAllOfConditionArgs(
    public val allOf: Output<List<AlertRuleAnyOfOrLeafConditionArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.AlertRuleAllOfConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.AlertRuleAllOfConditionArgs =
        com.pulumi.azurenative.insights.inputs.AlertRuleAllOfConditionArgs.builder()
            .allOf(
                allOf.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AlertRuleAllOfConditionArgs].
 */
@PulumiTagMarker
public class AlertRuleAllOfConditionArgsBuilder internal constructor() {
    private var allOf: Output<List<AlertRuleAnyOfOrLeafConditionArgs>>? = null

    /**
     * @param value The list of Activity Log Alert rule conditions.
     */
    @JvmName("xathselwswcpcyhb")
    public suspend fun allOf(`value`: Output<List<AlertRuleAnyOfOrLeafConditionArgs>>) {
        this.allOf = value
    }

    @JvmName("cafvdhmgncqhrhbp")
    public suspend fun allOf(vararg values: Output<AlertRuleAnyOfOrLeafConditionArgs>) {
        this.allOf = Output.all(values.asList())
    }

    /**
     * @param values The list of Activity Log Alert rule conditions.
     */
    @JvmName("bqhefcpnuwqshkyw")
    public suspend fun allOf(values: List<Output<AlertRuleAnyOfOrLeafConditionArgs>>) {
        this.allOf = Output.all(values)
    }

    /**
     * @param value The list of Activity Log Alert rule conditions.
     */
    @JvmName("uhsqplwkpoymnhfe")
    public suspend fun allOf(`value`: List<AlertRuleAnyOfOrLeafConditionArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allOf = mapped
    }

    /**
     * @param argument The list of Activity Log Alert rule conditions.
     */
    @JvmName("gbpytgynrbvmcgxn")
    public suspend
    fun allOf(argument: List<suspend AlertRuleAnyOfOrLeafConditionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AlertRuleAnyOfOrLeafConditionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.allOf = mapped
    }

    /**
     * @param argument The list of Activity Log Alert rule conditions.
     */
    @JvmName("vygixreahufvgsqs")
    public suspend fun allOf(
        vararg
        argument: suspend AlertRuleAnyOfOrLeafConditionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AlertRuleAnyOfOrLeafConditionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.allOf = mapped
    }

    /**
     * @param argument The list of Activity Log Alert rule conditions.
     */
    @JvmName("aupupccqpjrdfbra")
    public suspend fun allOf(argument: suspend AlertRuleAnyOfOrLeafConditionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AlertRuleAnyOfOrLeafConditionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.allOf = mapped
    }

    /**
     * @param values The list of Activity Log Alert rule conditions.
     */
    @JvmName("jpyhjsbwafhsuojg")
    public suspend fun allOf(vararg values: AlertRuleAnyOfOrLeafConditionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allOf = mapped
    }

    internal fun build(): AlertRuleAllOfConditionArgs = AlertRuleAllOfConditionArgs(
        allOf = allOf ?: throw PulumiNullFieldException("allOf"),
    )
}
