@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.AlertRuleLeafConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An Activity Log Alert rule condition that is met by comparing the field and value of an Activity Log event.
 * This condition must contain 'field' and either 'equals' or 'containsAny'.
 * @property containsAny The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met.
 * @property equals The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met.
 * @property field The name of the Activity Log event's field that this condition will examine.
 * The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
 */
public data class AlertRuleLeafConditionArgs(
    public val containsAny: Output<List<String>>? = null,
    public val equals: Output<String>? = null,
    public val `field`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.AlertRuleLeafConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.AlertRuleLeafConditionArgs =
        com.pulumi.azurenative.insights.inputs.AlertRuleLeafConditionArgs.builder()
            .containsAny(containsAny?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .equals_(equals?.applyValue({ args0 -> args0 }))
            .`field`(`field`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertRuleLeafConditionArgs].
 */
@PulumiTagMarker
public class AlertRuleLeafConditionArgsBuilder internal constructor() {
    private var containsAny: Output<List<String>>? = null

    private var equals: Output<String>? = null

    private var `field`: Output<String>? = null

    /**
     * @param value The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met.
     */
    @JvmName("memmdptjefbvkxkn")
    public suspend fun containsAny(`value`: Output<List<String>>) {
        this.containsAny = value
    }

    @JvmName("hocaybtmdguceoxf")
    public suspend fun containsAny(vararg values: Output<String>) {
        this.containsAny = Output.all(values.asList())
    }

    /**
     * @param values The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met.
     */
    @JvmName("gijgtadlbdekdtbq")
    public suspend fun containsAny(values: List<Output<String>>) {
        this.containsAny = Output.all(values)
    }

    /**
     * @param value The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met.
     */
    @JvmName("jvqxfbouhinycvwx")
    public suspend fun equals(`value`: Output<String>) {
        this.equals = value
    }

    /**
     * @param value The name of the Activity Log event's field that this condition will examine.
     * The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
     */
    @JvmName("pdecpjcpddjuqwal")
    public suspend fun `field`(`value`: Output<String>) {
        this.`field` = value
    }

    /**
     * @param value The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met.
     */
    @JvmName("bkqwfgljljnxlyrn")
    public suspend fun containsAny(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containsAny = mapped
    }

    /**
     * @param values The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met.
     */
    @JvmName("lmkyyvaaklhqmnrb")
    public suspend fun containsAny(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containsAny = mapped
    }

    /**
     * @param value The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met.
     */
    @JvmName("rpxrcgslospkulus")
    public suspend fun equals(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.equals = mapped
    }

    /**
     * @param value The name of the Activity Log event's field that this condition will examine.
     * The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
     */
    @JvmName("juqpyiefafmsjmdw")
    public suspend fun `field`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`field` = mapped
    }

    internal fun build(): AlertRuleLeafConditionArgs = AlertRuleLeafConditionArgs(
        containsAny = containsAny,
        equals = equals,
        `field` = `field`,
    )
}
