@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.ApplicationInsightsComponentDataVolumeCapArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An Application Insights component daily data volume cap
 * @property cap Daily data volume cap in GB.
 * @property stopSendNotificationWhenHitCap Do not send a notification email when the daily data volume cap is met.
 * @property stopSendNotificationWhenHitThreshold Reserved, not used for now.
 * @property warningThreshold Reserved, not used for now.
 */
public data class ApplicationInsightsComponentDataVolumeCapArgs(
    public val cap: Output<Double>? = null,
    public val stopSendNotificationWhenHitCap: Output<Boolean>? = null,
    public val stopSendNotificationWhenHitThreshold: Output<Boolean>? = null,
    public val warningThreshold: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.insights.inputs.ApplicationInsightsComponentDataVolumeCapArgs> {
    override fun toJava():
        com.pulumi.azurenative.insights.inputs.ApplicationInsightsComponentDataVolumeCapArgs =
        com.pulumi.azurenative.insights.inputs.ApplicationInsightsComponentDataVolumeCapArgs.builder()
            .cap(cap?.applyValue({ args0 -> args0 }))
            .stopSendNotificationWhenHitCap(stopSendNotificationWhenHitCap?.applyValue({ args0 -> args0 }))
            .stopSendNotificationWhenHitThreshold(
                stopSendNotificationWhenHitThreshold?.applyValue({ args0 ->
                    args0
                }),
            )
            .warningThreshold(warningThreshold?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationInsightsComponentDataVolumeCapArgs].
 */
@PulumiTagMarker
public class ApplicationInsightsComponentDataVolumeCapArgsBuilder internal constructor() {
    private var cap: Output<Double>? = null

    private var stopSendNotificationWhenHitCap: Output<Boolean>? = null

    private var stopSendNotificationWhenHitThreshold: Output<Boolean>? = null

    private var warningThreshold: Output<Int>? = null

    /**
     * @param value Daily data volume cap in GB.
     */
    @JvmName("csqgydggmeouamxm")
    public suspend fun cap(`value`: Output<Double>) {
        this.cap = value
    }

    /**
     * @param value Do not send a notification email when the daily data volume cap is met.
     */
    @JvmName("nmkihtunedfjkvby")
    public suspend fun stopSendNotificationWhenHitCap(`value`: Output<Boolean>) {
        this.stopSendNotificationWhenHitCap = value
    }

    /**
     * @param value Reserved, not used for now.
     */
    @JvmName("wbkmffwnlwxjotxm")
    public suspend fun stopSendNotificationWhenHitThreshold(`value`: Output<Boolean>) {
        this.stopSendNotificationWhenHitThreshold = value
    }

    /**
     * @param value Reserved, not used for now.
     */
    @JvmName("tndipmqwofqkdtxv")
    public suspend fun warningThreshold(`value`: Output<Int>) {
        this.warningThreshold = value
    }

    /**
     * @param value Daily data volume cap in GB.
     */
    @JvmName("rlrmcaerwjlqndnh")
    public suspend fun cap(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cap = mapped
    }

    /**
     * @param value Do not send a notification email when the daily data volume cap is met.
     */
    @JvmName("xffytjgkodpalaeu")
    public suspend fun stopSendNotificationWhenHitCap(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stopSendNotificationWhenHitCap = mapped
    }

    /**
     * @param value Reserved, not used for now.
     */
    @JvmName("tfhtwkrtxoewrxjs")
    public suspend fun stopSendNotificationWhenHitThreshold(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stopSendNotificationWhenHitThreshold = mapped
    }

    /**
     * @param value Reserved, not used for now.
     */
    @JvmName("kfolddjjysggoagi")
    public suspend fun warningThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.warningThreshold = mapped
    }

    internal fun build(): ApplicationInsightsComponentDataVolumeCapArgs =
        ApplicationInsightsComponentDataVolumeCapArgs(
            cap = cap,
            stopSendNotificationWhenHitCap = stopSendNotificationWhenHitCap,
            stopSendNotificationWhenHitThreshold = stopSendNotificationWhenHitThreshold,
            warningThreshold = warningThreshold,
        )
}
