@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.AzureAppPushReceiverArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Azure mobile App push notification receiver.
 * @property emailAddress The email address registered for the Azure mobile app.
 * @property name The name of the Azure mobile app push receiver. Names must be unique across all receivers within a tenant action group.
 */
public data class AzureAppPushReceiverArgs(
    public val emailAddress: Output<String>,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.AzureAppPushReceiverArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.AzureAppPushReceiverArgs =
        com.pulumi.azurenative.insights.inputs.AzureAppPushReceiverArgs.builder()
            .emailAddress(emailAddress.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureAppPushReceiverArgs].
 */
@PulumiTagMarker
public class AzureAppPushReceiverArgsBuilder internal constructor() {
    private var emailAddress: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The email address registered for the Azure mobile app.
     */
    @JvmName("ibofaqitsooywjrm")
    public suspend fun emailAddress(`value`: Output<String>) {
        this.emailAddress = value
    }

    /**
     * @param value The name of the Azure mobile app push receiver. Names must be unique across all receivers within a tenant action group.
     */
    @JvmName("maqjeboogsmgwkvh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The email address registered for the Azure mobile app.
     */
    @JvmName("fklspdxencjxctyx")
    public suspend fun emailAddress(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emailAddress = mapped
    }

    /**
     * @param value The name of the Azure mobile app push receiver. Names must be unique across all receivers within a tenant action group.
     */
    @JvmName("crhyilytlqmetoju")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): AzureAppPushReceiverArgs = AzureAppPushReceiverArgs(
        emailAddress = emailAddress ?: throw PulumiNullFieldException("emailAddress"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
