@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.DestinationsSpecAzureMonitorMetricsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure Monitor Metrics destination.
 * @property name A friendly name for the destination.
 * This name should be unique across all destinations (regardless of type) within the data collection rule.
 */
public data class DestinationsSpecAzureMonitorMetricsArgs(
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.insights.inputs.DestinationsSpecAzureMonitorMetricsArgs> {
    override fun toJava():
        com.pulumi.azurenative.insights.inputs.DestinationsSpecAzureMonitorMetricsArgs =
        com.pulumi.azurenative.insights.inputs.DestinationsSpecAzureMonitorMetricsArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DestinationsSpecAzureMonitorMetricsArgs].
 */
@PulumiTagMarker
public class DestinationsSpecAzureMonitorMetricsArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value A friendly name for the destination.
     * This name should be unique across all destinations (regardless of type) within the data collection rule.
     */
    @JvmName("ilunfohjeappwwce")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A friendly name for the destination.
     * This name should be unique across all destinations (regardless of type) within the data collection rule.
     */
    @JvmName("dvpyhhkgffqoawxj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): DestinationsSpecAzureMonitorMetricsArgs =
        DestinationsSpecAzureMonitorMetricsArgs(
            name = name,
        )
}
