@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.DynamicThresholdFailingPeriodsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The minimum number of violations required within the selected lookback time window required to raise an alert.
 * @property minFailingPeriodsToAlert The number of violations to trigger an alert. Should be smaller or equal to numberOfEvaluationPeriods.
 * @property numberOfEvaluationPeriods The number of aggregated lookback points. The lookback time window is calculated based on the aggregation granularity (windowSize) and the selected number of aggregated points.
 */
public data class DynamicThresholdFailingPeriodsArgs(
    public val minFailingPeriodsToAlert: Output<Double>,
    public val numberOfEvaluationPeriods: Output<Double>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.DynamicThresholdFailingPeriodsArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.DynamicThresholdFailingPeriodsArgs =
        com.pulumi.azurenative.insights.inputs.DynamicThresholdFailingPeriodsArgs.builder()
            .minFailingPeriodsToAlert(minFailingPeriodsToAlert.applyValue({ args0 -> args0 }))
            .numberOfEvaluationPeriods(numberOfEvaluationPeriods.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DynamicThresholdFailingPeriodsArgs].
 */
@PulumiTagMarker
public class DynamicThresholdFailingPeriodsArgsBuilder internal constructor() {
    private var minFailingPeriodsToAlert: Output<Double>? = null

    private var numberOfEvaluationPeriods: Output<Double>? = null

    /**
     * @param value The number of violations to trigger an alert. Should be smaller or equal to numberOfEvaluationPeriods.
     */
    @JvmName("anytxvxmwstetoey")
    public suspend fun minFailingPeriodsToAlert(`value`: Output<Double>) {
        this.minFailingPeriodsToAlert = value
    }

    /**
     * @param value The number of aggregated lookback points. The lookback time window is calculated based on the aggregation granularity (windowSize) and the selected number of aggregated points.
     */
    @JvmName("jjkrljacnfrylaqm")
    public suspend fun numberOfEvaluationPeriods(`value`: Output<Double>) {
        this.numberOfEvaluationPeriods = value
    }

    /**
     * @param value The number of violations to trigger an alert. Should be smaller or equal to numberOfEvaluationPeriods.
     */
    @JvmName("ntlgcylvdatwllid")
    public suspend fun minFailingPeriodsToAlert(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minFailingPeriodsToAlert = mapped
    }

    /**
     * @param value The number of aggregated lookback points. The lookback time window is calculated based on the aggregation granularity (windowSize) and the selected number of aggregated points.
     */
    @JvmName("feubyerqnthuuxie")
    public suspend fun numberOfEvaluationPeriods(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.numberOfEvaluationPeriods = mapped
    }

    internal fun build(): DynamicThresholdFailingPeriodsArgs = DynamicThresholdFailingPeriodsArgs(
        minFailingPeriodsToAlert = minFailingPeriodsToAlert ?: throw
            PulumiNullFieldException("minFailingPeriodsToAlert"),
        numberOfEvaluationPeriods = numberOfEvaluationPeriods ?: throw
            PulumiNullFieldException("numberOfEvaluationPeriods"),
    )
}
