@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.EtwEventConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property filter
 * @property id
 * @property name
 */
public data class EtwEventConfigurationArgs(
    public val filter: Output<String>? = null,
    public val id: Output<Int>,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.EtwEventConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.EtwEventConfigurationArgs =
        com.pulumi.azurenative.insights.inputs.EtwEventConfigurationArgs.builder()
            .filter(filter?.applyValue({ args0 -> args0 }))
            .id(id.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EtwEventConfigurationArgs].
 */
@PulumiTagMarker
public class EtwEventConfigurationArgsBuilder internal constructor() {
    private var filter: Output<String>? = null

    private var id: Output<Int>? = null

    private var name: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("vbbfyquktutnnnle")
    public suspend fun filter(`value`: Output<String>) {
        this.filter = value
    }

    /**
     * @param value
     */
    @JvmName("qxyaakocjgdogxam")
    public suspend fun id(`value`: Output<Int>) {
        this.id = value
    }

    /**
     * @param value
     */
    @JvmName("tqhrkekyeasambay")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("dlsiavsbjujdenja")
    public suspend fun filter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param value
     */
    @JvmName("beimcplfknxcbipa")
    public suspend fun id(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value
     */
    @JvmName("lsyskyhkruwjqqid")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): EtwEventConfigurationArgs = EtwEventConfigurationArgs(
        filter = filter,
        id = id ?: throw PulumiNullFieldException("id"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
