@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.EventLogConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property filter
 * @property logName
 */
public data class EventLogConfigurationArgs(
    public val filter: Output<String>? = null,
    public val logName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.EventLogConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.EventLogConfigurationArgs =
        com.pulumi.azurenative.insights.inputs.EventLogConfigurationArgs.builder()
            .filter(filter?.applyValue({ args0 -> args0 }))
            .logName(logName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventLogConfigurationArgs].
 */
@PulumiTagMarker
public class EventLogConfigurationArgsBuilder internal constructor() {
    private var filter: Output<String>? = null

    private var logName: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("eoyqpuiymyjbqhrp")
    public suspend fun filter(`value`: Output<String>) {
        this.filter = value
    }

    /**
     * @param value
     */
    @JvmName("yieimdewscsrsvei")
    public suspend fun logName(`value`: Output<String>) {
        this.logName = value
    }

    /**
     * @param value
     */
    @JvmName("mudegnwdcechdcmj")
    public suspend fun filter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param value
     */
    @JvmName("hyyiweflmsdmlqtr")
    public suspend fun logName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logName = mapped
    }

    internal fun build(): EventLogConfigurationArgs = EventLogConfigurationArgs(
        filter = filter,
        logName = logName ?: throw PulumiNullFieldException("logName"),
    )
}
