@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.GetLogProfilePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property logProfileName The name of the log profile.
 */
public data class GetLogProfilePlainArgs(
    public val logProfileName: String,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.GetLogProfilePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.GetLogProfilePlainArgs =
        com.pulumi.azurenative.insights.inputs.GetLogProfilePlainArgs.builder()
            .logProfileName(logProfileName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLogProfilePlainArgs].
 */
@PulumiTagMarker
public class GetLogProfilePlainArgsBuilder internal constructor() {
    private var logProfileName: String? = null

    /**
     * @param value The name of the log profile.
     */
    @JvmName("hhcamgdivmlmmmdi")
    public suspend fun logProfileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.logProfileName = mapped
    }

    internal fun build(): GetLogProfilePlainArgs = GetLogProfilePlainArgs(
        logProfileName = logProfileName ?: throw PulumiNullFieldException("logProfileName"),
    )
}
