@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.IisLogsDataSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Enables IIS logs to be collected by this data collection rule.
 * @property logDirectories Absolute paths file location
 * @property name A friendly name for the data source.
 * This name should be unique across all data sources (regardless of type) within the data collection rule.
 * @property streams IIS streams
 */
public data class IisLogsDataSourceArgs(
    public val logDirectories: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val streams: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.IisLogsDataSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.IisLogsDataSourceArgs =
        com.pulumi.azurenative.insights.inputs.IisLogsDataSourceArgs.builder()
            .logDirectories(logDirectories?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .streams(streams.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [IisLogsDataSourceArgs].
 */
@PulumiTagMarker
public class IisLogsDataSourceArgsBuilder internal constructor() {
    private var logDirectories: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var streams: Output<List<String>>? = null

    /**
     * @param value Absolute paths file location
     */
    @JvmName("xskunffwloaenchh")
    public suspend fun logDirectories(`value`: Output<List<String>>) {
        this.logDirectories = value
    }

    @JvmName("wldcijxkbqoowbsx")
    public suspend fun logDirectories(vararg values: Output<String>) {
        this.logDirectories = Output.all(values.asList())
    }

    /**
     * @param values Absolute paths file location
     */
    @JvmName("crftlwcxccnqstts")
    public suspend fun logDirectories(values: List<Output<String>>) {
        this.logDirectories = Output.all(values)
    }

    /**
     * @param value A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     */
    @JvmName("divwmsnwerfhifmf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value IIS streams
     */
    @JvmName("ibtabqqvgsunifob")
    public suspend fun streams(`value`: Output<List<String>>) {
        this.streams = value
    }

    @JvmName("xpueprmnxyuaavwu")
    public suspend fun streams(vararg values: Output<String>) {
        this.streams = Output.all(values.asList())
    }

    /**
     * @param values IIS streams
     */
    @JvmName("xhrsalwavldkahsh")
    public suspend fun streams(values: List<Output<String>>) {
        this.streams = Output.all(values)
    }

    /**
     * @param value Absolute paths file location
     */
    @JvmName("jpmophtuvcwgmkhl")
    public suspend fun logDirectories(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logDirectories = mapped
    }

    /**
     * @param values Absolute paths file location
     */
    @JvmName("ggvnvplbqfpgutdu")
    public suspend fun logDirectories(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logDirectories = mapped
    }

    /**
     * @param value A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     */
    @JvmName("psemxjflvcoaxvcq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value IIS streams
     */
    @JvmName("wjodlaskvmquwopv")
    public suspend fun streams(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streams = mapped
    }

    /**
     * @param values IIS streams
     */
    @JvmName("bxvjkvotuqrwegqo")
    public suspend fun streams(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streams = mapped
    }

    internal fun build(): IisLogsDataSourceArgs = IisLogsDataSourceArgs(
        logDirectories = logDirectories,
        name = name,
        streams = streams ?: throw PulumiNullFieldException("streams"),
    )
}
