@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.ItsmReceiverArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An Itsm receiver.
 * @property connectionId Unique identification of ITSM connection among multiple defined in above workspace.
 * @property name The name of the Itsm receiver. Names must be unique across all receivers within an action group.
 * @property region Region in which workspace resides. Supported values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'
 * @property ticketConfiguration JSON blob for the configurations of the ITSM action. CreateMultipleWorkItems option will be part of this blob as well.
 * @property workspaceId OMS LA instance identifier.
 */
public data class ItsmReceiverArgs(
    public val connectionId: Output<String>,
    public val name: Output<String>,
    public val region: Output<String>,
    public val ticketConfiguration: Output<String>,
    public val workspaceId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.ItsmReceiverArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.ItsmReceiverArgs =
        com.pulumi.azurenative.insights.inputs.ItsmReceiverArgs.builder()
            .connectionId(connectionId.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .region(region.applyValue({ args0 -> args0 }))
            .ticketConfiguration(ticketConfiguration.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ItsmReceiverArgs].
 */
@PulumiTagMarker
public class ItsmReceiverArgsBuilder internal constructor() {
    private var connectionId: Output<String>? = null

    private var name: Output<String>? = null

    private var region: Output<String>? = null

    private var ticketConfiguration: Output<String>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value Unique identification of ITSM connection among multiple defined in above workspace.
     */
    @JvmName("qajtnrirgfxofaxe")
    public suspend fun connectionId(`value`: Output<String>) {
        this.connectionId = value
    }

    /**
     * @param value The name of the Itsm receiver. Names must be unique across all receivers within an action group.
     */
    @JvmName("veicnnytilijldxo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Region in which workspace resides. Supported values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'
     */
    @JvmName("vqfoldgivcnetvwc")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value JSON blob for the configurations of the ITSM action. CreateMultipleWorkItems option will be part of this blob as well.
     */
    @JvmName("iuuhwucoplsuaaqk")
    public suspend fun ticketConfiguration(`value`: Output<String>) {
        this.ticketConfiguration = value
    }

    /**
     * @param value OMS LA instance identifier.
     */
    @JvmName("pxpmnsyeehnxidwe")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value Unique identification of ITSM connection among multiple defined in above workspace.
     */
    @JvmName("wderiexkibabbcop")
    public suspend fun connectionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionId = mapped
    }

    /**
     * @param value The name of the Itsm receiver. Names must be unique across all receivers within an action group.
     */
    @JvmName("ijojrsebwbtfyhce")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Region in which workspace resides. Supported values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'
     */
    @JvmName("fxgjxrkvlbkkfpqd")
    public suspend fun region(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value JSON blob for the configurations of the ITSM action. CreateMultipleWorkItems option will be part of this blob as well.
     */
    @JvmName("ifmmkiqnhdrmafvt")
    public suspend fun ticketConfiguration(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ticketConfiguration = mapped
    }

    /**
     * @param value OMS LA instance identifier.
     */
    @JvmName("nqysdqqehruyavqo")
    public suspend fun workspaceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): ItsmReceiverArgs = ItsmReceiverArgs(
        connectionId = connectionId ?: throw PulumiNullFieldException("connectionId"),
        name = name ?: throw PulumiNullFieldException("name"),
        region = region ?: throw PulumiNullFieldException("region"),
        ticketConfiguration = ticketConfiguration ?: throw PulumiNullFieldException("ticketConfiguration"),
        workspaceId = workspaceId ?: throw PulumiNullFieldException("workspaceId"),
    )
}
