@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.LocationThresholdRuleConditionArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A rule condition based on a certain number of locations failing.
 * @property dataSource the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
 * @property failedLocationCount the number of locations that must fail to activate the alert.
 * @property odataType specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
 * Expected value is 'Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition'.
 * @property windowSize the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
 */
public data class LocationThresholdRuleConditionArgs(
    public val dataSource:
    Output<Either<RuleManagementEventDataSourceArgs, RuleMetricDataSourceArgs>>? = null,
    public val failedLocationCount: Output<Int>,
    public val odataType: Output<String>,
    public val windowSize: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.LocationThresholdRuleConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.LocationThresholdRuleConditionArgs =
        com.pulumi.azurenative.insights.inputs.LocationThresholdRuleConditionArgs.builder()
            .dataSource(
                dataSource?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .failedLocationCount(failedLocationCount.applyValue({ args0 -> args0 }))
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .windowSize(windowSize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LocationThresholdRuleConditionArgs].
 */
@PulumiTagMarker
public class LocationThresholdRuleConditionArgsBuilder internal constructor() {
    private var dataSource:
        Output<Either<RuleManagementEventDataSourceArgs, RuleMetricDataSourceArgs>>? = null

    private var failedLocationCount: Output<Int>? = null

    private var odataType: Output<String>? = null

    private var windowSize: Output<String>? = null

    /**
     * @param value the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
     */
    @JvmName("yhbbhofhottkchgr")
    public suspend
    fun dataSource(`value`: Output<Either<RuleManagementEventDataSourceArgs, RuleMetricDataSourceArgs>>) {
        this.dataSource = value
    }

    /**
     * @param value the number of locations that must fail to activate the alert.
     */
    @JvmName("suyiutsdkjsrhhiy")
    public suspend fun failedLocationCount(`value`: Output<Int>) {
        this.failedLocationCount = value
    }

    /**
     * @param value specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
     * Expected value is 'Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition'.
     */
    @JvmName("mdqdgmafxybrjaap")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
     */
    @JvmName("wyxpixutgsdbltgp")
    public suspend fun windowSize(`value`: Output<String>) {
        this.windowSize = value
    }

    /**
     * @param value the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
     */
    @JvmName("lnrohgqndiqsbiox")
    public suspend
    fun dataSource(`value`: Either<RuleManagementEventDataSourceArgs, RuleMetricDataSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSource = mapped
    }

    /**
     * @param value the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
     */
    @JvmName("mpsmqmmwhhxgniri")
    public fun dataSource(`value`: RuleManagementEventDataSourceArgs) {
        val toBeMapped = Either.ofLeft<RuleManagementEventDataSourceArgs,
            RuleMetricDataSourceArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSource = mapped
    }

    /**
     * @param value the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
     */
    @JvmName("arpoknktyrphsruw")
    public fun dataSource(`value`: RuleMetricDataSourceArgs) {
        val toBeMapped = Either.ofRight<RuleManagementEventDataSourceArgs,
            RuleMetricDataSourceArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSource = mapped
    }

    /**
     * @param value the number of locations that must fail to activate the alert.
     */
    @JvmName("sgnjuadpjkesrrfn")
    public suspend fun failedLocationCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failedLocationCount = mapped
    }

    /**
     * @param value specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
     * Expected value is 'Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition'.
     */
    @JvmName("nvxunyjivhouenwk")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
     */
    @JvmName("nnofdknvkqnbjcba")
    public suspend fun windowSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowSize = mapped
    }

    internal fun build(): LocationThresholdRuleConditionArgs = LocationThresholdRuleConditionArgs(
        dataSource = dataSource,
        failedLocationCount = failedLocationCount ?: throw PulumiNullFieldException("failedLocationCount"),
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        windowSize = windowSize,
    )
}
