@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.LogFilesDataSourceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The log files specific settings.
 * @property text Text settings
 */
public data class LogFilesDataSourceSettingsArgs(
    public val text: Output<LogFileSettingsTextArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.LogFilesDataSourceSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.LogFilesDataSourceSettingsArgs =
        com.pulumi.azurenative.insights.inputs.LogFilesDataSourceSettingsArgs.builder()
            .text(text?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [LogFilesDataSourceSettingsArgs].
 */
@PulumiTagMarker
public class LogFilesDataSourceSettingsArgsBuilder internal constructor() {
    private var text: Output<LogFileSettingsTextArgs>? = null

    /**
     * @param value Text settings
     */
    @JvmName("nqhnaftpwoceqrfd")
    public suspend fun text(`value`: Output<LogFileSettingsTextArgs>) {
        this.text = value
    }

    /**
     * @param value Text settings
     */
    @JvmName("arpfecabmliwxgsv")
    public suspend fun text(`value`: LogFileSettingsTextArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.text = mapped
    }

    /**
     * @param argument Text settings
     */
    @JvmName("oytpomqnskraualu")
    public suspend fun text(argument: suspend LogFileSettingsTextArgsBuilder.() -> Unit) {
        val toBeMapped = LogFileSettingsTextArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.text = mapped
    }

    internal fun build(): LogFilesDataSourceSettingsArgs = LogFilesDataSourceSettingsArgs(
        text = text,
    )
}
