@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.MetricAlertMultipleResourceMultipleMetricCriteriaArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Specifies the metric alert criteria for multiple resource that has multiple metric criteria.
 * @property allOf the list of multiple metric criteria for this 'all of' operation.
 * @property odataType specifies the type of the alert criteria.
 * Expected value is 'Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria'.
 */
public data class MetricAlertMultipleResourceMultipleMetricCriteriaArgs(
    public val allOf: Output<List<Either<DynamicMetricCriteriaArgs, MetricCriteriaArgs>>>? = null,
    public val odataType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.insights.inputs.MetricAlertMultipleResourceMultipleMetricCriteriaArgs> {
    override fun toJava():
        com.pulumi.azurenative.insights.inputs.MetricAlertMultipleResourceMultipleMetricCriteriaArgs =
        com.pulumi.azurenative.insights.inputs.MetricAlertMultipleResourceMultipleMetricCriteriaArgs.builder()
            .allOf(
                allOf?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0.let({ args0 -> args0.toJava() })
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MetricAlertMultipleResourceMultipleMetricCriteriaArgs].
 */
@PulumiTagMarker
public class MetricAlertMultipleResourceMultipleMetricCriteriaArgsBuilder internal constructor() {
    private var allOf: Output<List<Either<DynamicMetricCriteriaArgs, MetricCriteriaArgs>>>? = null

    private var odataType: Output<String>? = null

    /**
     * @param value the list of multiple metric criteria for this 'all of' operation.
     */
    @JvmName("jsfoyhwkbmmfqlhl")
    public suspend
    fun allOf(`value`: Output<List<Either<DynamicMetricCriteriaArgs, MetricCriteriaArgs>>>) {
        this.allOf = value
    }

    @JvmName("yyejpxpvutkdfnqf")
    public suspend fun allOf(
        vararg
        values: Output<Either<DynamicMetricCriteriaArgs, MetricCriteriaArgs>>,
    ) {
        this.allOf = Output.all(values.asList())
    }

    /**
     * @param values the list of multiple metric criteria for this 'all of' operation.
     */
    @JvmName("ntnbexuqddqksmxv")
    public suspend
    fun allOf(values: List<Output<Either<DynamicMetricCriteriaArgs, MetricCriteriaArgs>>>) {
        this.allOf = Output.all(values)
    }

    /**
     * @param value specifies the type of the alert criteria.
     * Expected value is 'Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria'.
     */
    @JvmName("pmscyhqyenwhlavh")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value the list of multiple metric criteria for this 'all of' operation.
     */
    @JvmName("rtgrsfgbxgcjjhfl")
    public suspend fun allOf(`value`: List<Either<DynamicMetricCriteriaArgs, MetricCriteriaArgs>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allOf = mapped
    }

    /**
     * @param values the list of multiple metric criteria for this 'all of' operation.
     */
    @JvmName("xbpyvnbibimchioi")
    public suspend fun allOf(vararg values: Either<DynamicMetricCriteriaArgs, MetricCriteriaArgs>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allOf = mapped
    }

    /**
     * @param value specifies the type of the alert criteria.
     * Expected value is 'Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria'.
     */
    @JvmName("ecaqbddywpfxcblr")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): MetricAlertMultipleResourceMultipleMetricCriteriaArgs =
        MetricAlertMultipleResourceMultipleMetricCriteriaArgs(
            allOf = allOf,
            odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        )
}
