@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.MetricTriggerArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.ComparisonOperationType
import com.pulumi.azurenative.insights.kotlin.enums.MetricStatisticType
import com.pulumi.azurenative.insights.kotlin.enums.TimeAggregationType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The trigger that results in a scaling action.
 * @property dimensions List of dimension conditions. For example: [{"DimensionName":"AppName","Operator":"Equals","Values":["App1"]},{"DimensionName":"Deployment","Operator":"Equals","Values":["default"]}].
 * @property dividePerInstance a value indicating whether metric should divide per instance.
 * @property metricName the name of the metric that defines what the rule monitors.
 * @property metricNamespace the namespace of the metric that defines what the rule monitors.
 * @property metricResourceLocation the location of the resource the rule monitors.
 * @property metricResourceUri the resource identifier of the resource the rule monitors.
 * @property operator the operator that is used to compare the metric data and the threshold.
 * @property statistic the metric statistic type. How the metrics from multiple instances are combined.
 * @property threshold the threshold of the metric that triggers the scale action.
 * @property timeAggregation time aggregation type. How the data that is collected should be combined over time. The default value is Average.
 * @property timeGrain the granularity of metrics the rule monitors. Must be one of the predefined values returned from metric definitions for the metric. Must be between 12 hours and 1 minute.
 * @property timeWindow the range of time in which instance data is collected. This value must be greater than the delay in metric collection, which can vary from resource-to-resource. Must be between 12 hours and 5 minutes.
 */
public data class MetricTriggerArgs(
    public val dimensions: Output<List<ScaleRuleMetricDimensionArgs>>? = null,
    public val dividePerInstance: Output<Boolean>? = null,
    public val metricName: Output<String>,
    public val metricNamespace: Output<String>? = null,
    public val metricResourceLocation: Output<String>? = null,
    public val metricResourceUri: Output<String>,
    public val `operator`: Output<ComparisonOperationType>,
    public val statistic: Output<MetricStatisticType>,
    public val threshold: Output<Double>,
    public val timeAggregation: Output<TimeAggregationType>,
    public val timeGrain: Output<String>,
    public val timeWindow: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.MetricTriggerArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.MetricTriggerArgs =
        com.pulumi.azurenative.insights.inputs.MetricTriggerArgs.builder()
            .dimensions(
                dimensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .dividePerInstance(dividePerInstance?.applyValue({ args0 -> args0 }))
            .metricName(metricName.applyValue({ args0 -> args0 }))
            .metricNamespace(metricNamespace?.applyValue({ args0 -> args0 }))
            .metricResourceLocation(metricResourceLocation?.applyValue({ args0 -> args0 }))
            .metricResourceUri(metricResourceUri.applyValue({ args0 -> args0 }))
            .`operator`(`operator`.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .statistic(statistic.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .threshold(threshold.applyValue({ args0 -> args0 }))
            .timeAggregation(timeAggregation.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeGrain(timeGrain.applyValue({ args0 -> args0 }))
            .timeWindow(timeWindow.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MetricTriggerArgs].
 */
@PulumiTagMarker
public class MetricTriggerArgsBuilder internal constructor() {
    private var dimensions: Output<List<ScaleRuleMetricDimensionArgs>>? = null

    private var dividePerInstance: Output<Boolean>? = null

    private var metricName: Output<String>? = null

    private var metricNamespace: Output<String>? = null

    private var metricResourceLocation: Output<String>? = null

    private var metricResourceUri: Output<String>? = null

    private var `operator`: Output<ComparisonOperationType>? = null

    private var statistic: Output<MetricStatisticType>? = null

    private var threshold: Output<Double>? = null

    private var timeAggregation: Output<TimeAggregationType>? = null

    private var timeGrain: Output<String>? = null

    private var timeWindow: Output<String>? = null

    /**
     * @param value List of dimension conditions. For example: [{"DimensionName":"AppName","Operator":"Equals","Values":["App1"]},{"DimensionName":"Deployment","Operator":"Equals","Values":["default"]}].
     */
    @JvmName("tqgcwyekmswernhf")
    public suspend fun dimensions(`value`: Output<List<ScaleRuleMetricDimensionArgs>>) {
        this.dimensions = value
    }

    @JvmName("scoopipidjikkhcd")
    public suspend fun dimensions(vararg values: Output<ScaleRuleMetricDimensionArgs>) {
        this.dimensions = Output.all(values.asList())
    }

    /**
     * @param values List of dimension conditions. For example: [{"DimensionName":"AppName","Operator":"Equals","Values":["App1"]},{"DimensionName":"Deployment","Operator":"Equals","Values":["default"]}].
     */
    @JvmName("yynnephacjbhngdv")
    public suspend fun dimensions(values: List<Output<ScaleRuleMetricDimensionArgs>>) {
        this.dimensions = Output.all(values)
    }

    /**
     * @param value a value indicating whether metric should divide per instance.
     */
    @JvmName("hvfdgcjvscinwxdc")
    public suspend fun dividePerInstance(`value`: Output<Boolean>) {
        this.dividePerInstance = value
    }

    /**
     * @param value the name of the metric that defines what the rule monitors.
     */
    @JvmName("xefmdixsequgbodr")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value the namespace of the metric that defines what the rule monitors.
     */
    @JvmName("jejyvevwxoihmcnp")
    public suspend fun metricNamespace(`value`: Output<String>) {
        this.metricNamespace = value
    }

    /**
     * @param value the location of the resource the rule monitors.
     */
    @JvmName("uhrbunyneafkbkir")
    public suspend fun metricResourceLocation(`value`: Output<String>) {
        this.metricResourceLocation = value
    }

    /**
     * @param value the resource identifier of the resource the rule monitors.
     */
    @JvmName("hpwwfkcbenmrucmw")
    public suspend fun metricResourceUri(`value`: Output<String>) {
        this.metricResourceUri = value
    }

    /**
     * @param value the operator that is used to compare the metric data and the threshold.
     */
    @JvmName("bmpqjtpwufrhbykh")
    public suspend fun `operator`(`value`: Output<ComparisonOperationType>) {
        this.`operator` = value
    }

    /**
     * @param value the metric statistic type. How the metrics from multiple instances are combined.
     */
    @JvmName("pwkcsvoadraihbpu")
    public suspend fun statistic(`value`: Output<MetricStatisticType>) {
        this.statistic = value
    }

    /**
     * @param value the threshold of the metric that triggers the scale action.
     */
    @JvmName("uttbkghjkcnstcoh")
    public suspend fun threshold(`value`: Output<Double>) {
        this.threshold = value
    }

    /**
     * @param value time aggregation type. How the data that is collected should be combined over time. The default value is Average.
     */
    @JvmName("anodnyirollvuqlb")
    public suspend fun timeAggregation(`value`: Output<TimeAggregationType>) {
        this.timeAggregation = value
    }

    /**
     * @param value the granularity of metrics the rule monitors. Must be one of the predefined values returned from metric definitions for the metric. Must be between 12 hours and 1 minute.
     */
    @JvmName("idlworrfkteccpbj")
    public suspend fun timeGrain(`value`: Output<String>) {
        this.timeGrain = value
    }

    /**
     * @param value the range of time in which instance data is collected. This value must be greater than the delay in metric collection, which can vary from resource-to-resource. Must be between 12 hours and 5 minutes.
     */
    @JvmName("vtpmidktkfgvrysf")
    public suspend fun timeWindow(`value`: Output<String>) {
        this.timeWindow = value
    }

    /**
     * @param value List of dimension conditions. For example: [{"DimensionName":"AppName","Operator":"Equals","Values":["App1"]},{"DimensionName":"Deployment","Operator":"Equals","Values":["default"]}].
     */
    @JvmName("xoclsjyqmkmsfcgo")
    public suspend fun dimensions(`value`: List<ScaleRuleMetricDimensionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param argument List of dimension conditions. For example: [{"DimensionName":"AppName","Operator":"Equals","Values":["App1"]},{"DimensionName":"Deployment","Operator":"Equals","Values":["default"]}].
     */
    @JvmName("dcbtkmrnhmtnrmcb")
    public suspend
    fun dimensions(argument: List<suspend ScaleRuleMetricDimensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScaleRuleMetricDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument List of dimension conditions. For example: [{"DimensionName":"AppName","Operator":"Equals","Values":["App1"]},{"DimensionName":"Deployment","Operator":"Equals","Values":["default"]}].
     */
    @JvmName("wthrmlvkuosihebn")
    public suspend fun dimensions(
        vararg
        argument: suspend ScaleRuleMetricDimensionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ScaleRuleMetricDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument List of dimension conditions. For example: [{"DimensionName":"AppName","Operator":"Equals","Values":["App1"]},{"DimensionName":"Deployment","Operator":"Equals","Values":["default"]}].
     */
    @JvmName("qaqrpsmeortvxdrn")
    public suspend fun dimensions(argument: suspend ScaleRuleMetricDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ScaleRuleMetricDimensionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param values List of dimension conditions. For example: [{"DimensionName":"AppName","Operator":"Equals","Values":["App1"]},{"DimensionName":"Deployment","Operator":"Equals","Values":["default"]}].
     */
    @JvmName("orhccbnfadrfcvrc")
    public suspend fun dimensions(vararg values: ScaleRuleMetricDimensionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param value a value indicating whether metric should divide per instance.
     */
    @JvmName("qbhpqtqybuspeivv")
    public suspend fun dividePerInstance(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dividePerInstance = mapped
    }

    /**
     * @param value the name of the metric that defines what the rule monitors.
     */
    @JvmName("paouarxsewoocgdi")
    public suspend fun metricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value the namespace of the metric that defines what the rule monitors.
     */
    @JvmName("nicdqvsfyrlanelu")
    public suspend fun metricNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricNamespace = mapped
    }

    /**
     * @param value the location of the resource the rule monitors.
     */
    @JvmName("hgyrewjoklcscfhd")
    public suspend fun metricResourceLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricResourceLocation = mapped
    }

    /**
     * @param value the resource identifier of the resource the rule monitors.
     */
    @JvmName("rehpfuxpqljqatws")
    public suspend fun metricResourceUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricResourceUri = mapped
    }

    /**
     * @param value the operator that is used to compare the metric data and the threshold.
     */
    @JvmName("epxtjwxeukcdstpe")
    public suspend fun `operator`(`value`: ComparisonOperationType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value the metric statistic type. How the metrics from multiple instances are combined.
     */
    @JvmName("joxchwfgrcofjrep")
    public suspend fun statistic(`value`: MetricStatisticType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statistic = mapped
    }

    /**
     * @param value the threshold of the metric that triggers the scale action.
     */
    @JvmName("kdfsrguvxopstnio")
    public suspend fun threshold(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threshold = mapped
    }

    /**
     * @param value time aggregation type. How the data that is collected should be combined over time. The default value is Average.
     */
    @JvmName("vsicbxqrakhxjfil")
    public suspend fun timeAggregation(`value`: TimeAggregationType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeAggregation = mapped
    }

    /**
     * @param value the granularity of metrics the rule monitors. Must be one of the predefined values returned from metric definitions for the metric. Must be between 12 hours and 1 minute.
     */
    @JvmName("fapxsldjbtiyigyj")
    public suspend fun timeGrain(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeGrain = mapped
    }

    /**
     * @param value the range of time in which instance data is collected. This value must be greater than the delay in metric collection, which can vary from resource-to-resource. Must be between 12 hours and 5 minutes.
     */
    @JvmName("hepansxnmrxakrrw")
    public suspend fun timeWindow(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeWindow = mapped
    }

    internal fun build(): MetricTriggerArgs = MetricTriggerArgs(
        dimensions = dimensions,
        dividePerInstance = dividePerInstance,
        metricName = metricName ?: throw PulumiNullFieldException("metricName"),
        metricNamespace = metricNamespace,
        metricResourceLocation = metricResourceLocation,
        metricResourceUri = metricResourceUri ?: throw PulumiNullFieldException("metricResourceUri"),
        `operator` = `operator` ?: throw PulumiNullFieldException("operator"),
        statistic = statistic ?: throw PulumiNullFieldException("statistic"),
        threshold = threshold ?: throw PulumiNullFieldException("threshold"),
        timeAggregation = timeAggregation ?: throw PulumiNullFieldException("timeAggregation"),
        timeGrain = timeGrain ?: throw PulumiNullFieldException("timeGrain"),
        timeWindow = timeWindow ?: throw PulumiNullFieldException("timeWindow"),
    )
}
