@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.PrometheusForwarderDataSourceArgs.builder
import com.pulumi.azurenative.insights.kotlin.enums.KnownPrometheusForwarderDataSourceStreams
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Definition of Prometheus metrics forwarding configuration.
 * @property labelIncludeFilter The list of label inclusion filters in the form of label "name-value" pairs.
 * Currently only one label is supported: 'microsoft_metrics_include_label'.
 * Label values are matched case-insensitively.
 * @property name A friendly name for the data source.
 * This name should be unique across all data sources (regardless of type) within the data collection rule.
 * @property streams List of streams that this data source will be sent to.
 */
public data class PrometheusForwarderDataSourceArgs(
    public val labelIncludeFilter: Output<Map<String, String>>? = null,
    public val name: Output<String>? = null,
    public val streams: Output<List<Either<String, KnownPrometheusForwarderDataSourceStreams>>>? =
        null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.PrometheusForwarderDataSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.PrometheusForwarderDataSourceArgs =
        com.pulumi.azurenative.insights.inputs.PrometheusForwarderDataSourceArgs.builder()
            .labelIncludeFilter(
                labelIncludeFilter?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .streams(
                streams?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            ).build()
}

/**
 * Builder for [PrometheusForwarderDataSourceArgs].
 */
@PulumiTagMarker
public class PrometheusForwarderDataSourceArgsBuilder internal constructor() {
    private var labelIncludeFilter: Output<Map<String, String>>? = null

    private var name: Output<String>? = null

    private var streams: Output<List<Either<String, KnownPrometheusForwarderDataSourceStreams>>>? =
        null

    /**
     * @param value The list of label inclusion filters in the form of label "name-value" pairs.
     * Currently only one label is supported: 'microsoft_metrics_include_label'.
     * Label values are matched case-insensitively.
     */
    @JvmName("ssealmqokqbriklh")
    public suspend fun labelIncludeFilter(`value`: Output<Map<String, String>>) {
        this.labelIncludeFilter = value
    }

    /**
     * @param value A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     */
    @JvmName("kidkmsugscvgmhbl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of streams that this data source will be sent to.
     */
    @JvmName("iemtxllrmsulogun")
    public suspend
    fun streams(`value`: Output<List<Either<String, KnownPrometheusForwarderDataSourceStreams>>>) {
        this.streams = value
    }

    @JvmName("bupdqnwemvllanmh")
    public suspend fun streams(
        vararg
        values: Output<Either<String, KnownPrometheusForwarderDataSourceStreams>>,
    ) {
        this.streams = Output.all(values.asList())
    }

    /**
     * @param values List of streams that this data source will be sent to.
     */
    @JvmName("rqccltqhymjivxga")
    public suspend
    fun streams(values: List<Output<Either<String, KnownPrometheusForwarderDataSourceStreams>>>) {
        this.streams = Output.all(values)
    }

    /**
     * @param value The list of label inclusion filters in the form of label "name-value" pairs.
     * Currently only one label is supported: 'microsoft_metrics_include_label'.
     * Label values are matched case-insensitively.
     */
    @JvmName("pufjnhmpxfvmrahm")
    public suspend fun labelIncludeFilter(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labelIncludeFilter = mapped
    }

    /**
     * @param values The list of label inclusion filters in the form of label "name-value" pairs.
     * Currently only one label is supported: 'microsoft_metrics_include_label'.
     * Label values are matched case-insensitively.
     */
    @JvmName("ceyjnhwkfsbtxala")
    public fun labelIncludeFilter(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labelIncludeFilter = mapped
    }

    /**
     * @param value A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     */
    @JvmName("pujsnkamakkrvpvc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value List of streams that this data source will be sent to.
     */
    @JvmName("usaahqniepixfffv")
    public suspend
    fun streams(`value`: List<Either<String, KnownPrometheusForwarderDataSourceStreams>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streams = mapped
    }

    /**
     * @param values List of streams that this data source will be sent to.
     */
    @JvmName("dwjgqcgflrvvysbx")
    public suspend fun streams(
        vararg
        values: Either<String, KnownPrometheusForwarderDataSourceStreams>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streams = mapped
    }

    internal fun build(): PrometheusForwarderDataSourceArgs = PrometheusForwarderDataSourceArgs(
        labelIncludeFilter = labelIncludeFilter,
        name = name,
        streams = streams,
    )
}
