@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.RuleManagementEventDataSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A rule management event data source. The discriminator fields is always RuleManagementEventDataSource in this case.
 * @property claims the claims.
 * @property eventName the event name.
 * @property eventSource the event source.
 * @property legacyResourceId the legacy resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
 * @property level the level.
 * @property metricNamespace the namespace of the metric.
 * @property odataType specifies the type of data source. There are two types of rule data sources: RuleMetricDataSource and RuleManagementEventDataSource
 * Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource'.
 * @property operationName The name of the operation that should be checked for. If no name is provided, any operation will match.
 * @property resourceGroupName the resource group name.
 * @property resourceLocation the location of the resource.
 * @property resourceProviderName the resource provider name.
 * @property resourceUri the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
 * @property status The status of the operation that should be checked for. If no status is provided, any status will match.
 * @property subStatus the substatus.
 */
public data class RuleManagementEventDataSourceArgs(
    public val claims: Output<RuleManagementEventClaimsDataSourceArgs>? = null,
    public val eventName: Output<String>? = null,
    public val eventSource: Output<String>? = null,
    public val legacyResourceId: Output<String>? = null,
    public val level: Output<String>? = null,
    public val metricNamespace: Output<String>? = null,
    public val odataType: Output<String>,
    public val operationName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceLocation: Output<String>? = null,
    public val resourceProviderName: Output<String>? = null,
    public val resourceUri: Output<String>? = null,
    public val status: Output<String>? = null,
    public val subStatus: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.RuleManagementEventDataSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.RuleManagementEventDataSourceArgs =
        com.pulumi.azurenative.insights.inputs.RuleManagementEventDataSourceArgs.builder()
            .claims(claims?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .eventName(eventName?.applyValue({ args0 -> args0 }))
            .eventSource(eventSource?.applyValue({ args0 -> args0 }))
            .legacyResourceId(legacyResourceId?.applyValue({ args0 -> args0 }))
            .level(level?.applyValue({ args0 -> args0 }))
            .metricNamespace(metricNamespace?.applyValue({ args0 -> args0 }))
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .operationName(operationName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceLocation(resourceLocation?.applyValue({ args0 -> args0 }))
            .resourceProviderName(resourceProviderName?.applyValue({ args0 -> args0 }))
            .resourceUri(resourceUri?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .subStatus(subStatus?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleManagementEventDataSourceArgs].
 */
@PulumiTagMarker
public class RuleManagementEventDataSourceArgsBuilder internal constructor() {
    private var claims: Output<RuleManagementEventClaimsDataSourceArgs>? = null

    private var eventName: Output<String>? = null

    private var eventSource: Output<String>? = null

    private var legacyResourceId: Output<String>? = null

    private var level: Output<String>? = null

    private var metricNamespace: Output<String>? = null

    private var odataType: Output<String>? = null

    private var operationName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceLocation: Output<String>? = null

    private var resourceProviderName: Output<String>? = null

    private var resourceUri: Output<String>? = null

    private var status: Output<String>? = null

    private var subStatus: Output<String>? = null

    /**
     * @param value the claims.
     */
    @JvmName("gdhqbdnnxxcwyyeo")
    public suspend fun claims(`value`: Output<RuleManagementEventClaimsDataSourceArgs>) {
        this.claims = value
    }

    /**
     * @param value the event name.
     */
    @JvmName("mokbsnofrlehqvvc")
    public suspend fun eventName(`value`: Output<String>) {
        this.eventName = value
    }

    /**
     * @param value the event source.
     */
    @JvmName("lmetphknysrrcfbe")
    public suspend fun eventSource(`value`: Output<String>) {
        this.eventSource = value
    }

    /**
     * @param value the legacy resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
     */
    @JvmName("pudyvwuxykjopmjw")
    public suspend fun legacyResourceId(`value`: Output<String>) {
        this.legacyResourceId = value
    }

    /**
     * @param value the level.
     */
    @JvmName("auqlkwlvljxkrycl")
    public suspend fun level(`value`: Output<String>) {
        this.level = value
    }

    /**
     * @param value the namespace of the metric.
     */
    @JvmName("bppdveyonfqhqifu")
    public suspend fun metricNamespace(`value`: Output<String>) {
        this.metricNamespace = value
    }

    /**
     * @param value specifies the type of data source. There are two types of rule data sources: RuleMetricDataSource and RuleManagementEventDataSource
     * Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource'.
     */
    @JvmName("aebpjimbraivaiac")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The name of the operation that should be checked for. If no name is provided, any operation will match.
     */
    @JvmName("vxsgrrbewyhysftu")
    public suspend fun operationName(`value`: Output<String>) {
        this.operationName = value
    }

    /**
     * @param value the resource group name.
     */
    @JvmName("tenqjoshmhbsaeim")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value the location of the resource.
     */
    @JvmName("owyhfsqfpkdcusin")
    public suspend fun resourceLocation(`value`: Output<String>) {
        this.resourceLocation = value
    }

    /**
     * @param value the resource provider name.
     */
    @JvmName("ljqudhnrfmvutibt")
    public suspend fun resourceProviderName(`value`: Output<String>) {
        this.resourceProviderName = value
    }

    /**
     * @param value the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
     */
    @JvmName("ctdluxsxvuyolite")
    public suspend fun resourceUri(`value`: Output<String>) {
        this.resourceUri = value
    }

    /**
     * @param value The status of the operation that should be checked for. If no status is provided, any status will match.
     */
    @JvmName("siacavfnibgrlpco")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value the substatus.
     */
    @JvmName("cmetswtfocfajoct")
    public suspend fun subStatus(`value`: Output<String>) {
        this.subStatus = value
    }

    /**
     * @param value the claims.
     */
    @JvmName("ddfcwyjjmdewtkmu")
    public suspend fun claims(`value`: RuleManagementEventClaimsDataSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.claims = mapped
    }

    /**
     * @param argument the claims.
     */
    @JvmName("limtqgpnlsihkgkm")
    public suspend
    fun claims(argument: suspend RuleManagementEventClaimsDataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = RuleManagementEventClaimsDataSourceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.claims = mapped
    }

    /**
     * @param value the event name.
     */
    @JvmName("krmcqoqwmkpytrne")
    public suspend fun eventName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventName = mapped
    }

    /**
     * @param value the event source.
     */
    @JvmName("wbdhfhmiwivucykw")
    public suspend fun eventSource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventSource = mapped
    }

    /**
     * @param value the legacy resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
     */
    @JvmName("wfnetigtywbxiaun")
    public suspend fun legacyResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.legacyResourceId = mapped
    }

    /**
     * @param value the level.
     */
    @JvmName("uqgjtcoyartdeues")
    public suspend fun level(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value the namespace of the metric.
     */
    @JvmName("fejmyrlcmtikbfbd")
    public suspend fun metricNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricNamespace = mapped
    }

    /**
     * @param value specifies the type of data source. There are two types of rule data sources: RuleMetricDataSource and RuleManagementEventDataSource
     * Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource'.
     */
    @JvmName("sviefeukkufhlucy")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value The name of the operation that should be checked for. If no name is provided, any operation will match.
     */
    @JvmName("ffbksuypswyonamg")
    public suspend fun operationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operationName = mapped
    }

    /**
     * @param value the resource group name.
     */
    @JvmName("oraymoeracshuket")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value the location of the resource.
     */
    @JvmName("hcspcpikcylrcggs")
    public suspend fun resourceLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceLocation = mapped
    }

    /**
     * @param value the resource provider name.
     */
    @JvmName("crulinvolaxkafvl")
    public suspend fun resourceProviderName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceProviderName = mapped
    }

    /**
     * @param value the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
     */
    @JvmName("qjcknokahnggppdi")
    public suspend fun resourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUri = mapped
    }

    /**
     * @param value The status of the operation that should be checked for. If no status is provided, any status will match.
     */
    @JvmName("kuynmruxpattjjvd")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value the substatus.
     */
    @JvmName("gmsnvxcqlwsqhnmv")
    public suspend fun subStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subStatus = mapped
    }

    internal fun build(): RuleManagementEventDataSourceArgs = RuleManagementEventDataSourceArgs(
        claims = claims,
        eventName = eventName,
        eventSource = eventSource,
        legacyResourceId = legacyResourceId,
        level = level,
        metricNamespace = metricNamespace,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        operationName = operationName,
        resourceGroupName = resourceGroupName,
        resourceLocation = resourceLocation,
        resourceProviderName = resourceProviderName,
        resourceUri = resourceUri,
        status = status,
        subStatus = subStatus,
    )
}
