@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.WebTestPropertiesRequestArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The collection of request properties
 * @property followRedirects Follow redirects for this web test.
 * @property headers List of headers and their values to add to the WebTest call.
 * @property httpVerb Http verb to use for this web test.
 * @property parseDependentRequests Parse Dependent request for this WebTest.
 * @property requestBody Base64 encoded string body to send with this web test.
 * @property requestUrl Url location to test.
 */
public data class WebTestPropertiesRequestArgs(
    public val followRedirects: Output<Boolean>? = null,
    public val headers: Output<List<HeaderFieldArgs>>? = null,
    public val httpVerb: Output<String>? = null,
    public val parseDependentRequests: Output<Boolean>? = null,
    public val requestBody: Output<String>? = null,
    public val requestUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.WebTestPropertiesRequestArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.WebTestPropertiesRequestArgs =
        com.pulumi.azurenative.insights.inputs.WebTestPropertiesRequestArgs.builder()
            .followRedirects(followRedirects?.applyValue({ args0 -> args0 }))
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .httpVerb(httpVerb?.applyValue({ args0 -> args0 }))
            .parseDependentRequests(parseDependentRequests?.applyValue({ args0 -> args0 }))
            .requestBody(requestBody?.applyValue({ args0 -> args0 }))
            .requestUrl(requestUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebTestPropertiesRequestArgs].
 */
@PulumiTagMarker
public class WebTestPropertiesRequestArgsBuilder internal constructor() {
    private var followRedirects: Output<Boolean>? = null

    private var headers: Output<List<HeaderFieldArgs>>? = null

    private var httpVerb: Output<String>? = null

    private var parseDependentRequests: Output<Boolean>? = null

    private var requestBody: Output<String>? = null

    private var requestUrl: Output<String>? = null

    /**
     * @param value Follow redirects for this web test.
     */
    @JvmName("qbacqmfsgtbsutnl")
    public suspend fun followRedirects(`value`: Output<Boolean>) {
        this.followRedirects = value
    }

    /**
     * @param value List of headers and their values to add to the WebTest call.
     */
    @JvmName("frfbflpwleegmqcy")
    public suspend fun headers(`value`: Output<List<HeaderFieldArgs>>) {
        this.headers = value
    }

    @JvmName("gobxxwwgvoaoaaoa")
    public suspend fun headers(vararg values: Output<HeaderFieldArgs>) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values List of headers and their values to add to the WebTest call.
     */
    @JvmName("osjkxmqlatdnxejk")
    public suspend fun headers(values: List<Output<HeaderFieldArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value Http verb to use for this web test.
     */
    @JvmName("erfhonuwcrrmkove")
    public suspend fun httpVerb(`value`: Output<String>) {
        this.httpVerb = value
    }

    /**
     * @param value Parse Dependent request for this WebTest.
     */
    @JvmName("whhbmrbtqewrmvma")
    public suspend fun parseDependentRequests(`value`: Output<Boolean>) {
        this.parseDependentRequests = value
    }

    /**
     * @param value Base64 encoded string body to send with this web test.
     */
    @JvmName("iurtanrlkynkxixv")
    public suspend fun requestBody(`value`: Output<String>) {
        this.requestBody = value
    }

    /**
     * @param value Url location to test.
     */
    @JvmName("cmgeeptneyqqqwdt")
    public suspend fun requestUrl(`value`: Output<String>) {
        this.requestUrl = value
    }

    /**
     * @param value Follow redirects for this web test.
     */
    @JvmName("textgrcnybxhbpvg")
    public suspend fun followRedirects(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.followRedirects = mapped
    }

    /**
     * @param value List of headers and their values to add to the WebTest call.
     */
    @JvmName("whqfqfojfslgxvep")
    public suspend fun headers(`value`: List<HeaderFieldArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument List of headers and their values to add to the WebTest call.
     */
    @JvmName("imjsmwysymwyqmcs")
    public suspend fun headers(argument: List<suspend HeaderFieldArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { HeaderFieldArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument List of headers and their values to add to the WebTest call.
     */
    @JvmName("cdtdxdscmcmbmwbi")
    public suspend fun headers(vararg argument: suspend HeaderFieldArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { HeaderFieldArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument List of headers and their values to add to the WebTest call.
     */
    @JvmName("mklqyataesbjvqok")
    public suspend fun headers(argument: suspend HeaderFieldArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(HeaderFieldArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values List of headers and their values to add to the WebTest call.
     */
    @JvmName("wcvudcolnogyoucl")
    public suspend fun headers(vararg values: HeaderFieldArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value Http verb to use for this web test.
     */
    @JvmName("ifccwnhyjsahucsy")
    public suspend fun httpVerb(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpVerb = mapped
    }

    /**
     * @param value Parse Dependent request for this WebTest.
     */
    @JvmName("qrujrswhwulxiumf")
    public suspend fun parseDependentRequests(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parseDependentRequests = mapped
    }

    /**
     * @param value Base64 encoded string body to send with this web test.
     */
    @JvmName("axmoiytjuhtmujej")
    public suspend fun requestBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestBody = mapped
    }

    /**
     * @param value Url location to test.
     */
    @JvmName("ryiygcplbgeawvrl")
    public suspend fun requestUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestUrl = mapped
    }

    internal fun build(): WebTestPropertiesRequestArgs = WebTestPropertiesRequestArgs(
        followRedirects = followRedirects,
        headers = headers,
        httpVerb = httpVerb,
        parseDependentRequests = parseDependentRequests,
        requestBody = requestBody,
        requestUrl = requestUrl,
    )
}
