@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.WebhookReceiverArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A webhook receiver.
 * @property identifierUri Indicates the identifier uri for aad auth.
 * @property name The name of the webhook receiver. Names must be unique across all receivers within a tenant action group.
 * @property objectId Indicates the webhook app object Id for aad auth.
 * @property serviceUri The URI where webhooks should be sent.
 * @property tenantId Indicates the tenant id for aad auth.
 * @property useAadAuth Indicates whether or not use AAD authentication.
 * @property useCommonAlertSchema Indicates whether to use common alert schema.
 */
public data class WebhookReceiverArgs(
    public val identifierUri: Output<String>? = null,
    public val name: Output<String>,
    public val objectId: Output<String>? = null,
    public val serviceUri: Output<String>,
    public val tenantId: Output<String>? = null,
    public val useAadAuth: Output<Boolean>? = null,
    public val useCommonAlertSchema: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.insights.inputs.WebhookReceiverArgs> {
    override fun toJava(): com.pulumi.azurenative.insights.inputs.WebhookReceiverArgs =
        com.pulumi.azurenative.insights.inputs.WebhookReceiverArgs.builder()
            .identifierUri(identifierUri?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .objectId(objectId?.applyValue({ args0 -> args0 }))
            .serviceUri(serviceUri.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 }))
            .useAadAuth(useAadAuth?.applyValue({ args0 -> args0 }))
            .useCommonAlertSchema(useCommonAlertSchema?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebhookReceiverArgs].
 */
@PulumiTagMarker
public class WebhookReceiverArgsBuilder internal constructor() {
    private var identifierUri: Output<String>? = null

    private var name: Output<String>? = null

    private var objectId: Output<String>? = null

    private var serviceUri: Output<String>? = null

    private var tenantId: Output<String>? = null

    private var useAadAuth: Output<Boolean>? = null

    private var useCommonAlertSchema: Output<Boolean>? = null

    /**
     * @param value Indicates the identifier uri for aad auth.
     */
    @JvmName("ardtmtiwdyysowwk")
    public suspend fun identifierUri(`value`: Output<String>) {
        this.identifierUri = value
    }

    /**
     * @param value The name of the webhook receiver. Names must be unique across all receivers within a tenant action group.
     */
    @JvmName("ulutexkubevqqmsq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Indicates the webhook app object Id for aad auth.
     */
    @JvmName("hpshwhjsiyukvtie")
    public suspend fun objectId(`value`: Output<String>) {
        this.objectId = value
    }

    /**
     * @param value The URI where webhooks should be sent.
     */
    @JvmName("elyoxelmbakvdseq")
    public suspend fun serviceUri(`value`: Output<String>) {
        this.serviceUri = value
    }

    /**
     * @param value Indicates the tenant id for aad auth.
     */
    @JvmName("lwhbgvuofbiiwfpo")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Indicates whether or not use AAD authentication.
     */
    @JvmName("yapnjvccqijfpibi")
    public suspend fun useAadAuth(`value`: Output<Boolean>) {
        this.useAadAuth = value
    }

    /**
     * @param value Indicates whether to use common alert schema.
     */
    @JvmName("sitxsynxpnnyufjb")
    public suspend fun useCommonAlertSchema(`value`: Output<Boolean>) {
        this.useCommonAlertSchema = value
    }

    /**
     * @param value Indicates the identifier uri for aad auth.
     */
    @JvmName("vfwwiaqoqtuuocfi")
    public suspend fun identifierUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identifierUri = mapped
    }

    /**
     * @param value The name of the webhook receiver. Names must be unique across all receivers within a tenant action group.
     */
    @JvmName("mxbvnsphsscqcsrl")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Indicates the webhook app object Id for aad auth.
     */
    @JvmName("kfyypspojsttjrab")
    public suspend fun objectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectId = mapped
    }

    /**
     * @param value The URI where webhooks should be sent.
     */
    @JvmName("pknbmjwkjcamoumx")
    public suspend fun serviceUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceUri = mapped
    }

    /**
     * @param value Indicates the tenant id for aad auth.
     */
    @JvmName("foyfcnrgsrgpqqpj")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    /**
     * @param value Indicates whether or not use AAD authentication.
     */
    @JvmName("lqgaxifmcyvsamwi")
    public suspend fun useAadAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useAadAuth = mapped
    }

    /**
     * @param value Indicates whether to use common alert schema.
     */
    @JvmName("bdxuodpwralucyff")
    public suspend fun useCommonAlertSchema(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useCommonAlertSchema = mapped
    }

    internal fun build(): WebhookReceiverArgs = WebhookReceiverArgs(
        identifierUri = identifierUri,
        name = name ?: throw PulumiNullFieldException("name"),
        objectId = objectId,
        serviceUri = serviceUri ?: throw PulumiNullFieldException("serviceUri"),
        tenantId = tenantId,
        useAadAuth = useAadAuth,
        useCommonAlertSchema = useCommonAlertSchema,
    )
}
