@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.inputs

import com.pulumi.azurenative.insights.inputs.WebtestLocationAvailabilityCriteriaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies the metric alert rule criteria for a web test resource.
 * @property componentId The Application Insights resource Id.
 * @property failedLocationCount The number of failed locations.
 * @property odataType specifies the type of the alert criteria.
 * Expected value is 'Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria'.
 * @property webTestId The Application Insights web test Id.
 */
public data class WebtestLocationAvailabilityCriteriaArgs(
    public val componentId: Output<String>,
    public val failedLocationCount: Output<Double>,
    public val odataType: Output<String>,
    public val webTestId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.insights.inputs.WebtestLocationAvailabilityCriteriaArgs> {
    override fun toJava():
        com.pulumi.azurenative.insights.inputs.WebtestLocationAvailabilityCriteriaArgs =
        com.pulumi.azurenative.insights.inputs.WebtestLocationAvailabilityCriteriaArgs.builder()
            .componentId(componentId.applyValue({ args0 -> args0 }))
            .failedLocationCount(failedLocationCount.applyValue({ args0 -> args0 }))
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .webTestId(webTestId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebtestLocationAvailabilityCriteriaArgs].
 */
@PulumiTagMarker
public class WebtestLocationAvailabilityCriteriaArgsBuilder internal constructor() {
    private var componentId: Output<String>? = null

    private var failedLocationCount: Output<Double>? = null

    private var odataType: Output<String>? = null

    private var webTestId: Output<String>? = null

    /**
     * @param value The Application Insights resource Id.
     */
    @JvmName("vtwmsixixfqwpwjx")
    public suspend fun componentId(`value`: Output<String>) {
        this.componentId = value
    }

    /**
     * @param value The number of failed locations.
     */
    @JvmName("sttxlvoakwnfgbrv")
    public suspend fun failedLocationCount(`value`: Output<Double>) {
        this.failedLocationCount = value
    }

    /**
     * @param value specifies the type of the alert criteria.
     * Expected value is 'Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria'.
     */
    @JvmName("ugqqkjxicdrsmput")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The Application Insights web test Id.
     */
    @JvmName("shmmoqdwmrbhtfqd")
    public suspend fun webTestId(`value`: Output<String>) {
        this.webTestId = value
    }

    /**
     * @param value The Application Insights resource Id.
     */
    @JvmName("pvnxiuqravijbxwd")
    public suspend fun componentId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.componentId = mapped
    }

    /**
     * @param value The number of failed locations.
     */
    @JvmName("mvigtudjcjoyorsg")
    public suspend fun failedLocationCount(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failedLocationCount = mapped
    }

    /**
     * @param value specifies the type of the alert criteria.
     * Expected value is 'Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria'.
     */
    @JvmName("xnfxratgubmmxges")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value The Application Insights web test Id.
     */
    @JvmName("xlsymjmhuvxyhggq")
    public suspend fun webTestId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.webTestId = mapped
    }

    internal fun build(): WebtestLocationAvailabilityCriteriaArgs =
        WebtestLocationAvailabilityCriteriaArgs(
            componentId = componentId ?: throw PulumiNullFieldException("componentId"),
            failedLocationCount = failedLocationCount ?: throw PulumiNullFieldException("failedLocationCount"),
            odataType = odataType ?: throw PulumiNullFieldException("odataType"),
            webTestId = webTestId ?: throw PulumiNullFieldException("webTestId"),
        )
}
